/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.xml;

import java.io.BufferedInputStream;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class ImportXmlFromInputStream
implements Command {
    private String inputStreamKey = "inputStream";
    private String persistentKey = "persistent";
    private String destJcrPathKey = "destJcrPath";
    private String uuidBehaviourKey = "uuidBehaviour";

    @Override
    public boolean execute(Context ctx) throws Exception {
        InputStream is = (InputStream)ctx.get(this.inputStreamKey);
        String dest = (String)ctx.get(this.destJcrPathKey);
        String persistent = (String)ctx.get(this.persistentKey);
        int uuidBehaviour = Integer.valueOf((String)ctx.get(this.uuidBehaviourKey));
        BufferedInputStream bis = new BufferedInputStream(is);
        Session s = CommandHelper.getSession(ctx);
        Node n = CommandHelper.getNode(ctx, dest);
        if (persistent != null && Boolean.valueOf(persistent).equals(Boolean.TRUE)) {
            s.getWorkspace().importXML(n.getPath(), bis, uuidBehaviour);
        } else {
            s.importXML(n.getPath(), bis, uuidBehaviour);
        }
        return false;
    }

    public String getUuidBehaviourKey() {
        return this.uuidBehaviourKey;
    }

    public void setUuidBehaviourKey(String uuidBehaviourKey) {
        this.uuidBehaviourKey = uuidBehaviourKey;
    }

    public String getDestJcrPathKey() {
        return this.destJcrPathKey;
    }

    public void setDestJcrPathKey(String destJcrPathKey) {
        this.destJcrPathKey = destJcrPathKey;
    }

    public String getInputStreamKey() {
        return this.inputStreamKey;
    }

    public void setInputStreamKey(String inputStreamKey) {
        this.inputStreamKey = inputStreamKey;
    }

    public String getPersistentKey() {
        return this.persistentKey;
    }

    public void setPersistentKey(String persistentKey) {
        this.persistentKey = persistentKey;
    }
}

