/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.commons.repository.RepositoryFactory;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.j2ee.BootstrapConfig;
import org.apache.jackrabbit.j2ee.Installer;
import org.apache.jackrabbit.j2ee.JNDIConfig;
import org.apache.jackrabbit.j2ee.ServletExceptionWithCause;
import org.apache.jackrabbit.servlet.AbstractRepositoryServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class RepositoryStartupServlet
extends AbstractRepositoryServlet {
    private static final Logger log = LoggerFactory.getLogger(RepositoryStartupServlet.class);
    private static final String CTX_PARAM_THIS = "repository.startup.servet";
    public static final String INIT_PARAM_BOOTSTRAP_CONFIG = "bootstrap-config";
    static String bootstrapOverride = null;
    private Repository repository;
    private InitialContext jndiContext;
    private File bootstrapConfigFile;
    private BootstrapConfig config;

    @Override
    public void init() throws ServletException {
        super.init();
        if (this.getServletContext().getAttribute(CTX_PARAM_THIS) != null) {
            throw new ServletException("Only one repository startup servlet allowed per web-app.");
        }
        this.getServletContext().setAttribute(CTX_PARAM_THIS, this);
        this.startup();
    }

    public static RepositoryStartupServlet getInstance(ServletContext context) {
        return (RepositoryStartupServlet)context.getAttribute(CTX_PARAM_THIS);
    }

    public void startup() throws ServletException {
        if (this.repository != null) {
            log.error("Startup: Repository already running.");
            throw new ServletException("Repository already running.");
        }
        log.info("RepositoryStartupServlet initializing...");
        try {
            if (this.configure()) {
                this.initRepository();
                this.registerJNDI();
            }
            log.info("RepositoryStartupServlet initialized.");
        }
        catch (ServletException e) {
            this.shutdownRepository();
            log.error("RepositoryStartupServlet initializing failed: " + e, e);
        }
    }

    public void shutdown() {
        if (this.repository == null) {
            log.info("Shutdown: Repository already stopped.");
        } else {
            log.info("RepositoryStartupServlet shutting down...");
            this.shutdownRepository();
            this.unregisterJNDI();
            log.info("RepositoryStartupServlet shut down.");
        }
    }

    public void restart() throws ServletException {
        if (this.repository != null) {
            this.shutdown();
        }
        this.startup();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.shutdown();
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    public RepositoryFactory getRepositoryFactory() {
        return new RepositoryFactory(){

            @Override
            public Repository getRepository() throws RepositoryException {
                Repository r = RepositoryStartupServlet.this.repository;
                if (r != null) {
                    return RepositoryStartupServlet.this.repository;
                }
                throw new RepositoryException("Repository not available");
            }
        };
    }

    private boolean configure() throws ServletException {
        Properties bootstrapProps = new Properties();
        String bstrp = bootstrapOverride;
        if (bstrp == null) {
            bstrp = this.getServletConfig().getInitParameter(INIT_PARAM_BOOTSTRAP_CONFIG);
        }
        if (bstrp != null) {
            InputStream in = this.getServletContext().getResourceAsStream(bstrp);
            if (in == null) {
                this.bootstrapConfigFile = new File(bstrp);
                if (this.bootstrapConfigFile.canRead()) {
                    try {
                        in = new FileInputStream(this.bootstrapConfigFile);
                    }
                    catch (FileNotFoundException e) {
                        throw new ServletExceptionWithCause("Bootstrap configuration not found: " + bstrp, e);
                    }
                }
            }
            if (in != null) {
                try {
                    bootstrapProps.load(in);
                }
                catch (IOException e) {
                    throw new ServletException("Bootstrap configuration failure: " + bstrp, e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.config = new BootstrapConfig();
        this.config.init(this.getServletConfig());
        this.config.init(bootstrapProps);
        this.config.validate();
        if (!this.config.isValid() || this.config.getRepositoryHome() == null) {
            if (bstrp == null) {
                log.error("Repository startup configuration is not valid.");
            } else {
                log.error("Repository startup configuration is not valid but a bootstrap config is specified.");
                log.error("Either create the {} file or", (Object)bstrp);
                log.error("use the '/config/index.jsp' for easy configuration.");
            }
            return false;
        }
        this.config.logInfos();
        return true;
    }

    private void initRepository() throws ServletException {
        File repHome;
        try {
            repHome = new File(this.config.getRepositoryHome()).getCanonicalFile();
        }
        catch (IOException e) {
            throw new ServletExceptionWithCause("Repository configuration failure: " + this.config.getRepositoryHome(), e);
        }
        String repConfig = this.config.getRepositoryConfig();
        if (repConfig != null) {
            InputStream in = this.getServletContext().getResourceAsStream(repConfig);
            if (in == null) {
                try {
                    in = new FileInputStream(new File(repConfig));
                }
                catch (FileNotFoundException e) {
                    try {
                        in = new FileInputStream(new File(repHome, repConfig));
                    }
                    catch (FileNotFoundException e1) {
                        throw new ServletExceptionWithCause("Repository configuration not found: " + repConfig, e);
                    }
                }
            }
            try {
                this.repository = this.createRepository(new InputSource(in), repHome);
            }
            catch (RepositoryException e) {
                throw new ServletExceptionWithCause("Error while creating repository", e);
            }
        }
        throw new ServletException("Missing configuration");
    }

    private void shutdownRepository() {
        if (this.repository instanceof JackrabbitRepository) {
            ((JackrabbitRepository)this.repository).shutdown();
        }
        this.repository = null;
    }

    protected Repository createRepository(InputSource is, File homedir) throws RepositoryException {
        RepositoryConfig config = RepositoryConfig.create(is, homedir.getAbsolutePath());
        return RepositoryImpl.create(config);
    }

    private void registerJNDI() throws ServletException {
        JNDIConfig jc = this.config.getJndiConfig();
        if (jc.isValid() && jc.enabled()) {
            try {
                this.jndiContext = new InitialContext(jc.getJndiEnv());
                this.jndiContext.bind(jc.getJndiName(), (Object)this.repository);
                log.info("Repository bound to JNDI with name: " + jc.getJndiName());
            }
            catch (NamingException e) {
                throw new ServletExceptionWithCause("Unable to bind repository using JNDI: " + jc.getJndiName(), e);
            }
        }
    }

    private void unregisterJNDI() {
        if (this.jndiContext != null) {
            try {
                this.jndiContext.unbind(this.config.getJndiConfig().getJndiName());
            }
            catch (NamingException e) {
                this.log("Error while unbinding repository from JNDI: " + e);
            }
        }
    }

    public BootstrapConfig getBootstrapConfig() {
        return this.config;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.repository == null) {
            this.redirect(req, resp, "/bootstrap/missing.jsp");
        } else {
            this.redirect(req, resp, "/bootstrap/running.jsp");
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.repository != null) {
            this.redirect(req, resp, "/bootstrap/reconfigure.jsp");
        } else {
            int rc = new Installer(this.bootstrapConfigFile, this.getServletContext()).installRepository(req);
            switch (rc) {
                case 0: {
                    this.restart();
                    if (this.repository == null) {
                        this.redirect(req, resp, "/bootstrap/error.jsp");
                        break;
                    }
                    this.redirect(req, resp, "/bootstrap/success.jsp");
                    break;
                }
                case 1: {
                    this.redirect(req, resp, "/bootstrap/missing.jsp");
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.redirect(req, resp, "/bootstrap/exists.jsp");
                    break;
                }
                case 3: 
                case 5: {
                    this.redirect(req, resp, "/bootstrap/notexists.jsp");
                    break;
                }
                case 7: {
                    this.redirect(req, resp, "/bootstrap/error.jsp");
                }
            }
        }
    }

    private void redirect(HttpServletRequest req, HttpServletResponse resp, String loc) throws IOException {
        String cp = req.getContextPath();
        if (cp == null || cp.equals("/")) {
            cp = "";
        }
        resp.sendRedirect(cp + loc);
    }
}

