/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Row;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.FullTextSearchScore;
import javax.jcr.query.qom.Length;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.SameNode;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.query.qom.UpperCase;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.apache.jackrabbit.commons.predicate.Predicates;
import org.apache.jackrabbit.commons.predicate.RowPredicate;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.CaseTermQuery;
import org.apache.jackrabbit.core.query.lucene.CloseableHits;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DecimalField;
import org.apache.jackrabbit.core.query.lucene.DescendantSelfAxisQuery;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.JackrabbitQueryParser;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTermQuery;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NotQuery;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.RangeQuery;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.WildcardQuery;
import org.apache.jackrabbit.core.query.lucene.join.SelectorRow;
import org.apache.jackrabbit.core.query.lucene.join.ValueComparator;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.query.qom.FullTextSearchImpl;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyExistenceImpl;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class LuceneQueryFactory {
    protected final SessionImpl session;
    protected final NodeTypeManager ntManager;
    protected final SearchIndex index;
    protected final NamespaceMappings nsMappings;
    protected final NamePathResolver npResolver;
    protected final OperandEvaluator evaluator;
    protected final String mixinTypesField;
    protected final String primaryTypeField;
    private final PerQueryCache cache = new PerQueryCache();

    public LuceneQueryFactory(SessionImpl session, SearchIndex index, Map<String, Value> bindVariables) throws RepositoryException {
        this.session = session;
        this.ntManager = session.getWorkspace().getNodeTypeManager();
        this.index = index;
        this.nsMappings = index.getNamespaceMappings();
        this.npResolver = NamePathResolverImpl.create(this.nsMappings);
        this.evaluator = new OperandEvaluator(session.getValueFactory(), bindVariables);
        this.mixinTypesField = this.nsMappings.translateName(NameConstants.JCR_MIXINTYPES);
        this.primaryTypeField = this.nsMappings.translateName(NameConstants.JCR_PRIMARYTYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> execute(Map<String, PropertyValue> columns, Selector selector, Constraint constraint, Sort sort, boolean externalSort, long offsetIn, long limitIn) throws RepositoryException, IOException {
        IndexReader reader = this.index.getIndexReader(true);
        int offset = offsetIn < 0L ? 0 : (int)offsetIn;
        int limit = limitIn < 0L ? Integer.MAX_VALUE : (int)limitIn;
        CloseableHits hits = null;
        try {
            JackrabbitIndexSearcher searcher = new JackrabbitIndexSearcher(this.session, reader, this.index.getContext().getItemStateManager());
            searcher.setSimilarity(this.index.getSimilarity());
            Predicate filter = Predicate.TRUE;
            BooleanQuery query = new BooleanQuery();
            QueryPair qp = new QueryPair(query);
            query.add(this.create(selector), BooleanClause.Occur.MUST);
            if (constraint != null) {
                String name = selector.getSelectorName();
                NodeType type = this.ntManager.getNodeType(selector.getNodeTypeName());
                filter = this.mapConstraintToQueryAndFilter(qp, constraint, Collections.singletonMap(name, type), searcher, reader);
            }
            ArrayList<Row> rows = new ArrayList<Row>();
            hits = searcher.evaluate(qp.mainQuery, sort, offset + limit);
            int currentNode = 0;
            int addedNodes = 0;
            ScoreNode node = hits.nextScoreNode();
            while (node != null) {
                SelectorRow row = null;
                try {
                    row = new SelectorRow(columns, this.evaluator, selector.getSelectorName(), this.session.getNodeById(node.getNodeId()), node.getScore());
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
                if (row != null && filter.evaluate(row)) {
                    if (externalSort) {
                        rows.add(row);
                    } else {
                        if (currentNode >= offset && currentNode - offset < limit) {
                            rows.add(row);
                            ++addedNodes;
                        }
                        ++currentNode;
                        if (addedNodes == limit) break;
                    }
                }
                node = hits.nextScoreNode();
            }
            ArrayList<Row> arrayList = rows;
            return arrayList;
        }
        finally {
            if (hits != null) {
                hits.close();
            }
            Util.closeOrRelease(reader);
        }
    }

    public Query create(Selector selector) throws RepositoryException {
        ArrayList<Term> terms = new ArrayList<Term>();
        String name = selector.getNodeTypeName();
        NodeTypeIterator allTypes = this.ntManager.getAllNodeTypes();
        while (allTypes.hasNext()) {
            NodeType nt = allTypes.nextNodeType();
            if (!nt.isNodeType(name)) continue;
            terms.add(this.createNodeTypeTerm(nt));
        }
        if (terms.size() == 1) {
            return new JackrabbitTermQuery((Term)terms.get(0));
        }
        BooleanQuery b = new BooleanQuery();
        for (Term term : terms) {
            b.add(new JackrabbitTermQuery(term), BooleanClause.Occur.SHOULD);
        }
        return b;
    }

    protected Term createNodeTypeTerm(NodeType type) throws RepositoryException {
        String field = type.isMixin() ? this.mixinTypesField : this.primaryTypeField;
        String name = this.nsMappings.translateName(this.session.getQName(type.getName()));
        return new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, name));
    }

    public Query create(FullTextSearchImpl fts) throws RepositoryException {
        String fieldname;
        if (fts.getPropertyName() == null) {
            fieldname = FieldNames.FULLTEXT;
        } else {
            Name propName = fts.getPropertyQName();
            StringBuffer tmp = new StringBuffer();
            tmp.append(this.nsMappings.getPrefix(propName.getNamespaceURI()));
            tmp.append(":").append("FULL:");
            tmp.append(propName.getLocalName());
            fieldname = tmp.toString();
        }
        JackrabbitQueryParser parser = new JackrabbitQueryParser(fieldname, this.index.getTextAnalyzer(), this.index.getSynonymProvider(), this.cache);
        try {
            StaticOperand expr = fts.getFullTextSearchExpression();
            return ((QueryParser)parser).parse(this.evaluator.getValue(expr).getString());
        }
        catch (ParseException e) {
            throw new RepositoryException(e);
        }
    }

    public Query create(PropertyExistenceImpl prop) throws RepositoryException {
        String propName = this.npResolver.getJCRName(prop.getPropertyQName());
        return Util.createMatchAllQuery(propName, this.index.getIndexFormatVersion(), this.cache);
    }

    protected Predicate mapConstraintToQueryAndFilter(QueryPair query, Constraint constraint, Map<String, NodeType> selectorMap, JackrabbitIndexSearcher searcher, IndexReader reader) throws RepositoryException, IOException {
        Predicate filter = Predicate.TRUE;
        if (constraint instanceof And) {
            And and = (And)constraint;
            filter = this.mapConstraintToQueryAndFilter(query, and.getConstraint1(), selectorMap, searcher, reader);
            Predicate other = this.mapConstraintToQueryAndFilter(query, and.getConstraint2(), selectorMap, searcher, reader);
            if (filter == Predicate.TRUE) {
                filter = other;
            } else if (other != Predicate.TRUE) {
                filter = Predicates.and(filter, other);
            }
        } else if (constraint instanceof Comparison) {
            Comparison c = (Comparison)constraint;
            Transform transform = new Transform(c.getOperand1());
            DynamicOperand left = transform.operand;
            final String operator2 = c.getOperator();
            StaticOperand right = c.getOperand2();
            if (left instanceof Length || left instanceof FullTextSearchScore || (!"jcr.operator.equal.to".equals(operator2) && !"jcr.operator.like".equals(operator2) || transform.transform != 0) && (left instanceof NodeName || left instanceof NodeLocalName)) {
                try {
                    int type = 0;
                    if (left instanceof Length) {
                        type = 3;
                    } else if (left instanceof FullTextSearchScore) {
                        type = 4;
                    }
                    final DynamicOperand operand = c.getOperand1();
                    final Value value = this.evaluator.getValue(right, type);
                    filter = new RowPredicate(){

                        @Override
                        protected boolean evaluate(Row row) throws RepositoryException {
                            return new ValueComparator().evaluate(operator2, LuceneQueryFactory.this.evaluator.getValue(operand, row), value);
                        }
                    };
                }
                catch (ValueFormatException e) {
                    throw new InvalidQueryException(e);
                }
            } else {
                Query cq = this.getComparisonQuery(left, transform.transform, operator2, right, selectorMap);
                query.subQuery.add(cq, BooleanClause.Occur.MUST);
            }
        } else if (constraint instanceof DescendantNode) {
            DescendantNode descendantNode = (DescendantNode)constraint;
            Query context = this.getNodeIdQuery(FieldNames.UUID, descendantNode.getAncestorPath());
            query.mainQuery = new DescendantSelfAxisQuery(context, (Query)query.subQuery, false);
        } else {
            query.subQuery.add(this.create(constraint, selectorMap, searcher), BooleanClause.Occur.MUST);
        }
        return filter;
    }

    protected Query create(Constraint constraint, Map<String, NodeType> selectorMap, JackrabbitIndexSearcher searcher) throws RepositoryException, IOException {
        if (constraint instanceof And) {
            return this.getAndQuery((And)constraint, selectorMap, searcher);
        }
        if (constraint instanceof Or) {
            return this.getOrQuery((Or)constraint, selectorMap, searcher);
        }
        if (constraint instanceof Not) {
            return this.getNotQuery((Not)constraint, selectorMap, searcher);
        }
        if (constraint instanceof PropertyExistence) {
            return this.getPropertyExistenceQuery((PropertyExistence)constraint);
        }
        if (constraint instanceof Comparison) {
            Comparison c = (Comparison)constraint;
            Transform left = new Transform(c.getOperand1());
            return this.getComparisonQuery(left.operand, left.transform, c.getOperator(), c.getOperand2(), selectorMap);
        }
        if (constraint instanceof FullTextSearch) {
            return this.getFullTextSearchQuery((FullTextSearch)constraint);
        }
        if (constraint instanceof SameNode) {
            SameNode sn = (SameNode)constraint;
            return this.getNodeIdQuery(FieldNames.UUID, sn.getPath());
        }
        if (constraint instanceof ChildNode) {
            ChildNode cn = (ChildNode)constraint;
            return this.getNodeIdQuery(FieldNames.PARENT, cn.getParentPath());
        }
        if (constraint instanceof DescendantNode) {
            DescendantNode dn = (DescendantNode)constraint;
            return this.getDescendantNodeQuery(dn, searcher);
        }
        throw new UnsupportedRepositoryOperationException("Unknown constraint type: " + constraint);
    }

    protected Query getDescendantNodeQuery(DescendantNode dn, JackrabbitIndexSearcher searcher) throws RepositoryException, IOException {
        BooleanQuery query = new BooleanQuery();
        int clauses = 0;
        try {
            LinkedList<String> ids = new LinkedList<String>();
            Node ancestor = this.session.getNode(dn.getAncestorPath());
            ids.add(ancestor.getIdentifier());
            while (!ids.isEmpty()) {
                String id = (String)ids.removeFirst();
                JackrabbitTermQuery q = new JackrabbitTermQuery(new Term(FieldNames.PARENT, id));
                QueryHits hits = searcher.evaluate(q);
                ScoreNode sn = hits.nextScoreNode();
                if (sn == null) continue;
                if (++clauses == BooleanQuery.getMaxClauseCount()) {
                    BooleanQuery wrapQ = new BooleanQuery();
                    wrapQ.add(query, BooleanClause.Occur.SHOULD);
                    query = wrapQ;
                    clauses = 1;
                }
                query.add(q, BooleanClause.Occur.SHOULD);
                do {
                    ids.add(sn.getNodeId().toString());
                } while ((sn = hits.nextScoreNode()) != null);
            }
        }
        catch (PathNotFoundException e) {
            query.add(new JackrabbitTermQuery(new Term(FieldNames.UUID, "invalid-node-id")), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    protected Query getFullTextSearchQuery(FullTextSearch fts) throws RepositoryException {
        Object field = FieldNames.FULLTEXT;
        String property = fts.getPropertyName();
        if (property != null) {
            Name name = this.session.getQName(property);
            field = this.nsMappings.getPrefix(name.getNamespaceURI()) + ":FULL:" + name.getLocalName();
        }
        StaticOperand expression = fts.getFullTextSearchExpression();
        String query = this.evaluator.getValue(expression).getString();
        try {
            JackrabbitQueryParser parser = new JackrabbitQueryParser((String)field, this.index.getTextAnalyzer(), this.index.getSynonymProvider(), this.cache);
            return ((QueryParser)parser).parse(query);
        }
        catch (ParseException e) {
            throw new RepositoryException("Invalid full text search expression: " + query, e);
        }
    }

    protected BooleanQuery getAndQuery(And and, Map<String, NodeType> selectorMap, JackrabbitIndexSearcher searcher) throws RepositoryException, IOException {
        BooleanQuery query = new BooleanQuery();
        this.addBooleanConstraint(query, and.getConstraint1(), BooleanClause.Occur.MUST, selectorMap, searcher);
        this.addBooleanConstraint(query, and.getConstraint2(), BooleanClause.Occur.MUST, selectorMap, searcher);
        return query;
    }

    protected BooleanQuery getOrQuery(Or or, Map<String, NodeType> selectorMap, JackrabbitIndexSearcher searcher) throws RepositoryException, IOException {
        BooleanQuery query = new BooleanQuery();
        this.addBooleanConstraint(query, or.getConstraint1(), BooleanClause.Occur.SHOULD, selectorMap, searcher);
        this.addBooleanConstraint(query, or.getConstraint2(), BooleanClause.Occur.SHOULD, selectorMap, searcher);
        return query;
    }

    protected void addBooleanConstraint(BooleanQuery query, Constraint constraint, BooleanClause.Occur occur, Map<String, NodeType> selectorMap, JackrabbitIndexSearcher searcher) throws RepositoryException, IOException {
        if (occur == BooleanClause.Occur.MUST && constraint instanceof And) {
            And and = (And)constraint;
            this.addBooleanConstraint(query, and.getConstraint1(), occur, selectorMap, searcher);
            this.addBooleanConstraint(query, and.getConstraint2(), occur, selectorMap, searcher);
        } else if (occur == BooleanClause.Occur.SHOULD && constraint instanceof Or) {
            Or or = (Or)constraint;
            this.addBooleanConstraint(query, or.getConstraint1(), occur, selectorMap, searcher);
            this.addBooleanConstraint(query, or.getConstraint2(), occur, selectorMap, searcher);
        } else {
            query.add(this.create(constraint, selectorMap, searcher), occur);
        }
    }

    protected NotQuery getNotQuery(Not not, Map<String, NodeType> selectorMap, JackrabbitIndexSearcher searcher) throws RepositoryException, IOException {
        return new NotQuery(this.create(not.getConstraint(), selectorMap, searcher));
    }

    protected Query getPropertyExistenceQuery(PropertyExistence property) throws RepositoryException {
        String name = this.npResolver.getJCRName(this.session.getQName(property.getPropertyName()));
        return Util.createMatchAllQuery(name, this.index.getIndexFormatVersion(), this.cache);
    }

    protected Query getComparisonQuery(DynamicOperand left, int transform, String operator2, StaticOperand rigth, Map<String, NodeType> selectorMap) throws RepositoryException {
        if (left instanceof PropertyValue) {
            PropertyValue pv = (PropertyValue)left;
            String field = this.npResolver.getJCRName(this.session.getQName(pv.getPropertyName()));
            int type = 0;
            NodeType nt = selectorMap.get(pv.getSelectorName());
            if (nt != null) {
                for (PropertyDefinition pd : nt.getPropertyDefinitions()) {
                    if (!pd.getName().equals(pv.getPropertyName())) continue;
                    type = pd.getRequiredType();
                    break;
                }
            }
            return this.getPropertyValueQuery(field, operator2, this.evaluator.getValue(rigth), type, transform);
        }
        if (left instanceof NodeName) {
            return this.getNodeNameQuery(transform, operator2, rigth);
        }
        if (left instanceof NodeLocalName) {
            return this.getNodeLocalNameQuery(transform, operator2, rigth);
        }
        throw new UnsupportedRepositoryOperationException("Unknown operand type: " + left);
    }

    protected Query getNodeNameQuery(int transform, String operator2, StaticOperand right) throws RepositoryException {
        if (transform != 0 || !"jcr.operator.equal.to".equals(operator2)) {
            throw new UnsupportedRepositoryOperationException();
        }
        Value value = this.evaluator.getValue(right);
        int type = value.getType();
        String string = value.getString();
        if (type == 11 && string.startsWith("./")) {
            string = string.substring("./".length());
        } else if (type == 4 || type == 12 || type == 3 || type == 6 || type == 9 || type == 10) {
            throw new InvalidQueryException("Invalid name value: " + string);
        }
        try {
            Name name = this.session.getQName(string);
            Term uri = new Term(FieldNames.NAMESPACE_URI, name.getNamespaceURI());
            Term local = new Term(FieldNames.LOCAL_NAME, name.getLocalName());
            BooleanQuery query = new BooleanQuery();
            query.add(new JackrabbitTermQuery(uri), BooleanClause.Occur.MUST);
            query.add(new JackrabbitTermQuery(local), BooleanClause.Occur.MUST);
            return query;
        }
        catch (IllegalNameException e) {
            throw new InvalidQueryException("Illegal name: " + string, e);
        }
    }

    protected Query getNodeLocalNameQuery(int transform, String operator2, StaticOperand right) throws RepositoryException {
        if (!"jcr.operator.equal.to".equals(operator2) && !"jcr.operator.like".equals(operator2)) {
            throw new UnsupportedRepositoryOperationException();
        }
        String name = this.evaluator.getValue(right).getString();
        if ("jcr.operator.like".equals(operator2)) {
            return new WildcardQuery(FieldNames.LOCAL_NAME, null, name, transform, this.cache);
        }
        return new JackrabbitTermQuery(new Term(FieldNames.LOCAL_NAME, name));
    }

    protected Query getNodeIdQuery(String field, String path) throws RepositoryException {
        String value;
        try {
            value = this.session.getNode(path).getIdentifier();
        }
        catch (PathNotFoundException e) {
            value = "invalid-node-id";
        }
        return new JackrabbitTermQuery(new Term(field, value));
    }

    protected Query getPropertyValueQuery(String field, String operator2, Value value, int type, int transform) throws RepositoryException {
        String string = this.getValueString(value, type);
        if ("jcr.operator.like".equals(operator2)) {
            return new WildcardQuery(FieldNames.PROPERTIES, field, string, transform, this.cache);
        }
        Term term = this.getTerm(field, string);
        if ("jcr.operator.equal.to".equals(operator2)) {
            switch (transform) {
                case 2: {
                    return new CaseTermQuery.Upper(term);
                }
                case 1: {
                    return new CaseTermQuery.Lower(term);
                }
            }
            return new JackrabbitTermQuery(term);
        }
        if ("jcr.operator.greater.than".equals(operator2)) {
            return new RangeQuery(term, this.getTerm(field, "\uffff"), false, transform, this.cache);
        }
        if ("jcr.operator.greater.than.or.equal.to".equals(operator2)) {
            return new RangeQuery(term, this.getTerm(field, "\uffff"), true, transform, this.cache);
        }
        if ("jcr.operator.less.than".equals(operator2)) {
            return new RangeQuery(this.getTerm(field, ""), term, false, transform, this.cache);
        }
        if ("jcr.operator.less.than.or.equal.to".equals(operator2)) {
            return new RangeQuery(this.getTerm(field, ""), term, true, transform, this.cache);
        }
        if ("jcr.operator.not.equal.to".equals(operator2)) {
            BooleanQuery query = new BooleanQuery();
            query.add(Util.createMatchAllQuery(field, this.index.getIndexFormatVersion(), this.cache), BooleanClause.Occur.SHOULD);
            if (transform == 2) {
                query.add(new CaseTermQuery.Upper(term), BooleanClause.Occur.MUST_NOT);
            } else if (transform == 1) {
                query.add(new CaseTermQuery.Lower(term), BooleanClause.Occur.MUST_NOT);
            } else {
                query.add(new JackrabbitTermQuery(term), BooleanClause.Occur.MUST_NOT);
            }
            query.add(new JackrabbitTermQuery(new Term(FieldNames.MVP, field)), BooleanClause.Occur.MUST_NOT);
            return query;
        }
        throw new UnsupportedRepositoryOperationException();
    }

    protected Term getTerm(String field, String value) {
        return new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value));
    }

    protected String getValueString(Value value, int type) throws RepositoryException {
        switch (value.getType()) {
            case 5: {
                return DateField.dateToString(value.getDate().getTime());
            }
            case 4: {
                return DoubleField.doubleToString(value.getDouble());
            }
            case 3: {
                return LongField.longToString(value.getLong());
            }
            case 12: {
                return DecimalField.decimalToString(value.getDecimal());
            }
            case 7: {
                return this.npResolver.getJCRName(this.session.getQName(value.getString()));
            }
            case 8: {
                return this.npResolver.getJCRPath(this.session.getQPath(value.getString()));
            }
        }
        String string = value.getString();
        if (type != 0 && type != 1) {
            return this.getValueString(this.session.getValueFactory().createValue(string, type), 0);
        }
        return string;
    }

    protected static class QueryPair {
        Query mainQuery;
        BooleanQuery subQuery;

        QueryPair(BooleanQuery mainQuery) {
            this.mainQuery = mainQuery;
            this.subQuery = mainQuery;
        }
    }

    protected static class Transform {
        private final DynamicOperand operand;
        private final int transform;

        public Transform(DynamicOperand operand) {
            this.transform = operand instanceof UpperCase ? 2 : (operand instanceof LowerCase ? 1 : 0);
            while (true) {
                if (operand instanceof UpperCase) {
                    operand = ((UpperCase)operand).getOperand();
                    continue;
                }
                if (!(operand instanceof LowerCase)) break;
                operand = ((LowerCase)operand).getOperand();
            }
            this.operand = operand;
        }
    }
}

