/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIteratorImpl;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocOrderScoreNodeIterator
implements ScoreNodeIterator {
    private static final Logger log = LoggerFactory.getLogger(DocOrderScoreNodeIterator.class);
    private ScoreNodeIterator orderedNodes;
    private final List<ScoreNode[]> scoreNodes;
    protected final ItemManager itemMgr;
    private final int selectorIndex;

    DocOrderScoreNodeIterator(ItemManager itemMgr, List<ScoreNode[]> scoreNodes, int selectorIndex) {
        this.itemMgr = itemMgr;
        this.scoreNodes = scoreNodes;
        this.selectorIndex = selectorIndex;
    }

    public Object next() {
        return this.nextScoreNodes();
    }

    @Override
    public ScoreNode[] nextScoreNodes() {
        this.initOrderedIterator();
        return this.orderedNodes.nextScoreNodes();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void skip(long skipNum) {
        this.initOrderedIterator();
        this.orderedNodes.skip(skipNum);
    }

    @Override
    public long getSize() {
        if (this.orderedNodes != null) {
            return this.orderedNodes.getSize();
        }
        return this.scoreNodes.size();
    }

    @Override
    public long getPosition() {
        this.initOrderedIterator();
        return this.orderedNodes.getPosition();
    }

    @Override
    public boolean hasNext() {
        this.initOrderedIterator();
        return this.orderedNodes.hasNext();
    }

    private void initOrderedIterator() {
        if (this.orderedNodes != null) {
            return;
        }
        long time = System.currentTimeMillis();
        ScoreNode[][] nodes = (ScoreNode[][])this.scoreNodes.toArray((T[])new ScoreNode[this.scoreNodes.size()][]);
        final ArrayList invalidIDs = new ArrayList(2);
        do {
            if (invalidIDs.size() > 0) {
                ArrayList<ScoreNode[]> tmp = new ArrayList<ScoreNode[]>();
                for (ScoreNode[] node : nodes) {
                    if (invalidIDs.contains(node[this.selectorIndex].getNodeId())) continue;
                    tmp.add(node);
                }
                nodes = (ScoreNode[][])tmp.toArray((T[])new ScoreNode[tmp.size()][]);
                invalidIDs.clear();
            }
            try {
                Arrays.sort(nodes, new Comparator<ScoreNode[]>(){

                    @Override
                    public int compare(ScoreNode[] o1, ScoreNode[] o2) {
                        ScoreNode n1 = o1[DocOrderScoreNodeIterator.this.selectorIndex];
                        ScoreNode n2 = o2[DocOrderScoreNodeIterator.this.selectorIndex];
                        if (n1 == n2) {
                            return 0;
                        }
                        if (n1 == null) {
                            return -1;
                        }
                        if (n2 == null) {
                            return 1;
                        }
                        try {
                            int commonDepth;
                            NodeImpl node2;
                            NodeImpl node1;
                            try {
                                node1 = (NodeImpl)DocOrderScoreNodeIterator.this.itemMgr.getItem(n1.getNodeId());
                            }
                            catch (RepositoryException e) {
                                log.warn("Node " + n1.getNodeId() + " does not exist anymore: " + e);
                                invalidIDs.add(n1.getNodeId());
                                SortFailedException sfe = new SortFailedException();
                                sfe.initCause(e);
                                throw sfe;
                            }
                            try {
                                node2 = (NodeImpl)DocOrderScoreNodeIterator.this.itemMgr.getItem(n2.getNodeId());
                            }
                            catch (RepositoryException e) {
                                log.warn("Node " + n2.getNodeId() + " does not exist anymore: " + e);
                                invalidIDs.add(n2.getNodeId());
                                SortFailedException sfe = new SortFailedException();
                                sfe.initCause(e);
                                throw sfe;
                            }
                            Path.Element[] path1 = node1.getPrimaryPath().getElements();
                            Path.Element[] path2 = node2.getPrimaryPath().getElements();
                            for (commonDepth = 0; path1.length > commonDepth && path2.length > commonDepth && path1[commonDepth].equals(path2[commonDepth]); ++commonDepth) {
                            }
                            if (path1.length - 1 == --commonDepth) {
                                return -1;
                            }
                            if (path2.length - 1 == commonDepth) {
                                return 1;
                            }
                            NodeImpl commonNode = (NodeImpl)node1.getAncestor(commonDepth);
                            node1 = (NodeImpl)node1.getAncestor(commonDepth + 1);
                            node2 = (NodeImpl)node2.getAncestor(commonDepth + 1);
                            NodeIterator it = commonNode.getNodes();
                            while (it.hasNext()) {
                                Node child = it.nextNode();
                                if (child.isSame(node1)) {
                                    return -1;
                                }
                                if (!child.isSame(node2)) continue;
                                return 1;
                            }
                            log.error("Internal error: unable to determine document order of nodes:");
                            log.error("\tNode1: " + node1.getPath());
                            log.error("\tNode2: " + node2.getPath());
                        }
                        catch (RepositoryException e) {
                            log.error("Exception while sorting nodes in document order: " + e.toString(), e);
                        }
                        invalidIDs.add(n1.getNodeId());
                        invalidIDs.add(n2.getNodeId());
                        throw new SortFailedException();
                    }
                });
            }
            catch (SortFailedException sortFailedException) {
                // empty catch block
            }
        } while (invalidIDs.size() > 0);
        if (log.isDebugEnabled()) {
            log.debug(nodes.length + " node(s) ordered in " + (System.currentTimeMillis() - time) + " ms");
        }
        this.orderedNodes = new ScoreNodeIteratorImpl(nodes);
    }

    private static final class SortFailedException
    extends RuntimeException {
        private SortFailedException() {
        }
    }
}

