/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.cluster.ClusterException;
import org.apache.jackrabbit.core.cluster.Update;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.ConsistencyCheckerError;
import org.apache.jackrabbit.core.persistence.check.ConsistencyCheckListener;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReport;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReportImpl;
import org.apache.jackrabbit.core.persistence.check.ReportItem;
import org.apache.jackrabbit.core.persistence.util.NodeInfo;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.DummyUpdateEventChannel;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyCheckerImpl {
    private static Logger log = LoggerFactory.getLogger(ConsistencyCheckerImpl.class);
    private static final int NODESATONCE = Integer.getInteger("org.apache.jackrabbit.checker.nodesatonce", 8192);
    private static final String ATTRIBUTE_UPDATE_SIZE = "updateSize";
    private final AbstractBundlePersistenceManager pm;
    private final ConsistencyCheckListener listener;
    private NodeId lostNFoundId;
    private UpdateEventChannel eventChannel = new DummyUpdateEventChannel();
    private Map<NodeId, NodePropBundle> bundles;
    private List<ConsistencyCheckerError> errors;
    private int nodeCount;
    private long elapsedTime;

    public ConsistencyCheckerImpl(AbstractBundlePersistenceManager pm, ConsistencyCheckListener listener, String lostNFoundId, UpdateEventChannel eventChannel) {
        this.pm = pm;
        this.listener = listener;
        if (lostNFoundId != null) {
            this.lostNFoundId = new NodeId(lostNFoundId);
        }
        if (eventChannel != null) {
            this.eventChannel = eventChannel;
        }
    }

    public void check(String[] uuids, boolean recursive) throws RepositoryException {
        this.errors = new ArrayList<ConsistencyCheckerError>();
        long tstart = System.currentTimeMillis();
        this.nodeCount = this.internalCheckConsistency(uuids, recursive);
        this.elapsedTime = System.currentTimeMillis() - tstart;
    }

    public void doubleCheckErrors() {
        if (this.hasErrors()) {
            Iterator<ConsistencyCheckerError> errorIterator = this.errors.iterator();
            while (errorIterator.hasNext()) {
                ConsistencyCheckerError error = errorIterator.next();
                try {
                    if (error.doubleCheck()) continue;
                    this.info(null, "False positive: " + error);
                    errorIterator.remove();
                }
                catch (ItemStateException e) {
                    this.error(null, "Failed to double check error: " + error, e);
                }
            }
        }
    }

    public ConsistencyReport getReport() {
        HashSet<ReportItem> reportItems = new HashSet<ReportItem>();
        if (this.hasErrors()) {
            for (ConsistencyCheckerError error : this.errors) {
                reportItems.add(error.getReportItem());
            }
        }
        return new ConsistencyReportImpl(this.nodeCount, this.elapsedTime, reportItems);
    }

    public void repair() throws RepositoryException {
        this.checkLostNFound();
        this.bundles = new HashMap<NodeId, NodePropBundle>();
        if (this.hasRepairableErrors()) {
            boolean successful = false;
            CheckerUpdate update = new CheckerUpdate();
            try {
                this.eventChannel.updateCreated(update);
                for (ConsistencyCheckerError error : this.errors) {
                    if (!error.isRepairable()) continue;
                    try {
                        error.repair(update.getChanges());
                        this.info(null, "Repairing " + error);
                    }
                    catch (ItemStateException e) {
                        this.error(null, "Failed to repair error: " + error, e);
                    }
                }
                ChangeLog changes = update.getChanges();
                if (changes.hasUpdates()) {
                    this.eventChannel.updatePrepared(update);
                    for (NodePropBundle bundle : this.bundles.values()) {
                        this.storeBundle(bundle);
                    }
                    update.setAttribute(ATTRIBUTE_UPDATE_SIZE, changes.getUpdateSize());
                    successful = true;
                }
            }
            catch (ClusterException e) {
                throw new RepositoryException("Cannot create update", e);
            }
            finally {
                if (successful) {
                    this.eventChannel.updateCommitted(update, "checker@");
                } else {
                    this.eventChannel.updateCancelled(update);
                }
            }
        }
    }

    private boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    private boolean hasRepairableErrors() {
        if (this.hasErrors()) {
            for (ConsistencyCheckerError error : this.errors) {
                if (!error.isRepairable()) continue;
                return true;
            }
        }
        return false;
    }

    private void checkLostNFound() {
        if (this.lostNFoundId != null) {
            try {
                NodePropBundle lfBundle = this.pm.loadBundle(this.lostNFoundId);
                if (lfBundle == null) {
                    this.error(this.lostNFoundId.toString(), "Specified 'lost+found' node does not exist");
                    this.lostNFoundId = null;
                } else if (!NameConstants.NT_UNSTRUCTURED.equals(lfBundle.getNodeTypeName())) {
                    this.error(this.lostNFoundId.toString(), "Specified 'lost+found' node is not of type nt:unstructured");
                    this.lostNFoundId = null;
                }
            }
            catch (Exception ex) {
                this.error(this.lostNFoundId.toString(), "finding 'lost+found' folder", ex);
                this.lostNFoundId = null;
            }
        } else {
            this.info(null, "No 'lost+found' node specified: orphans cannot be fixed");
        }
    }

    private int internalCheckConsistency(String[] uuids, boolean recursive) throws RepositoryException {
        int count = 0;
        if (uuids == null) {
            try {
                Map<NodeId, NodeInfo> batch;
                Map<NodeId, NodeInfo> allInfos = batch = this.pm.getAllNodeInfos(null, NODESATONCE);
                NodeId lastId = null;
                while (!batch.isEmpty()) {
                    for (Map.Entry<NodeId, NodeInfo> entry : batch.entrySet()) {
                        lastId = entry.getKey();
                        if (++count % 1000 != 0) continue;
                        log.info(this.pm + ": loaded " + count + " infos...");
                    }
                    batch = this.pm.getAllNodeInfos(lastId, NODESATONCE);
                    allInfos.putAll(batch);
                }
                if (lastId == null) {
                    log.info("No nodes exists, skipping");
                }
                if (this.pm.exists(lastId)) {
                    for (Map.Entry<NodeId, NodeInfo> entry : allInfos.entrySet()) {
                        this.checkBundleConsistency(entry.getKey(), entry.getValue(), allInfos);
                    }
                }
                log.info("Failed to read all nodes, starting over");
                this.internalCheckConsistency(uuids, recursive);
            }
            catch (ItemStateException e) {
                throw new RepositoryException("Error loading nodes", e);
            }
            finally {
                NodeInfo.clearPool();
            }
        } else {
            ArrayList<NodeId> idList = new ArrayList<NodeId>(uuids.length);
            for (String uuid : uuids) {
                try {
                    idList.add(new NodeId(uuid));
                }
                catch (IllegalArgumentException e) {
                    this.error(uuid, "Invalid id for consistency check, skipping: '" + uuid + "': " + e);
                }
            }
            for (int i = 0; i < idList.size(); ++i) {
                NodeId id = (NodeId)idList.get(i);
                try {
                    NodePropBundle bundle = this.pm.loadBundle(id);
                    if (bundle == null) {
                        if (this.isVirtualNode(id)) continue;
                        this.error(id.toString(), "No bundle found for id '" + id + "'");
                        continue;
                    }
                    this.checkBundleConsistency(id, new NodeInfo(bundle), Collections.emptyMap());
                    if (recursive) {
                        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
                            idList.add(entry.getId());
                        }
                    }
                    if (++count % 1000 != 0 || this.listener != null) continue;
                    log.info(this.pm + ": checked " + count + "/" + idList.size() + " bundles...");
                    continue;
                }
                catch (ItemStateException itemStateException) {
                    // empty catch block
                }
            }
        }
        log.info(this.pm + ": checked " + count + " bundles.");
        return count;
    }

    private void checkBundleConsistency(NodeId nodeId, NodeInfo nodeInfo, Map<NodeId, NodeInfo> infos) {
        if (!this.isRoot(nodeId) && this.isVirtualNode(nodeId)) {
            return;
        }
        if (this.listener != null) {
            this.listener.startCheck(nodeId.toString());
        }
        for (NodeId childNodeId : nodeInfo.getChildren()) {
            if (this.isVirtualNode(childNodeId)) continue;
            NodeInfo childNodeInfo = infos.get(childNodeId);
            if (childNodeInfo == null) {
                this.addError(new MissingChild(nodeId, childNodeId));
                continue;
            }
            if (nodeId.equals(childNodeInfo.getParentId())) continue;
            this.addError(new DisconnectedChild(nodeId, childNodeId, childNodeInfo.getParentId()));
        }
        NodeId parentId = nodeInfo.getParentId();
        if (parentId != null && !this.isRoot(nodeId)) {
            NodeInfo parentInfo = infos.get(parentId);
            if (parentInfo == null) {
                this.addError(new OrphanedNode(nodeId, parentId));
            } else {
                boolean found = false;
                for (NodeId childNodeId : parentInfo.getChildren()) {
                    if (!childNodeId.equals(nodeId)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.addError(new AbandonedNode(nodeId, parentId));
                }
            }
        }
    }

    protected boolean isVirtualNode(NodeId nodeId) {
        return nodeId.toString().endsWith("babecafebabe");
    }

    private boolean isRoot(NodeId nodeId) {
        return "cafebabe-cafe-babe-cafe-babecafebabe".equals(nodeId.toString());
    }

    private void addError(ConsistencyCheckerError error) {
        if (this.listener != null) {
            this.listener.report(error.getReportItem());
        }
        this.errors.add(error);
    }

    private void info(String id, String message) {
        if (this.listener == null) {
            Object idstring = id == null ? "" : "Node " + id + ": ";
            log.info((String)idstring + message);
        } else {
            this.listener.info(id, message);
        }
    }

    private void error(String id, String message) {
        if (this.listener == null) {
            Object idstring = id == null ? "" : "Node " + id + ": ";
            log.error((String)idstring + message);
        } else {
            this.listener.error(id, message);
        }
    }

    private void error(String id, String message, Throwable ex) {
        Object idstring = id == null ? "" : "Node " + id + ": ";
        log.error((String)idstring + message, ex);
        if (this.listener != null) {
            this.listener.error(id, message);
        }
    }

    private void storeBundle(NodePropBundle bundle) {
        try {
            bundle.markOld();
            bundle.setModCount((short)(bundle.getModCount() + 1));
            this.pm.storeBundle(bundle);
            this.pm.evictBundle(bundle.getId());
        }
        catch (ItemStateException e) {
            log.error(this.pm + ": Error storing fixed bundle: " + e);
        }
    }

    private NodePropBundle getBundle(NodeId nodeId) throws ItemStateException {
        if (this.bundles.containsKey(nodeId)) {
            return this.bundles.get(nodeId);
        }
        return this.pm.loadBundle(nodeId);
    }

    private void saveBundle(NodePropBundle bundle) {
        this.bundles.put(bundle.getId(), bundle);
    }

    private class CheckerUpdate
    implements Update {
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final ChangeLog changeLog = new ChangeLog();
        private final long timestamp = System.currentTimeMillis();

        private CheckerUpdate() {
        }

        @Override
        public void setAttribute(String name, Object value) {
            this.attributes.put(name, value);
        }

        @Override
        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        @Override
        public ChangeLog getChanges() {
            return this.changeLog;
        }

        @Override
        public List<EventState> getEvents() {
            return Collections.emptyList();
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public String getUserData() {
            return null;
        }
    }

    private class AbandonedNode
    extends ConsistencyCheckerError {
        private final NodeId nodeId;
        private final NodeId parentNodeId;

        AbandonedNode(NodeId nodeId, NodeId parentNodeId) {
            super(nodeId, "NodeState '" + nodeId + "' is not referenced by its parent node '" + parentNodeId + "'");
            this.nodeId = nodeId;
            this.parentNodeId = parentNodeId;
        }

        @Override
        ReportItem.Type getType() {
            return ReportItem.Type.ABANDONED;
        }

        @Override
        boolean isRepairable() {
            return true;
        }

        @Override
        void doRepair(ChangeLog changes) throws ItemStateException {
            NodePropBundle parentBundle = ConsistencyCheckerImpl.this.getBundle(this.parentNodeId);
            parentBundle.addChildNodeEntry(this.createNodeName(), this.nodeId);
            ConsistencyCheckerImpl.this.saveBundle(parentBundle);
            changes.modified(new NodeState(this.parentNodeId, null, null, 1, false));
        }

        private Name createNodeName() {
            int n = (int)System.currentTimeMillis() + new Random().nextInt();
            String localName = Integer.toHexString(n);
            NameFactory nameFactory = NameFactoryImpl.getInstance();
            return nameFactory.create("{}" + localName);
        }

        @Override
        boolean doubleCheck() throws ItemStateException {
            NodePropBundle bundle;
            NodePropBundle parentBundle = ConsistencyCheckerImpl.this.pm.loadBundle(this.parentNodeId);
            if (parentBundle != null) {
                for (NodePropBundle.ChildNodeEntry entry : parentBundle.getChildNodeEntries()) {
                    if (!entry.getId().equals(this.nodeId)) continue;
                    return false;
                }
            }
            return (bundle = ConsistencyCheckerImpl.this.pm.loadBundle(this.nodeId)) != null && this.parentNodeId.equals(bundle.getParentId());
        }
    }

    private class OrphanedNode
    extends ConsistencyCheckerError {
        private final NodeId parentNodeId;

        OrphanedNode(NodeId nodeId, NodeId parentNodeId) {
            super(nodeId, "NodeState '" + nodeId + "' references inexistent parent id '" + parentNodeId + "'");
            this.parentNodeId = parentNodeId;
        }

        @Override
        ReportItem.Type getType() {
            return ReportItem.Type.ORPHANED;
        }

        @Override
        boolean isRepairable() {
            return ConsistencyCheckerImpl.this.lostNFoundId != null;
        }

        @Override
        void doRepair(ChangeLog changes) throws ItemStateException {
            if (ConsistencyCheckerImpl.this.lostNFoundId != null) {
                NodePropBundle bundle = ConsistencyCheckerImpl.this.getBundle(this.nodeId);
                NodePropBundle lfBundle = ConsistencyCheckerImpl.this.getBundle(ConsistencyCheckerImpl.this.lostNFoundId);
                String nodeName = this.nodeId + "-" + System.currentTimeMillis();
                NameFactory nameFactory = NameFactoryImpl.getInstance();
                lfBundle.addChildNodeEntry(nameFactory.create("", nodeName), this.nodeId);
                bundle.setParentId(ConsistencyCheckerImpl.this.lostNFoundId);
                ConsistencyCheckerImpl.this.saveBundle(bundle);
                ConsistencyCheckerImpl.this.saveBundle(lfBundle);
                changes.modified(new NodeState(ConsistencyCheckerImpl.this.lostNFoundId, null, null, 1, false));
                changes.modified(new NodeState(this.nodeId, null, null, 1, false));
            }
        }

        @Override
        boolean doubleCheck() throws ItemStateException {
            NodePropBundle bundle;
            NodePropBundle parentBundle = ConsistencyCheckerImpl.this.pm.loadBundle(this.parentNodeId);
            return parentBundle == null && (bundle = ConsistencyCheckerImpl.this.pm.loadBundle(this.nodeId)) != null && this.parentNodeId.equals(bundle.getParentId());
        }
    }

    private class DisconnectedChild
    extends ConsistencyCheckerError {
        private final NodeId childNodeId;

        DisconnectedChild(NodeId nodeId, NodeId childNodeId, NodeId invalidParentId) {
            super(nodeId, "Node has invalid parent id: '" + invalidParentId + "' (instead of '" + nodeId + "')");
            this.childNodeId = childNodeId;
        }

        @Override
        ReportItem.Type getType() {
            return ReportItem.Type.DISCONNECTED;
        }

        @Override
        boolean isRepairable() {
            return true;
        }

        @Override
        void doRepair(ChangeLog changes) throws ItemStateException {
            NodePropBundle bundle = ConsistencyCheckerImpl.this.getBundle(this.nodeId);
            Iterator<NodePropBundle.ChildNodeEntry> entryIterator = bundle.getChildNodeEntries().iterator();
            while (entryIterator.hasNext()) {
                NodePropBundle.ChildNodeEntry childNodeEntry = entryIterator.next();
                if (!childNodeEntry.getId().equals(this.childNodeId)) continue;
                entryIterator.remove();
                ConsistencyCheckerImpl.this.saveBundle(bundle);
                changes.modified(new NodeState(this.nodeId, null, null, 1, false));
                break;
            }
        }

        @Override
        boolean doubleCheck() throws ItemStateException {
            NodePropBundle bundle;
            NodePropBundle childBundle = ConsistencyCheckerImpl.this.pm.loadBundle(this.childNodeId);
            if (childBundle != null && !childBundle.getParentId().equals(this.nodeId) && (bundle = ConsistencyCheckerImpl.this.pm.loadBundle(this.nodeId)) != null) {
                for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
                    if (!entry.getId().equals(this.childNodeId)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class MissingChild
    extends ConsistencyCheckerError {
        private final NodeId childNodeId;

        private MissingChild(NodeId nodeId, NodeId childNodeId) {
            super(nodeId, "NodeState '" + nodeId + "' references inexistent child '" + childNodeId + "'");
            this.childNodeId = childNodeId;
        }

        @Override
        ReportItem.Type getType() {
            return ReportItem.Type.MISSING;
        }

        @Override
        boolean isRepairable() {
            return true;
        }

        @Override
        void doRepair(ChangeLog changes) throws ItemStateException {
            NodePropBundle bundle = ConsistencyCheckerImpl.this.getBundle(this.nodeId);
            Iterator<NodePropBundle.ChildNodeEntry> entryIterator = bundle.getChildNodeEntries().iterator();
            while (entryIterator.hasNext()) {
                NodePropBundle.ChildNodeEntry childNodeEntry = entryIterator.next();
                if (!childNodeEntry.getId().equals(this.childNodeId)) continue;
                entryIterator.remove();
                ConsistencyCheckerImpl.this.saveBundle(bundle);
                changes.modified(new NodeState(this.nodeId, null, null, 1, false));
            }
        }

        @Override
        boolean doubleCheck() throws ItemStateException {
            NodePropBundle bundle;
            NodePropBundle childBundle = ConsistencyCheckerImpl.this.pm.loadBundle(this.childNodeId);
            if (childBundle == null && (bundle = ConsistencyCheckerImpl.this.pm.loadBundle(this.nodeId)) != null) {
                for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
                    if (!entry.getId().equals(this.childNodeId)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

