/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.isis.viewer.restfulobjects.applib.domainobjects;

import java.io.IOException;
import org.junit.Before;
import org.junit.Test;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;

import static org.apache.isis.viewer.restfulobjects.applib.JsonFixture.readJson;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

public class DomainObjectRepresentationTest_getCollections {

    private DomainObjectRepresentation representation;

    @Before
    public void setUp() throws Exception {
        representation = new DomainObjectRepresentation(readJson("domainObjectRepresentation.json"));
    }

    @Test
    public void getProperties() throws IOException {
        final JsonRepresentation collections = representation.getCollections();

        final JsonRepresentation members = representation.getMembers();
        assertThat(members.size(), is(12));

        assertThat(collections.isMap(), is(true));
        assertThat(collections.size(), is(1));
    }

}
