/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.isis.viewer.restfulobjects.applib.client;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

import org.junit.Test;

public class RestfulResponse_HeaderTest_Warning {

    
    @Test
    public void nonEmptyString() throws Exception {
        assertThat(RestfulResponse.Header.WARNING.parse("199 RestfulObjects abc"), is("abc"));
    }

    @Test
    public void emptyString() throws Exception {
        assertThat(RestfulResponse.Header.WARNING.parse("199 RestfulObjects "), is(""));
    }

    @Test
    public void noPrefix() throws Exception {
        assertThat(RestfulResponse.Header.WARNING.parse("199 RestfulObject prefix is missing an 's'"), is("199 RestfulObject prefix is missing an 's'"));
    }
}
