<?xml version="1.0" encoding="UTF-8"?>
<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at
  
         http://www.apache.org/licenses/LICENSE-2.0
         
  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
    <modelVersion>4.0.0</modelVersion>

    <parent>
        <groupId>org.apache.isis.core</groupId>
        <artifactId>isis</artifactId>
    <version>2.0.0-M1</version>
    </parent>

    <artifactId>isis-core-security-shiro</artifactId>

    <name>Apache Isis Security Shiro</name>

    <properties>
        <jar-plugin.automaticModuleName>org.apache.isis.security.shiro</jar-plugin.automaticModuleName>
        <git-plugin.propertiesDir>org/apache/isis/security/shiro</git-plugin.propertiesDir>
    </properties>


    <build>
        <pluginManagement>
            <plugins>
                <!-- Apache Release Audit Tool -->
                <plugin>
                    <groupId>org.apache.rat</groupId>
                    <artifactId>apache-rat-plugin</artifactId>
                    <version>0.10</version>
	                <configuration>
	                    <excludes>
	                    	<!-- 
	                    	overriding inherited excludes from oia.core:isis 
	                    	with a more specific set for this component
	                    	 -->
	                        <exclude>**/target/**</exclude>
	                        <exclude>**/target-ide/**</exclude>

	                        <exclude>**/*.project</exclude>
	                        <exclude>**/.classpath</exclude>
	                        <exclude>**/.settings/**</exclude>
	                    </excludes>
                    </configuration>
                </plugin>
            </plugins>
        </pluginManagement>
    </build>

    <dependencyManagement>
    	<!-- for benefit of application developers, using scope=import -->
    	<dependencies>
            <dependency>
                <groupId>org.apache.isis.core</groupId>
                <artifactId>isis-core-security-shiro</artifactId>
                <version>2.0.0-M1</version>
            </dependency>
    	</dependencies>
    </dependencyManagement>

    <dependencies>
        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-runtime</artifactId>
        </dependency>
	
        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-runtime</artifactId>
            <type>test-jar</type>
            <scope>test</scope>
        </dependency>
        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-unittestsupport</artifactId>
            <scope>test</scope>
        </dependency>
	
        <dependency>
            <groupId>org.slf4j</groupId>
            <artifactId>jcl-over-slf4j</artifactId>
            <scope>test</scope>
        </dependency>

        <dependency>
            <groupId>org.apache.shiro</groupId>
            <artifactId>shiro-core</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.shiro</groupId>
            <artifactId>shiro-web</artifactId>
        </dependency>

<!-- replaced by javaee-api -->
<!--    <dependency> -->
<!--        <groupId>org.apache.geronimo.specs</groupId> -->
<!--        <artifactId>geronimo-servlet_3.0_spec</artifactId> -->
<!--        <scope>provided</scope> -->
<!--    </dependency> -->

    </dependencies>
</project>
