<?xml version="1.0" encoding="UTF-8"?>
<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at
  
         http://www.apache.org/licenses/LICENSE-2.0
         
  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
    <modelVersion>4.0.0</modelVersion>

    <parent>
        <groupId>org.apache.isis.core</groupId>
        <artifactId>isis</artifactId>
        <version>2.0.0-M1</version>
    </parent>

    <artifactId>isis-core-schema</artifactId>

    <packaging>jar</packaging>
    <name>Apache Isis Schemas</name>
    <description>
        Apache Isis schemas, for conversion into canonical DTOs (for use in integration scenarios).
    </description>

    <properties>
        <jar-plugin.automaticModuleName>org.apache.isis.schema</jar-plugin.automaticModuleName>
        <git-plugin.propertiesDir>org/apache/isis/schema</git-plugin.propertiesDir>
    </properties>

    <dependencies>
    	<dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-commons</artifactId>
        </dependency>
        <dependency>
            <groupId>joda-time</groupId>
            <artifactId>joda-time</artifactId>
        </dependency>
    </dependencies>

    <profiles>
        <profile>
            <id>xsd-to-java</id>
            <activation>
                <property>
                    <name>!skip.xsd-to-java</name>
                </property>
            </activation>

            <build>
                <pluginManagement>
                    <plugins>
                        <plugin>
                            <groupId>org.jvnet.jaxb2.maven2</groupId>
                            <artifactId>maven-jaxb2-plugin</artifactId>
                            <version>0.13.3</version>
                            <configuration>
                                <removeOldOutput>true</removeOldOutput>
                                <episode>true</episode>
                            </configuration>
                        </plugin>
                    </plugins>
                </pluginManagement>
                <plugins>
                    <plugin>
                        <groupId>org.jvnet.jaxb2.maven2</groupId>
                        <artifactId>maven-jaxb2-plugin</artifactId>
                        <executions>
                            <execution>
                                <id>generate-chg-xsd</id>
                                <phase>generate-sources</phase>
                                <goals>
                                    <goal>generate</goal>
                                </goals>
                                <configuration>
                                    <schemaDirectory>src/main/resources/org/apache/isis/schema</schemaDirectory>
                                    <schemaIncludes>
                                        <schemaInclude>common/common-1.1.xsd</schemaInclude>
                                        <schemaInclude>cmd/cmd-1.4.xsd</schemaInclude>
                                        <schemaInclude>ixn/ixn-1.3.xsd</schemaInclude>
                                        <schemaInclude>chg/chg-1.1.xsd</schemaInclude>
                                    </schemaIncludes>
                                    <bindingDirectory>src/main/resources/org/apache/isis/schema</bindingDirectory>
                                    <bindingIncludes>
                                        <bindingInclude>bindings.xml</bindingInclude>
                                    </bindingIncludes>
                                    <args>
                                        <arg>-extension</arg>
                                        <arg>-Xnamespace-prefix</arg>
                                    </args>
                                </configuration>
                            </execution>
                        </executions>
                        <dependencies>
                            <dependency>
                                <groupId>org.jvnet.jaxb2_commons</groupId>
                                <artifactId>jaxb2-namespace-prefix</artifactId>
                                <version>1.3</version>
                            </dependency>
                        </dependencies>
                    </plugin>
                    <plugin>
                        <groupId>org.codehaus.mojo</groupId>
                        <artifactId>build-helper-maven-plugin</artifactId>
                        <version>3.0.0</version>
                        <executions>
                            <execution>
                                <id>add-source</id>
                                <phase>generate-sources</phase>
                                <goals>
                                    <goal>add-source</goal>
                                </goals>
                                <configuration>
                                    <sources>
                                        <source>target/generated-sources/xjc</source>
                                    </sources>
                                </configuration>
                            </execution>
                        </executions>
                    </plugin>
                </plugins>
            </build>
        </profile>
    </profiles>

</project>
