<?xml version="1.0" encoding="UTF-8"?>
<!-- Licensed to the Apache Software Foundation (ASF) under one or more contributor 
	license agreements. See the NOTICE file distributed with this work for additional 
	information regarding copyright ownership. The ASF licenses this file to 
	you under the Apache License, Version 2.0 (the "License"); you may not use 
	this file except in compliance with the License. You may obtain a copy of 
	the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required 
	by applicable law or agreed to in writing, software distributed under the 
	License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS 
	OF ANY KIND, either express or implied. See the License for the specific 
	language governing permissions and limitations under the License. -->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
    <modelVersion>4.0.0</modelVersion>

    <parent>
        <groupId>org.apache.isis.core</groupId>
        <artifactId>isis</artifactId>
        <version>2.0.0-M1</version>
    </parent>

    <artifactId>isis-core-runtime</artifactId>
    <name>Apache Isis Runtime</name>

    <properties>
        <jar-plugin.automaticModuleName>org.apache.isis.core.runtime</jar-plugin.automaticModuleName>
        <git-plugin.propertiesDir>org/apache/isis/core/runtime</git-plugin.propertiesDir>
    </properties>

    <build>
        <resources>
            <resource>
                <directory>src/main/java</directory>
                <filtering>false</filtering>
                <includes>
                    <include>**</include>
                </includes>
                <excludes>
                    <exclude>**/*.java</exclude>
                </excludes>
            </resource>
            <resource>
                <directory>src/main/resources</directory>
                <includes>
                    <include>isis-version.properties</include>
                </includes>
                <filtering>true</filtering>
            </resource>
            <resource>
                <directory>src/main/resources</directory>
                <filtering>false</filtering>
            </resource>
        </resources>
    </build>

    <dependencies>
	
	<!-- JDO API (non transient, provided by plugin) -->
        <dependency>
            <groupId>javax.jdo</groupId>
            <artifactId>jdo-api</artifactId>
            <version>${jdo-api.version}</version>
            <!-- provided by plugins -->
            <scope>provided</scope>
        </dependency>
	
        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-applib</artifactId>
            <type>test-jar</type>
            <scope>test</scope>
        </dependency>

        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-unittestsupport</artifactId>
            <scope>test</scope>
        </dependency>

        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-log4j</artifactId>
        </dependency>
        
        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-metamodel</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-metamodel</artifactId>
            <type>test-jar</type>
            <scope>test</scope>
        </dependency>

        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-schema</artifactId>
        </dependency>

<!--    <dependency> -->
<!-- 	    <groupId>dom4j</groupId> -->
<!--        <artifactId>dom4j</artifactId> -->
<!--     </dependency> -->

        <dependency>
            <groupId>org.slf4j</groupId>
            <artifactId>slf4j-log4j12</artifactId>
        </dependency>

        <dependency>
            <!-- because DataNucleus uses log4j as its preferred logger -->
            <groupId>log4j</groupId>
            <artifactId>log4j</artifactId>
        </dependency>

        <dependency>
            <!-- required because resteasy-jaxrs declares as a test dependency whereas 
                 httpclient4 needs it as a compile dependency -->
            <groupId>commons-logging</groupId>
            <artifactId>commons-logging</artifactId>
        </dependency>

    </dependencies>

    <profiles>
        <profile>
            <id>email-notification-service</id>
            <activation>
                <property>
                    <name>!skip.email-notification-service</name>
                </property>
            </activation>
            <dependencies>
                <dependency>
                    <groupId>org.apache.commons</groupId>
                    <artifactId>commons-email</artifactId>
                    <version>${commons-email.version}</version>
                    <exclusions>
                        <!--
                        excluded because provided by javax:javaee-api
                        note: moved javax.mail from 1.5.2 to 1.5.0
                        note: moved activation from 1.1.1 to 1.1    ... don't know if this is significant.
                        -->
                        <exclusion>
                            <groupId>com.sun.mail</groupId>
                            <artifactId>javax.mail</artifactId>
                        </exclusion>
                        <exclusion>
                            <groupId>javax.activation</groupId>
                            <artifactId>activation</artifactId>
                        </exclusion>
                    </exclusions>
                </dependency>
            </dependencies>
        </profile>

	</profiles>
</project>
