<?xml version="1.0" encoding="UTF-8"?>
<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at
  
         http://www.apache.org/licenses/LICENSE-2.0
         
  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
    <modelVersion>4.0.0</modelVersion>

    <parent>
        <groupId>org.apache.isis.core</groupId>
        <artifactId>isis</artifactId>
        <version>2.0.0-M1</version>
    </parent>

    <artifactId>isis-core-metamodel</artifactId>
    <name>Apache Isis MetaModel</name>

    <properties>
        <jar-plugin.automaticModuleName>org.apache.isis.core.metamodel</jar-plugin.automaticModuleName>
        <git-plugin.propertiesDir>org/apache/isis/core/metamodel</git-plugin.propertiesDir>
    </properties>

    <build>
        <testResources>
            <testResource>
                <filtering>false</filtering>
                <directory>src/test/resources</directory>
            </testResource>
            <testResource>
                <filtering>false</filtering>
                <directory>src/test/java</directory>
                <includes>
                    <include>**</include>
                </includes>
                <excludes>
                    <exclude>**/*.java</exclude>
                </excludes>
            </testResource>
        </testResources>
    </build>

    <dependencies>
    
        <!-- JDO API (non transient, provided by plugin) -->
        <dependency>
            <groupId>javax.jdo</groupId>
            <artifactId>jdo-api</artifactId>
            <version>${jdo-api.version}</version>
            <!-- provided by plugins -->
            <scope>provided</scope>
        </dependency>
    
        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-unittestsupport</artifactId>
            <scope>test</scope>
        </dependency>

        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-applib</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-applib</artifactId>
            <type>test-jar</type>
            <scope>test</scope>
        </dependency>

        <dependency>
            <groupId>commons-codec</groupId>
            <artifactId>commons-codec</artifactId>
        </dependency>

        <dependency>
            <groupId>commons-cli</groupId>
            <artifactId>commons-cli</artifactId>
        </dependency>

        <dependency>
            <groupId>com.google.inject</groupId>
            <artifactId>guice</artifactId>
        </dependency>

        <dependency>
	       <groupId>com.google.code.gson</groupId>
	       <artifactId>gson</artifactId>
        </dependency>

        <dependency>
            <groupId>io.swagger</groupId>
            <artifactId>swagger-core</artifactId>
        </dependency>
    </dependencies>

</project>
