<?xml version="1.0" encoding="UTF-8"?>
<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

         http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
    <modelVersion>4.0.0</modelVersion>

    <parent>
        <groupId>org.apache.isis.core</groupId>
        <artifactId>isis</artifactId>
        <version>2.0.0-M1</version>
    </parent>

    <groupId>org.apache.isis.tool</groupId>
    <artifactId>isis-maven-plugin</artifactId>

    <packaging>maven-plugin</packaging>

    <name>Apache Isis Maven Plugin (isis-maven-plugin)</name>
    <description>
        Maven plugin for Apache Isis, allowing the metamodel to be validated as part of the build process.
    </description>

    <prerequisites>
        <maven>3.5.3</maven>
    </prerequisites>

    <properties>
        <jar-plugin.automaticModuleName>org.apache.isis.tool.mavenplugin</jar-plugin.automaticModuleName>
        <git-plugin.propertiesDir>org/apache/isis/tool/mavenplugin</git-plugin.propertiesDir>

        <maven-core.version>3.5.3</maven-core.version>
        <maven-project.version>3.0-alpha-2</maven-project.version>
        <maven-plugin-annotations.version>3.5.1</maven-plugin-annotations.version>
        <plexus-container-default.version>1.7.1</plexus-container-default.version>
        <plexus-utils.version>3.1.0</plexus-utils.version>
        
    </properties>

    <build>

        <pluginManagement>
            <plugins>
                <!-- Apache Release Audit Tool -->
                <plugin>
                    <groupId>org.apache.rat</groupId>
                    <artifactId>apache-rat-plugin</artifactId>
                    <version>0.10</version>
                    <configuration>
                        <excludes>
                            <!--
                            overriding inherited excludes from oia.core:isis
                            with a more specific set for this component
                             -->
                            <exclude>**/target/**</exclude>
                            <exclude>**/target-ide/**</exclude>

                            <exclude>**/*.project</exclude>
                            <exclude>**/.classpath</exclude>
                            <exclude>**/.settings/**</exclude>
                        </excludes>
                    </configuration>
                </plugin>
            </plugins>
        </pluginManagement>
        <plugins>
            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-plugin-plugin</artifactId>
                <!-- override to allow build on jdk9+ -->
                <version>3.5.2</version>
                <configuration>
                    <goalPrefix>configurator</goalPrefix>
                </configuration>
                <executions>
                    <execution>
                        <id>default-descriptor</id>
                        <goals>
                            <goal>descriptor</goal>
                        </goals>
                        <phase>process-classes</phase>
                    </execution>
                    <execution>
                        <id>help-descriptor</id>
                        <goals>
                            <goal>helpmojo</goal>
                        </goals>
                        <phase>process-classes</phase>
                    </execution>
                </executions>
            </plugin>
        </plugins>
    </build>

    <dependencies>

        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-runtime</artifactId>
        </dependency>

        <!-- 
        the plethora of exclusions in the following dependencies
        are to ensure dependency convergence.
        
        In some cases, what would have been a transitive dependency
        is added as a direct dependency in order that its divergent dependency
        can be excluded.
        
        It's all a bit of a pig's ear...
        -->
        
        <dependency>
        	<groupId>org.codehaus.plexus</groupId>
            <artifactId>plexus-utils</artifactId>
            <version>${plexus-utils.version}</version>
        </dependency>

        <dependency>
            <groupId>org.apache.maven</groupId>
            <artifactId>maven-plugin-api</artifactId>
            <version>${maven-core.version}</version>
            <exclusions>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-component-annotations</artifactId>
                </exclusion>
                <exclusion>
                	<groupId>org.codehaus.plexus</groupId>
                	<artifactId>plexus-utils</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

        <dependency>
            <groupId>org.apache.maven.plugin-tools</groupId>
            <artifactId>maven-plugin-annotations</artifactId>
            <version>${maven-plugin-annotations.version}</version>
            <exclusions>
                <exclusion>
                    <groupId>org.apache.maven</groupId>
                    <artifactId>maven-artifact</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

        <dependency>
            <groupId>org.apache.maven</groupId>
            <artifactId>maven-core</artifactId>
            <version>${maven-core.version}</version>
            <exclusions>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-utils</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-sec-dispatcher</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>com.google.inject</groupId>
                    <artifactId>guice</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

        <dependency>
            <groupId>org.apache.maven</groupId>
            <artifactId>maven-model</artifactId>
            <version>${maven-core.version}</version>
            <exclusions>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-utils</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

        <dependency>
            <groupId>org.apache.maven</groupId>
            <artifactId>maven-model-builder</artifactId>
            <version>${maven-core.version}</version>
            <exclusions>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-utils</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

        <dependency>
            <groupId>org.apache.maven</groupId>
            <artifactId>maven-settings</artifactId>
            <version>${maven-core.version}</version>
            <exclusions>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-utils</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

        <dependency>
            <groupId>org.apache.maven</groupId>
            <artifactId>maven-artifact</artifactId>
            <version>${maven-core.version}</version>
            <exclusions>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-utils</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

        <dependency>
            <groupId>org.apache.maven</groupId>
            <artifactId>maven-project</artifactId>
            <version>${maven-project.version}</version>
            <exclusions>
                <!-- for dependency convergence -->
                <exclusion>
                    <groupId>org.apache.maven</groupId>
                    <artifactId>maven-core</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.apache.maven</groupId>
                    <artifactId>maven-model</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.apache.maven</groupId>
                    <artifactId>maven-compat</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-container-default</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-utils</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-interpolation</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

        <dependency>
            <groupId>org.apache.maven</groupId>
            <artifactId>maven-compat</artifactId>
            <version>${maven-core.version}</version>
            <exclusions>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-utils</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

        <dependency>
            <groupId>org.codehaus.plexus</groupId>
            <artifactId>plexus-container-default</artifactId>
            <version>${plexus-container-default.version}</version>
            <exclusions>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-classworlds</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.codehaus.plexus</groupId>
                    <artifactId>plexus-utils</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>com.google.collections</groupId>
                    <artifactId>google-collections</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

        <dependency>
            <groupId>org.apache.maven</groupId>
            <artifactId>maven-toolchain</artifactId>
            <version>${maven-project.version}</version>
            <exclusions>
                <exclusion>
                    <groupId>org.apache.maven</groupId>
                    <artifactId>maven-core</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.apache.maven</groupId>
                    <artifactId>maven-compat</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

    </dependencies>

</project>
