/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

/**
 * The application library defines the annotations, interfaces and
 * supporting utilities that are part of the overall Apache Isis 
 * Programming Model. 
 * 
 * <p>
 * This package contains adapter classes which can optionally be used for
 * {@link org.apache.isis.applib.AbstractDomainObject entities}, for
 * {@link org.apache.isis.applib.AbstractService domain services} and for
 * {@link org.apache.isis.applib.AbstractFactoryAndRepository repositories}.
 * 
 * <p>
 * In addition, it contains a {@link org.apache.isis.applib.Identifier class}
 * that represents the identifier of an object or object member, used for
 * example in the <tt>events</tt> package as well as internally within the
 * framework.
 */
package org.apache.isis.applib;