<?xml version="1.0" encoding="UTF-8"?>
<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at
  
         http://www.apache.org/licenses/LICENSE-2.0
         
  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
    <modelVersion>4.0.0</modelVersion>

    <parent>
        <groupId>org.apache.isis.core</groupId>
        <artifactId>isis</artifactId>
        <version>2.0.0-M1</version>
    </parent>

    <artifactId>isis-core-applib</artifactId>

    <name>Apache Isis AppLib</name>
    <description>
        Isis application library, defining annotations and utilities for the
        default (Java) programming model.
    </description>

    <properties>
        <jar-plugin.automaticModuleName>org.apache.isis.applib</jar-plugin.automaticModuleName>
        <git-plugin.propertiesDir>org/apache/isis/applib</git-plugin.propertiesDir>
    </properties>

    <build>
        <resources>
            <resource>
                <filtering>false</filtering>
                <directory>src/main/resources</directory>
            </resource>
            <resource>
                <filtering>false</filtering>
                <directory>src/main/java</directory>
                <includes>
                    <include>**</include>
                </includes>
                <excludes>
                    <exclude>**/*.java</exclude>
                </excludes>
            </resource>
        </resources>
<!--  [ahuber] possibly no longer required -->
<!--         <pluginManagement> -->
<!--             <plugins> -->
<!--                 This plugin's configuration is used to store Eclipse m2e settings only. It has no influence on the Maven build itself. -->
<!--                 <plugin> -->
<!--                     <groupId>org.eclipse.m2e</groupId> -->
<!--                     <artifactId>lifecycle-mapping</artifactId> -->
<!--                     <version>1.0.0</version> -->
<!--                     <configuration> -->
<!--                         <lifecycleMappingMetadata> -->
<!--                             <pluginExecutions> -->
<!--                                 <pluginExecution> -->
<!--                                     <pluginExecutionFilter> -->
<!--                                         <groupId> -->
<!--                                             org.datanucleus -->
<!--                                         </groupId> -->
<!--                                         <artifactId> -->
<!--                                             datanucleus-maven-plugin -->
<!--                                         </artifactId> -->
<!--                                         <versionRange> -->
<!--                                             [4.0.0-release,) -->
<!--                                         </versionRange> -->
<!--                                         <goals> -->
<!--                                             <goal>enhance</goal> -->
<!--                                         </goals> -->
<!--                                     </pluginExecutionFilter> -->
<!--                                     <action> -->
<!--                                         <ignore /> -->
<!--                                     </action> -->
<!--                                 </pluginExecution> -->
<!--                             </pluginExecutions> -->
<!--                         </lifecycleMappingMetadata> -->
<!--                     </configuration> -->
<!--                 </plugin> -->
<!--             </plugins> -->
<!--         </pluginManagement> -->
    </build>

    <dependencies>
    
    	<dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-commons</artifactId>
        </dependency>
    
        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-schema</artifactId>
        </dependency>
		
		<!-- JDO API (non transient, provided by plugin) -->
        <dependency>
            <groupId>javax.jdo</groupId>
            <artifactId>jdo-api</artifactId>
            <version>${jdo-api.version}</version>
            <!-- provided by plugins -->
            <scope>provided</scope>
        </dependency>

        <!-- HSQL-DB -->
        <dependency>
            <groupId>org.hsqldb</groupId>
            <artifactId>hsqldb</artifactId>
            <optional>true</optional>
        </dependency>

        <!-- TESTS -->
        <dependency>
            <groupId>org.apache.isis.core</groupId>
            <artifactId>isis-core-unittestsupport</artifactId>
            <scope>test</scope>
            <exclusions>
            	<!-- whatever unittestsupport is dependent on, it should not be transitive  -->
            	<exclusion>
                    <groupId>org.reflections</groupId>
                    <artifactId>reflections</artifactId>
            	</exclusion>
            	<exclusion>
                    <groupId>com.google.guava</groupId>
                    <artifactId>guava</artifactId>
            	</exclusion>
            </exclusions>
        </dependency>
        
    </dependencies>

</project>
