/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.isis.viewer.wicket.model.models;

import java.io.Serializable;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;

/**
 * Decouples the {@link ActionModelImpl} from its (modal window) prompt.
 */
public interface ActionPrompt extends Serializable {

    /**
     * Sets the component that should be used as a title for the modal window
     *
     * @param component The title component
     * @param target The current Ajax request handler
     */
    void setTitle(Component component, AjaxRequestTarget target);

    /**
     * Sets the component that should be used as a body for the modal window
     *
     * @param component The body component
     * @param target The current Ajax request handler
     */
    void setPanel(Component component, AjaxRequestTarget target);

    /**
     * Shows the modal window
     *
     * @param target The current Ajax request handler
     */
    void showPrompt(AjaxRequestTarget target);

    /**
     * @return the component id for the title component
     */
    String getTitleId();

    /**
     * @return the component id for the body component
     */
    String getContentId();

    /**
     * Closes the modal window
     *
     * @param target The current Ajax request handler
     */
    void closePrompt(AjaxRequestTarget target);

}
