/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.isis.core.transaction.changetracking;

import org.apache.isis.applib.services.publishing.spi.EntityChanges;
import org.apache.isis.applib.services.publishing.spi.EntityChangesSubscriber;

/**
 * Notifies {@link EntityChangesSubscriber}s.
 *
 * @since 1.x but renamed/refactored for v2 {@index}
 */
public interface EntityChangesPublisher {

    /**
     * Notifies {@link EntityChangesSubscriber}s of the changed entities within
     * an {@link org.apache.isis.applib.services.iactn.Interaction}, calling
     * the {@link EntityChangesSubscriber#onChanging(EntityChanges)} callback.
     */
    void publishChangingEntities(final HasEnlistedEntityChanges hasEnlistedEntityChanges);

}
