/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.isession.ITableSession;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.TableSessionBuilder;
import org.apache.iotdb.tool.data.AbstractDataTool;
import org.apache.iotdb.tool.data.AbstractExportData;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.file.metadata.ColumnSchema;
import org.apache.tsfile.file.metadata.ColumnSchemaBuilder;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.v4.ITsFileWriter;
import org.apache.tsfile.write.v4.TsFileWriterBuilder;

public class ExportDataTable
extends AbstractExportData {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static ITableSession tableSession;
    private static List<String> tables;

    @Override
    public void init() throws IoTDBConnectionException, StatementExecutionException {
        tableSession = new TableSessionBuilder().nodeUrls(Collections.singletonList(host + ":" + port)).username(username).password(password).database(database).build();
        SessionDataSet sessionDataSet = tableSession.executeQueryStatement("show databases", timeout);
        ArrayList<String> databases = new ArrayList<String>();
        while (sessionDataSet.hasNext()) {
            databases.add(sessionDataSet.next().getField(0).getStringValue());
        }
        if (CollectionUtils.isEmpty(databases) || !databases.contains(database)) {
            ioTPrinter.println(String.format("The target database %s does not exist", database));
            System.exit(1);
        }
        sessionDataSet = tableSession.executeQueryStatement("show tables", timeout);
        while (sessionDataSet.hasNext()) {
            tables.add(sessionDataSet.next().getField(0).getStringValue());
        }
        if (CollectionUtils.isEmpty(tables) || ObjectUtils.isNotEmpty((Object)table) && !tables.contains(table)) {
            ioTPrinter.println(String.format("There are no tables or the target table %s does not exist", table));
            System.exit(1);
        }
        if (ObjectUtils.isNotEmpty((Object)table)) {
            tables.clear();
            tables.add(table);
        }
        if (ObjectUtils.isNotEmpty((Object)sessionDataSet)) {
            sessionDataSet.close();
        }
    }

    @Override
    public void exportBySql(String sql, int index) {
        ArrayList<String> exportSql = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            if ("sql".equalsIgnoreCase(exportType) || "tsfile".equalsIgnoreCase(exportType)) {
                ExportDataTable.legalCheck(sql);
            }
            exportSql.add(sql);
        } else {
            for (String table : tables) {
                StringBuilder sqlBuilder = new StringBuilder("select * from ").append(table);
                if (StringUtils.isNotBlank((CharSequence)startTime) || StringUtils.isNotBlank((CharSequence)endTime)) {
                    sqlBuilder.append(" where ");
                    if (StringUtils.isNotBlank((CharSequence)startTime)) {
                        sqlBuilder.append("time >= ").append(startTime);
                    }
                    if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
                        sqlBuilder.append(" and ");
                    }
                    if (StringUtils.isNotBlank((CharSequence)endTime)) {
                        sqlBuilder.append("time <= ").append(endTime);
                    }
                }
                exportSql.add(sqlBuilder.toString());
            }
        }
        for (int i = 0; i < exportSql.size(); ++i) {
            String table;
            String path = targetDirectory + targetFile + i;
            table = tables.get(i);
            try (SessionDataSet sessionDataSet = tableSession.executeQueryStatement((String)exportSql.get(i), timeout);){
                if ("sql".equalsIgnoreCase(exportType)) {
                    this.exportToSqlFile(sessionDataSet, table, path);
                } else if ("tsfile".equalsIgnoreCase(exportType)) {
                    long start = System.currentTimeMillis();
                    boolean isComplete = this.exportToTsFile(sessionDataSet, path + ".tsfile", table);
                    if (isComplete) {
                        long end = System.currentTimeMillis();
                        ioTPrinter.println("Export completely!cost: " + (end - start) + " ms.");
                    }
                } else {
                    this.exportToCsvFile(sessionDataSet, path);
                }
                sessionDataSet.closeOperationHandle();
                ioTPrinter.println("Export completely!");
                continue;
            }
            catch (IOException | IoTDBConnectionException | StatementExecutionException | WriteProcessException e) {
                ioTPrinter.println("Cannot dump result because: " + e.getMessage());
            }
        }
    }

    private void exportToSqlFile(SessionDataSet sessionDataSet, String table, String filePath) throws IOException, IoTDBConnectionException, StatementExecutionException {
        List headers = sessionDataSet.getColumnNames();
        String prevSql = "insert into " + table + "(" + StringUtils.join((Iterable)headers, (String)",") + ") values(";
        List columnTypes = sessionDataSet.getColumnTypes();
        boolean hasNext = sessionDataSet.hasNext();
        int fileIndex = 0;
        while (hasNext) {
            String finalFilePath = filePath + "_" + fileIndex + ".sql";
            int countLine = 0;
            try (FileWriter writer = new FileWriter(finalFilePath);){
                while (countLine++ < linesPerFile && hasNext) {
                    RowRecord rowRecord = sessionDataSet.next();
                    StringBuilder sqlBuilder = new StringBuilder();
                    List fields = rowRecord.getFields();
                    sqlBuilder.append(prevSql);
                    for (int i = 0; i < fields.size(); ++i) {
                        TSDataType type;
                        if (i > 0) {
                            sqlBuilder.append(",");
                        }
                        if (TSDataType.TEXT.equals((Object)(type = ExportDataTable.getType((String)columnTypes.get(i)))) || TSDataType.STRING.equals((Object)type)) {
                            sqlBuilder.append("'").append(((Field)fields.get(i)).getObjectValue(type)).append("'");
                            continue;
                        }
                        sqlBuilder.append(((Field)fields.get(i)).getObjectValue(type));
                    }
                    sqlBuilder.append(");\n");
                    writer.write(sqlBuilder.toString());
                    hasNext = sessionDataSet.hasNext();
                }
                writer.flush();
                ++fileIndex;
            }
        }
    }

    private Boolean exportToTsFile(SessionDataSet sessionDataSet, String filePath, String table) throws IOException, IoTDBConnectionException, StatementExecutionException, WriteProcessException {
        List columnNamesRaw = sessionDataSet.getColumnNames();
        List columnTypesRaw = sessionDataSet.getColumnTypes().stream().map(t -> ExportDataTable.getType(t)).collect(Collectors.toList());
        File f = FSFactoryProducer.getFSFactory().getFile(filePath);
        if (f.exists()) {
            Files.delete(f.toPath());
        }
        boolean isEmpty = false;
        HashMap<String, Integer> deviceColumnIndices = new HashMap<String, Integer>();
        List<ColumnSchema> columnSchemas = this.collectSchemas(columnNamesRaw, deviceColumnIndices, table);
        try (ITsFileWriter tsFileWriter = new TsFileWriterBuilder().file(f).tableSchema(new TableSchema(table, columnSchemas)).memoryThreshold(0xA00000L).build();){
            Tablet tablet;
            ArrayList columnNames = new ArrayList(columnNamesRaw);
            ArrayList columnTypes = new ArrayList(columnTypesRaw);
            int timeIndex = columnNamesRaw.indexOf(timeColumn.toLowerCase());
            if (timeIndex >= 0) {
                columnNames.remove(timeIndex);
                columnTypes.remove(timeIndex);
            }
            if (ObjectUtils.isNotEmpty((Object)(tablet = new Tablet(columnNames, columnTypes)))) {
                ExportDataTable.writeWithTablets(sessionDataSet, tablet, deviceColumnIndices, tsFileWriter);
            } else {
                isEmpty = true;
            }
        }
        if (isEmpty) {
            ioTPrinter.println("!!!Warning:Tablet is empty,no data can be exported.");
            return false;
        }
        return true;
    }

    private void exportToCsvFile(SessionDataSet sessionDataSet, String filePath) throws IOException, IoTDBConnectionException, StatementExecutionException {
        List headers = sessionDataSet.getColumnNames();
        int fileIndex = 0;
        boolean hasNext = sessionDataSet.hasNext();
        while (hasNext) {
            String finalFilePath = filePath + "_" + fileIndex + ".csv";
            AbstractDataTool.CSVPrinterWrapper csvPrinterWrapper = new AbstractDataTool.CSVPrinterWrapper(finalFilePath);
            csvPrinterWrapper.printRecord(headers);
            int i = 0;
            while (i++ < linesPerFile) {
                RowRecord rowRecord = sessionDataSet.next();
                rowRecord.getFields().forEach(field -> {
                    String fieldStringValue = field.getStringValue();
                    if (!"null".equals(field.getStringValue())) {
                        if (field.getDataType() == TSDataType.TEXT || field.getDataType() == TSDataType.STRING) {
                            fieldStringValue = "\"" + fieldStringValue + "\"";
                        } else if (field.getDataType() == TSDataType.TIMESTAMP) {
                            fieldStringValue = ExportDataTable.timeTrans(field.getLongV());
                        }
                        csvPrinterWrapper.print(fieldStringValue);
                    } else {
                        csvPrinterWrapper.print("");
                    }
                });
                csvPrinterWrapper.println();
                hasNext = sessionDataSet.hasNext();
                if (hasNext) continue;
                break;
            }
            ++fileIndex;
            csvPrinterWrapper.flush();
            csvPrinterWrapper.close();
        }
    }

    private static void writeWithTablets(SessionDataSet sessionDataSet, Tablet tablet, Map<String, Integer> deviceColumnIndices, ITsFileWriter tsFileWriter) throws IoTDBConnectionException, StatementExecutionException, IOException, WriteProcessException {
        while (sessionDataSet.hasNext()) {
            RowRecord rowRecord = sessionDataSet.next();
            List fields = rowRecord.getFields();
            int rowIndex = tablet.getRowSize();
            tablet.addTimestamp(rowIndex, ((Field)fields.get(deviceColumnIndices.get(timeColumn.toLowerCase()))).getLongV());
            List schemas = tablet.getSchemas();
            for (int i = 0; i < schemas.size(); ++i) {
                IMeasurementSchema measurementSchema = (IMeasurementSchema)schemas.get(i);
                String measurementName = measurementSchema.getMeasurementName();
                if (timeColumn.equalsIgnoreCase(measurementName)) continue;
                Object value = ((Field)fields.get(deviceColumnIndices.get(measurementName))).getObjectValue(measurementSchema.getType());
                tablet.addValue(measurementName, rowIndex, value);
            }
            if (tablet.getRowSize() != tablet.getMaxRowNumber()) continue;
            ExportDataTable.writeToTsFile(tsFileWriter, tablet);
            tablet.initBitMaps();
            tablet.reset();
        }
        if (tablet.getRowSize() != 0) {
            ExportDataTable.writeToTsFile(tsFileWriter, tablet);
        }
    }

    private static void writeToTsFile(ITsFileWriter tsFileWriter, Tablet tablet) throws IOException, WriteProcessException {
        tsFileWriter.write(tablet);
    }

    private List<ColumnSchema> collectSchemas(List<String> columnNames, Map<String, Integer> deviceColumnIndices, String table) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<ColumnSchema> columnSchemas = new ArrayList<ColumnSchema>();
        SessionDataSet sessionDataSet = tableSession.executeQueryStatement("describe " + table);
        while (sessionDataSet.hasNext()) {
            RowRecord rowRecord = sessionDataSet.next();
            String columnName = rowRecord.getField(0).getStringValue();
            if (timeColumn.equalsIgnoreCase(columnName)) continue;
            columnSchemas.add(new ColumnSchemaBuilder().name(columnName).dataType(ExportDataTable.getType(rowRecord.getField(1).getStringValue())).category(ExportDataTable.getColumnCategory(rowRecord.getField(2).getStringValue())).build());
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            deviceColumnIndices.put(columnNames.get(i), i);
        }
        if (ObjectUtils.isNotEmpty((Object)sessionDataSet)) {
            sessionDataSet.close();
        }
        return columnSchemas;
    }

    static {
        tables = new ArrayList<String>();
    }
}

