/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;

final class Util {
    private Util() {
    }

    public static Optional<Set<Symbol>> pruneInputs(Collection<Symbol> availableInputs, Collection<Expression> expressions) {
        ImmutableSet availableInputsSet = ImmutableSet.copyOf(availableInputs);
        Set prunedInputs = Sets.filter((Set)availableInputsSet, SymbolsExtractor.extractUnique(expressions)::contains);
        if (prunedInputs.size() == availableInputsSet.size()) {
            return Optional.empty();
        }
        return Optional.of(prunedInputs);
    }

    public static PlanNode transpose(PlanNode parent, PlanNode child) {
        return child.replaceChildren((List<PlanNode>)ImmutableList.of((Object)parent.replaceChildren(child.getChildren())));
    }

    public static Optional<PlanNode> restrictOutputs(QueryId idAllocator, PlanNode node, Set<Symbol> permittedOutputs) {
        List restrictedOutputs = (List)node.getOutputSymbols().stream().filter(permittedOutputs::contains).collect(ImmutableList.toImmutableList());
        if (restrictedOutputs.size() == node.getOutputSymbols().size()) {
            return Optional.empty();
        }
        return Optional.of(new ProjectNode(idAllocator.genPlanNodeId(), node, Assignments.identity(restrictedOutputs)));
    }

    @SafeVarargs
    public static Optional<PlanNode> restrictChildOutputs(QueryId idAllocator, PlanNode node, Set<Symbol> ... permittedChildOutputsArgs) {
        ImmutableList permittedChildOutputs = ImmutableList.copyOf((Object[])permittedChildOutputsArgs);
        Preconditions.checkArgument((node.getChildren().size() == permittedChildOutputs.size() ? 1 : 0) != 0, (String)"Mismatched child (%s) and permitted outputs (%s) sizes", (int)node.getChildren().size(), (int)permittedChildOutputs.size());
        ImmutableList.Builder newChildrenBuilder = ImmutableList.builder();
        boolean rewroteChildren = false;
        for (int i = 0; i < node.getChildren().size(); ++i) {
            PlanNode oldChild = node.getChildren().get(i);
            Optional<PlanNode> newChild = Util.restrictOutputs(idAllocator, oldChild, (Set)permittedChildOutputs.get(i));
            rewroteChildren |= newChild.isPresent();
            newChildrenBuilder.add((Object)newChild.orElse(oldChild));
        }
        if (!rewroteChildren) {
            return Optional.empty();
        }
        return Optional.of(node.replaceChildren((List<PlanNode>)newChildrenBuilder.build()));
    }
}

