/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request;

import java.util.HashMap;
import java.util.Map;

public enum ConfigPhysicalPlanType {
    ApplyConfigNode(0),
    RemoveConfigNode(1),
    UpdateVersionInfo(2),
    UpdateClusterId(3),
    RegisterDataNode(100),
    GetDataNodeConfiguration(101),
    RemoveDataNode(102),
    UpdateDataNodeConfiguration(103),
    RegisterAINode(104),
    UpdateAINodeConfiguration(105),
    RemoveAINode(106),
    GetAINodeConfiguration(107),
    CreateDatabase(200),
    SetTTL(201),
    SetSchemaReplicationFactor(202),
    SetDataReplicationFactor(203),
    SetTimePartitionInterval(204),
    AdjustMaxRegionGroupNum(205),
    DeleteDatabase(206),
    PreDeleteDatabase(207),
    GetDatabase(208),
    CountDatabase(209),
    AlterDatabase(210),
    ShowTTL(211),
    CreateRegionGroups(300),
    DeleteRegionGroups(301),
    GetRegionInfoList(302),
    UpdateRegionLocation(303),
    OfferRegionMaintainTasks(304),
    PollRegionMaintainTask(305),
    GetRegionId(306),
    GetSeriesSlotList(307),
    GetTimeSlotList(308),
    PollSpecificRegionMaintainTask(309),
    CountTimeSlotList(310),
    AddRegionLocation(311),
    RemoveRegionLocation(312),
    GetSchemaPartition(400),
    CreateSchemaPartition(401),
    GetOrCreateSchemaPartition(402),
    GetDataPartition(403),
    CreateDataPartition(404),
    GetOrCreateDataPartition(405),
    GetNodePathsPartition(406),
    AutoCleanPartitionTable(407),
    UpdateProcedure(500),
    DeleteProcedure(501),
    Author(600),
    CreateUserDep(601),
    CreateRoleDep(602),
    DropUserDep(603),
    DropRoleDep(604),
    GrantRoleDep(605),
    GrantUserDep(606),
    GrantRoleToUserDep(607),
    RevokeUserDep(608),
    RevokeRoleDep(609),
    RevokeRoleFromUserDep(610),
    UpdateUserDep(611),
    ListUserDep(612),
    ListRoleDep(613),
    ListUserPrivilegeDep(614),
    ListRolePrivilegeDep(615),
    ListUserRolesDep(616),
    ListRoleUsersDep(617),
    CreateUser(621),
    CreateRole(622),
    DropUser(623),
    DropRole(624),
    GrantRole(625),
    GrantUser(626),
    GrantRoleToUser(627),
    RevokeUser(628),
    RevokeRole(629),
    RevokeRoleFromUser(630),
    UpdateUser(631),
    ListUser(632),
    ListRole(633),
    ListUserPrivilege(634),
    ListRolePrivilege(635),
    ListUserRoles(636),
    ListRoleUsers(637),
    CreateUserWithRawPassword(638),
    RCreateUser(641),
    RCreateRole(642),
    RUpdateUser(643),
    RDropUser(644),
    RDropRole(645),
    RGrantUserRole(646),
    RRevokeUserRole(647),
    RGrantUserAny(648),
    RGrantRoleAny(649),
    RGrantUserAll(650),
    RGrantRoleAll(652),
    RGrantUserDBPriv(653),
    RGrantUserTBPriv(654),
    RGrantRoleDBPriv(655),
    RGrantRoleTBPriv(656),
    RRevokeUserAny(657),
    RRevokeRoleAny(658),
    RRevokeUserAll(659),
    RRevokeRoleAll(660),
    RRevokeUserDBPriv(661),
    RRevokeUserTBPriv(662),
    RRevokeRoleDBPriv(663),
    RRevokeRoleTBPriv(664),
    RGrantUserSysPri(665),
    RGrantRoleSysPri(666),
    RRevokeUserSysPri(667),
    RRevokeRoleSysPri(668),
    RListUser(669),
    RListRole(670),
    RListUserPrivilege(671),
    RListRolePrivilege(672),
    CreateFunction(700),
    DropTreeModelFunction(701),
    GetFunctionTable(702),
    GetFunctionJar(703),
    GetAllFunctionTable(704),
    UpdateFunction(705),
    DropTableModelFunction(706),
    CreateSchemaTemplate(800),
    GetAllSchemaTemplate(801),
    GetSchemaTemplate(802),
    CheckTemplateSettable(803),
    SetSchemaTemplate(804),
    GetPathsSetTemplate(805),
    GetAllTemplateSetInfo(806),
    GetTemplateSetInfo(807),
    PreUnsetTemplate(808),
    RollbackUnsetTemplate(809),
    UnsetTemplate(810),
    DropSchemaTemplate(811),
    PreSetSchemaTemplate(812),
    CommitSetSchemaTemplate(813),
    ExtendSchemaTemplate(814),
    PreCreateTable(850),
    RollbackCreateTable(851),
    CommitCreateTable(852),
    AddTableColumn(853),
    SetTableProperties(854),
    ShowTable(855),
    FetchTable(856),
    RenameTableColumn(857),
    PreDeleteTable(858),
    CommitDeleteTable(859),
    PreDeleteColumn(860),
    CommitDeleteColumn(861),
    DescTable(862),
    ShowTable4InformationSchema(863),
    DescTable4InformationSchema(864),
    SetTableColumnComment(865),
    SetTableComment(866),
    CreatePipeSinkV1(900),
    DropPipeSinkV1(901),
    GetPipeSinkV1(902),
    PreCreatePipeV1(903),
    SetPipeStatusV1(904),
    DropPipeV1(905),
    ShowPipeV1(906),
    RecordPipeMessageV1(907),
    AddTriggerInTable(1000),
    DeleteTriggerInTable(1001),
    GetTriggerTable(1002),
    UpdateTriggerStateInTable(1003),
    GetTriggerJar(1004),
    UpdateTriggersOnTransferNodes(1005),
    UpdateTriggerLocation(1006),
    GetTransferringTriggers(1007),
    GetTriggerLocation(1008),
    DROP_CQ(1100),
    ACTIVE_CQ(1101),
    ADD_CQ(1102),
    UPDATE_CQ_LAST_EXEC_TIME(1103),
    SHOW_CQ(1104),
    CreateModel(1200),
    UpdateModelInfo(1201),
    UpdateModelState(1202),
    DropModel(1203),
    ShowModel(1204),
    GetModelInfo(1206),
    DropModelInNode(1207),
    CreatePipePlugin(1300),
    DropPipePlugin(1301),
    GetPipePluginTable(1302),
    GetPipePluginJar(1303),
    setSpaceQuota(1400),
    setThrottleQuota(1401),
    CreatePipeV2(1500),
    SetPipeStatusV2(1501),
    DropPipeV2(1502),
    ShowPipeV2(1503),
    AlterPipeV2(1504),
    OperateMultiplePipesV2(1505),
    PipeHandleLeaderChange(1600),
    PipeHandleMetaChange(1601),
    PipeEnriched(1700),
    PipeUnsetTemplate(1701),
    PipeDeleteTimeSeries(1702),
    PipeDeleteLogicalView(1703),
    PipeDeactivateTemplate(1704),
    PipeSetTTL(1705),
    PipeCreateTable(1706),
    PipeDeleteDevices(1707),
    CreateTopic(1800),
    DropTopic(1801),
    ShowTopic(1802),
    AlterTopic(1803),
    AlterMultipleTopics(1804),
    TopicHandleMetaChange(1805),
    AlterConsumerGroup(1900),
    ConsumerGroupHandleMetaChange(1901),
    ShowSubscription(2000),
    TestOnly(30000);

    private final short planType;
    private static final Map<Short, ConfigPhysicalPlanType> PLAN_TYPE_MAP;

    private ConfigPhysicalPlanType(short planType) {
        this.planType = planType;
    }

    public short getPlanType() {
        return this.planType;
    }

    public static ConfigPhysicalPlanType convertToConfigPhysicalPlanType(short planType) {
        return PLAN_TYPE_MAP.getOrDefault(planType, null);
    }

    static {
        PLAN_TYPE_MAP = new HashMap<Short, ConfigPhysicalPlanType>();
        for (ConfigPhysicalPlanType planType : ConfigPhysicalPlanType.values()) {
            PLAN_TYPE_MAP.put(planType.getPlanType(), planType);
        }
    }
}

