/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.record;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.tsfile.annotations.TableModel;
import org.apache.tsfile.annotations.TreeModel;
import org.apache.tsfile.annotations.TsFileApi;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.StringArrayDeviceID;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class Tablet {
    private static final int DEFAULT_SIZE = 1024;
    private static final String NOT_SUPPORT_DATATYPE = "Data type %s is not supported.";
    private static final LocalDate EMPTY_DATE = LocalDate.of(1000, 1, 1);
    private String insertTargetName;
    private List<IMeasurementSchema> schemas;
    private List<ColumnCategory> columnCategories;
    private List<Integer> idColumnIndexes = new ArrayList<Integer>();
    private final Map<String, Integer> measurementIndex;
    private long[] timestamps;
    private Object[] values;
    private BitMap[] bitMaps;
    private boolean autoUpdateBitMaps = false;
    private int rowSize;
    private final int maxRowNumber;

    @TreeModel
    public Tablet(String deviceId, List<IMeasurementSchema> schemas) {
        this(deviceId, schemas, 1024);
    }

    @TreeModel
    public Tablet(String deviceId, List<IMeasurementSchema> schemas, int maxRowNumber) {
        this.insertTargetName = deviceId;
        this.schemas = new ArrayList<IMeasurementSchema>(schemas);
        this.setColumnCategories(ColumnCategory.nCopy((ColumnCategory)ColumnCategory.FIELD, (int)schemas.size()));
        this.maxRowNumber = maxRowNumber;
        this.measurementIndex = new HashMap<String, Integer>();
        this.constructMeasurementIndexMap();
        this.createColumns();
        this.reset();
    }

    @TreeModel
    public Tablet(IDeviceID deviceID, List<String> measurementList, List<TSDataType> dataTypeList) {
        this(deviceID, measurementList, dataTypeList, 1024);
    }

    @TreeModel
    public Tablet(IDeviceID deviceID, List<String> measurementList, List<TSDataType> dataTypeList, int maxRowNumber) {
        this(deviceID.toString(), measurementList, dataTypeList, ColumnCategory.nCopy((ColumnCategory)ColumnCategory.FIELD, (int)measurementList.size()), maxRowNumber, true);
    }

    @TsFileApi
    @TableModel
    public Tablet(List<String> columnNameList, List<TSDataType> dataTypeList) {
        this(columnNameList, dataTypeList, 1024);
    }

    @TsFileApi
    @TableModel
    public Tablet(List<String> columnNameList, List<TSDataType> dataTypeList, int maxRowNum) {
        this(null, columnNameList, dataTypeList, null, maxRowNum, false);
    }

    @TableModel
    public Tablet(String tableName, List<String> columnNameList, List<TSDataType> dataTypeList, List<ColumnCategory> columnCategoryList) {
        this(tableName, columnNameList, dataTypeList, columnCategoryList, 1024);
    }

    @TableModel
    public Tablet(String tableName, List<String> columnNameList, List<TSDataType> dataTypeList, List<ColumnCategory> columnCategoryList, int maxRowNum) {
        this(tableName, columnNameList, dataTypeList, columnCategoryList, maxRowNum, true);
    }

    protected Tablet(String insertTargetName, List<String> measurementList, List<TSDataType> dataTypeList, List<ColumnCategory> columnCategoryList, int maxRowNum, boolean hasColumnCategory) {
        this.insertTargetName = insertTargetName;
        this.schemas = new ArrayList<IMeasurementSchema>(measurementList.size());
        for (int i = 0; i < measurementList.size(); ++i) {
            this.schemas.add(new MeasurementSchema(measurementList.get(i), dataTypeList.get(i)));
        }
        if (hasColumnCategory) {
            this.setColumnCategories(columnCategoryList);
        }
        this.maxRowNumber = maxRowNum;
        this.measurementIndex = new HashMap<String, Integer>();
        this.constructMeasurementIndexMap();
        this.createColumns();
        this.reset();
    }

    @TreeModel
    public Tablet(String deviceId, List<IMeasurementSchema> schemas, long[] timestamps, Object[] values, BitMap[] bitMaps, int maxRowNumber) {
        this.insertTargetName = deviceId;
        this.schemas = schemas;
        this.setColumnCategories(ColumnCategory.nCopy((ColumnCategory)ColumnCategory.FIELD, (int)schemas.size()));
        this.timestamps = timestamps;
        this.values = values;
        this.bitMaps = bitMaps;
        this.maxRowNumber = maxRowNumber;
        this.rowSize = maxRowNumber;
        this.measurementIndex = new HashMap<String, Integer>();
        this.constructMeasurementIndexMap();
    }

    @TableModel
    public Tablet(String tableName, List<IMeasurementSchema> schemas, List<ColumnCategory> columnCategories, long[] timestamps, Object[] values, BitMap[] bitMaps, int maxRowNumber) {
        this.insertTargetName = tableName;
        this.schemas = schemas;
        this.setColumnCategories(columnCategories);
        this.timestamps = timestamps;
        this.values = values;
        this.bitMaps = bitMaps;
        this.maxRowNumber = maxRowNumber;
        this.rowSize = maxRowNumber;
        this.measurementIndex = new HashMap<String, Integer>();
        this.constructMeasurementIndexMap();
    }

    private void constructMeasurementIndexMap() {
        int indexInSchema = 0;
        for (IMeasurementSchema schema : this.schemas) {
            this.measurementIndex.put(schema.getMeasurementName(), indexInSchema);
            ++indexInSchema;
        }
    }

    public void setInsertTargetName(String insertTargetName) {
        this.insertTargetName = insertTargetName;
    }

    public void setSchemas(List<IMeasurementSchema> schemas) {
        this.schemas = schemas;
    }

    public void initBitMaps() {
        this.bitMaps = new BitMap[this.schemas.size()];
        for (int column = 0; column < this.schemas.size(); ++column) {
            BitMap bitMap;
            this.bitMaps[column] = bitMap = new BitMap(this.getMaxRowNumber());
        }
    }

    @TsFileApi
    public void addTimestamp(int rowIndex, long timestamp) {
        this.timestamps[rowIndex] = timestamp;
        this.rowSize = Math.max(this.rowSize, rowIndex + 1);
        this.initBitMapsWithApiUsage();
    }

    public void addValue(String measurementId, int rowIndex, Object value) {
        int indexOfSchema = this.getColumnIndexByMeasurement(measurementId);
        IMeasurementSchema measurementSchema = this.schemas.get(indexOfSchema);
        this.addValueOfDataType(measurementSchema.getType(), rowIndex, indexOfSchema, value);
    }

    private void addValueOfDataType(TSDataType dataType, int rowIndex, int indexOfSchema, Object value) {
        this.updateBitMap(rowIndex, indexOfSchema, value == null);
        switch (dataType) {
            case TEXT: 
            case STRING: 
            case BLOB: {
                if (value != null && !(value instanceof Binary) && !(value instanceof String)) {
                    throw new IllegalArgumentException(String.format("Expected value of type Binary for data type %s, but got %s", dataType, value.getClass().getName()));
                }
                Binary[] sensor = (Binary[])this.values[indexOfSchema];
                if (value instanceof Binary) {
                    sensor[rowIndex] = (Binary)value;
                    break;
                }
                sensor[rowIndex] = value != null ? new Binary(((String)value).getBytes(TSFileConfig.STRING_CHARSET)) : Binary.EMPTY_VALUE;
                break;
            }
            case FLOAT: {
                if (value != null && !(value instanceof Float)) {
                    throw new IllegalArgumentException(String.format("Expected value of type Float for data type %s, but got %s", dataType, value.getClass().getName()));
                }
                float[] sensor = (float[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? ((Float)value).floatValue() : Float.MIN_VALUE;
                break;
            }
            case INT32: {
                if (value != null && !(value instanceof Integer)) {
                    throw new IllegalArgumentException(String.format("Expected value of type Integer for data type %s, but got %s", dataType, value.getClass().getName()));
                }
                int[] sensor = (int[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? (Integer)value : Integer.MIN_VALUE;
                break;
            }
            case DATE: {
                if (value != null && !(value instanceof LocalDate)) {
                    throw new IllegalArgumentException(String.format("Expected value of type LocalDate for data type %s, but got %s", dataType, value.getClass().getName()));
                }
                LocalDate[] sensor = (LocalDate[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? (LocalDate)value : EMPTY_DATE;
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                if (value != null && !(value instanceof Long)) {
                    throw new IllegalArgumentException(String.format("Expected value of type Long for data type %s, but got %s", dataType, value.getClass().getName()));
                }
                long[] sensor = (long[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? (Long)value : Long.MIN_VALUE;
                break;
            }
            case DOUBLE: {
                if (value != null && !(value instanceof Double)) {
                    throw new IllegalArgumentException(String.format("Expected value of type Double for data type %s, but got %s", dataType, value.getClass().getName()));
                }
                double[] sensor = (double[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? (Double)value : Double.MIN_VALUE;
                break;
            }
            case BOOLEAN: {
                if (value != null && !(value instanceof Boolean)) {
                    throw new IllegalArgumentException(String.format("Expected value of type Boolean for data type %s, but got %s", dataType, value.getClass().getName()));
                }
                boolean[] sensor = (boolean[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null && (Boolean)value != false;
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, dataType));
            }
        }
    }

    @TsFileApi
    public void addValue(int rowIndex, String measurement, int val) {
        int columnIndex = this.getColumnIndexByMeasurement(measurement);
        this.addValue(rowIndex, columnIndex, val);
    }

    @TsFileApi
    public void addValue(int rowIndex, int columnIndex, int val) {
        if (!(this.values[columnIndex] instanceof int[])) {
            throw new IllegalArgumentException("The data type of column index " + columnIndex + " is not INT32");
        }
        int[] sensor = (int[])this.values[columnIndex];
        sensor[rowIndex] = val;
        this.updateBitMap(rowIndex, columnIndex, false);
    }

    @TsFileApi
    public void addValue(int rowIndex, String measurement, long val) {
        int columnIndex = this.getColumnIndexByMeasurement(measurement);
        this.addValue(rowIndex, columnIndex, val);
    }

    @TsFileApi
    public void addValue(int rowIndex, int columnIndex, long val) {
        if (!(this.values[columnIndex] instanceof long[])) {
            throw new IllegalArgumentException("The data type of column index " + columnIndex + " is not INT64/TIMESTAMP");
        }
        long[] sensor = (long[])this.values[columnIndex];
        sensor[rowIndex] = val;
        this.updateBitMap(rowIndex, columnIndex, false);
    }

    @TsFileApi
    public void addValue(int rowIndex, String measurement, float val) {
        int columnIndex = this.getColumnIndexByMeasurement(measurement);
        this.addValue(rowIndex, columnIndex, val);
    }

    @TsFileApi
    public void addValue(int rowIndex, int columnIndex, float val) {
        if (!(this.values[columnIndex] instanceof float[])) {
            throw new IllegalArgumentException("The data type of column index " + columnIndex + " is not FLOAT");
        }
        float[] sensor = (float[])this.values[columnIndex];
        sensor[rowIndex] = val;
        this.updateBitMap(rowIndex, columnIndex, false);
    }

    @TsFileApi
    public void addValue(int rowIndex, String measurement, double val) {
        int columnIndex = this.getColumnIndexByMeasurement(measurement);
        this.addValue(rowIndex, columnIndex, val);
    }

    @TsFileApi
    public void addValue(int rowIndex, int columnIndex, double val) {
        if (!(this.values[columnIndex] instanceof double[])) {
            throw new IllegalArgumentException("The data type of column index " + columnIndex + " is not DOUBLE");
        }
        double[] sensor = (double[])this.values[columnIndex];
        sensor[rowIndex] = val;
        this.updateBitMap(rowIndex, columnIndex, false);
    }

    @TsFileApi
    public void addValue(int rowIndex, String measurement, boolean val) {
        int columnIndex = this.getColumnIndexByMeasurement(measurement);
        this.addValue(rowIndex, columnIndex, val);
    }

    @TsFileApi
    public void addValue(int rowIndex, int columnIndex, boolean val) {
        if (!(this.values[columnIndex] instanceof boolean[])) {
            throw new IllegalArgumentException("The data type of column index " + columnIndex + " is not BOOLEAN");
        }
        boolean[] sensor = (boolean[])this.values[columnIndex];
        sensor[rowIndex] = val;
        this.updateBitMap(rowIndex, columnIndex, false);
    }

    @TsFileApi
    public void addValue(int rowIndex, String measurement, String val) {
        int columnIndex = this.getColumnIndexByMeasurement(measurement);
        this.addValue(rowIndex, columnIndex, val);
    }

    @TsFileApi
    public void addValue(int rowIndex, int columnIndex, String val) {
        if (!(this.values[columnIndex] instanceof Binary[])) {
            throw new IllegalArgumentException("The data type of column index " + columnIndex + " is not TEXT/STRING/BLOB");
        }
        Binary[] sensor = (Binary[])this.values[columnIndex];
        sensor[rowIndex] = new Binary(val, TSFileConfig.STRING_CHARSET);
        this.updateBitMap(rowIndex, columnIndex, false);
    }

    @TsFileApi
    public void addValue(int rowIndex, String measurement, byte[] val) {
        int columnIndex = this.getColumnIndexByMeasurement(measurement);
        this.addValue(rowIndex, columnIndex, val);
    }

    @TsFileApi
    public void addValue(int rowIndex, int columnIndex, byte[] val) {
        if (!(this.values[columnIndex] instanceof Binary[])) {
            throw new IllegalArgumentException("The data type of column index " + columnIndex + " is not TEXT/STRING/BLOB");
        }
        Binary[] sensor = (Binary[])this.values[columnIndex];
        sensor[rowIndex] = new Binary(val);
        this.updateBitMap(rowIndex, columnIndex, false);
    }

    @TsFileApi
    public void addValue(int rowIndex, String measurement, LocalDate val) {
        int columnIndex = this.getColumnIndexByMeasurement(measurement);
        this.addValue(rowIndex, columnIndex, val);
    }

    @TsFileApi
    public void addValue(int rowIndex, int columnIndex, LocalDate val) {
        if (!(this.values[columnIndex] instanceof LocalDate[])) {
            throw new IllegalArgumentException("The data type of column index " + columnIndex + " is not DATE");
        }
        LocalDate[] sensor = (LocalDate[])this.values[columnIndex];
        sensor[rowIndex] = val;
        this.updateBitMap(rowIndex, columnIndex, false);
    }

    private int getColumnIndexByMeasurement(String measurement) {
        if (measurement == null) {
            throw new IllegalArgumentException("measurement should be non null value");
        }
        Integer columnIndex = this.measurementIndex.get(measurement);
        if (columnIndex == null) {
            throw new IllegalArgumentException("No measurement for " + measurement);
        }
        return columnIndex;
    }

    private void updateBitMap(int rowIndex, int columnIndex, boolean mark) {
        this.initBitMapsWithApiUsage();
        if (mark) {
            this.bitMaps[columnIndex].mark(rowIndex);
        } else {
            this.bitMaps[columnIndex].unmark(rowIndex);
        }
    }

    private void initBitMapsWithApiUsage() {
        if (this.bitMaps == null) {
            this.initBitMaps();
        }
        if (!this.autoUpdateBitMaps) {
            this.autoUpdateBitMaps = true;
            for (BitMap bitMap : this.bitMaps) {
                bitMap.markAll();
            }
        }
    }

    public List<IMeasurementSchema> getSchemas() {
        return this.schemas;
    }

    public int getMaxRowNumber() {
        return this.maxRowNumber;
    }

    public void reset() {
        this.rowSize = 0;
        if (this.bitMaps != null) {
            for (BitMap bitMap : this.bitMaps) {
                if (bitMap == null) continue;
                if (this.autoUpdateBitMaps) {
                    bitMap.markAll();
                    continue;
                }
                bitMap.reset();
            }
        }
    }

    private void createColumns() {
        this.timestamps = new long[this.maxRowNumber];
        int valueColumnsSize = this.schemas.size();
        this.values = new Object[valueColumnsSize];
        int columnIndex = 0;
        for (int i = 0; i < this.schemas.size(); ++i) {
            IMeasurementSchema schema = this.schemas.get(i);
            TSDataType dataType = schema.getType();
            this.values[columnIndex] = this.createValueColumnOfDataType(dataType);
            ++columnIndex;
        }
    }

    private Object createValueColumnOfDataType(TSDataType dataType) {
        Object[] valueColumn;
        switch (dataType) {
            case INT32: {
                valueColumn = new int[this.maxRowNumber];
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                valueColumn = new long[this.maxRowNumber];
                break;
            }
            case FLOAT: {
                valueColumn = new float[this.maxRowNumber];
                break;
            }
            case DOUBLE: {
                valueColumn = new double[this.maxRowNumber];
                break;
            }
            case BOOLEAN: {
                valueColumn = new boolean[this.maxRowNumber];
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                valueColumn = new Binary[this.maxRowNumber];
                break;
            }
            case DATE: {
                valueColumn = new LocalDate[this.maxRowNumber];
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, dataType));
            }
        }
        return valueColumn;
    }

    public ByteBuffer serialize() throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
                this.serialize(outputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(this.insertTargetName, (OutputStream)stream);
        ReadWriteIOUtils.write(this.rowSize, (OutputStream)stream);
        this.writeMeasurementSchemas(stream);
        this.writeTimes(stream);
        this.writeBitMaps(stream);
        this.writeValues(stream);
    }

    private void writeMeasurementSchemas(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(BytesUtils.boolToByte(this.schemas != null), (OutputStream)stream);
        if (this.schemas != null) {
            ReadWriteIOUtils.write(this.schemas.size(), (OutputStream)stream);
            for (int i = 0; i < this.schemas.size(); ++i) {
                IMeasurementSchema schema = this.schemas.get(i);
                ColumnCategory columnCategory = this.columnCategories.get(i);
                if (schema == null) {
                    ReadWriteIOUtils.write(BytesUtils.boolToByte(false), (OutputStream)stream);
                    continue;
                }
                ReadWriteIOUtils.write(BytesUtils.boolToByte(true), (OutputStream)stream);
                schema.serializeTo(stream);
                ReadWriteIOUtils.write((byte)columnCategory.ordinal(), (OutputStream)stream);
            }
        }
    }

    private void writeTimes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(BytesUtils.boolToByte(this.timestamps != null), (OutputStream)stream);
        if (this.timestamps != null) {
            for (int i = 0; i < this.rowSize; ++i) {
                ReadWriteIOUtils.write(this.timestamps[i], (OutputStream)stream);
            }
        }
    }

    private void writeBitMaps(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(BytesUtils.boolToByte(this.bitMaps != null), (OutputStream)stream);
        if (this.bitMaps != null) {
            int size = this.schemas == null ? 0 : this.schemas.size();
            for (int i = 0; i < size; ++i) {
                if (this.bitMaps[i] == null || this.bitMaps[i].isAllUnmarked(this.rowSize)) {
                    ReadWriteIOUtils.write(BytesUtils.boolToByte(false), (OutputStream)stream);
                    continue;
                }
                ReadWriteIOUtils.write(BytesUtils.boolToByte(true), (OutputStream)stream);
                ReadWriteIOUtils.write(this.rowSize, (OutputStream)stream);
                ReadWriteIOUtils.write(new Binary(this.bitMaps[i].getTruncatedByteArray(this.rowSize)), (OutputStream)stream);
            }
        }
    }

    private void writeValues(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(BytesUtils.boolToByte(this.values != null), (OutputStream)stream);
        if (this.values != null) {
            int size = this.schemas == null ? 0 : this.schemas.size();
            for (int i = 0; i < size; ++i) {
                this.serializeColumn(this.schemas.get(i).getType(), this.values[i], stream, this.columnCategories.get(i));
            }
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, DataOutputStream stream, ColumnCategory columnCategory) throws IOException {
        ReadWriteIOUtils.write(BytesUtils.boolToByte(column != null), (OutputStream)stream);
        if (column != null) {
            switch (dataType) {
                case INT32: {
                    int[] intValues = (int[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(intValues[j], (OutputStream)stream);
                    }
                    break;
                }
                case DATE: {
                    LocalDate[] dateValues = (LocalDate[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(dateValues[j] == null ? 10000101 : DateUtils.parseDateExpressionToInt(dateValues[j]), (OutputStream)stream);
                    }
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    long[] longValues = (long[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(longValues[j], (OutputStream)stream);
                    }
                    break;
                }
                case FLOAT: {
                    float[] floatValues = (float[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(floatValues[j], (OutputStream)stream);
                    }
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = (double[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(doubleValues[j], (OutputStream)stream);
                    }
                    break;
                }
                case BOOLEAN: {
                    boolean[] boolValues = (boolean[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(BytesUtils.boolToByte(boolValues[j]), (OutputStream)stream);
                    }
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    Binary[] binaryValues = (Binary[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(BytesUtils.boolToByte(binaryValues[j] != null), (OutputStream)stream);
                        if (binaryValues[j] == null) continue;
                        ReadWriteIOUtils.write(binaryValues[j], (OutputStream)stream);
                    }
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, dataType));
                }
            }
        }
    }

    public static Tablet deserialize(ByteBuffer byteBuffer) {
        String deviceId = ReadWriteIOUtils.readString(byteBuffer);
        int rowSize = ReadWriteIOUtils.readInt(byteBuffer);
        int schemaSize = 0;
        ArrayList<IMeasurementSchema> schemas = new ArrayList<IMeasurementSchema>();
        ArrayList<ColumnCategory> columnCategories = new ArrayList<ColumnCategory>();
        boolean isSchemasNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
        if (isSchemasNotNull) {
            schemaSize = ReadWriteIOUtils.readInt(byteBuffer);
            for (int i = 0; i < schemaSize; ++i) {
                boolean hasSchema = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
                if (!hasSchema) continue;
                schemas.add(MeasurementSchema.deserializeFrom(byteBuffer));
                columnCategories.add(ColumnCategory.values()[byteBuffer.get()]);
            }
        }
        long[] times = new long[rowSize];
        boolean isTimesNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
        if (isTimesNotNull) {
            for (int i = 0; i < rowSize; ++i) {
                times[i] = ReadWriteIOUtils.readLong(byteBuffer);
            }
        }
        BitMap[] bitMaps = new BitMap[schemaSize];
        boolean isBitMapsNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
        if (isBitMapsNotNull) {
            bitMaps = Tablet.readBitMapsFromBuffer(byteBuffer, schemaSize);
        }
        TSDataType[] dataTypes = (TSDataType[])schemas.stream().map(IMeasurementSchema::getType).toArray(TSDataType[]::new);
        Object[] values = new Object[schemaSize];
        boolean isValuesNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
        if (isValuesNotNull) {
            values = Tablet.readTabletValuesFromBuffer(byteBuffer, dataTypes, columnCategories, schemaSize, rowSize);
        }
        Tablet tablet = new Tablet(deviceId, schemas, columnCategories, times, values, bitMaps, rowSize);
        tablet.constructMeasurementIndexMap();
        return tablet;
    }

    public static BitMap[] readBitMapsFromBuffer(ByteBuffer byteBuffer, int columns) {
        BitMap[] bitMaps = new BitMap[columns];
        for (int i = 0; i < columns; ++i) {
            boolean hasBitMap = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
            if (!hasBitMap) continue;
            int size = ReadWriteIOUtils.readInt(byteBuffer);
            Binary valueBinary = ReadWriteIOUtils.readBinary(byteBuffer);
            bitMaps[i] = new BitMap(size, valueBinary.getValues());
        }
        return bitMaps;
    }

    public static Object[] readTabletValuesFromBuffer(ByteBuffer byteBuffer, TSDataType[] types, List<ColumnCategory> columnCategories, int columns, int rowSize) {
        Object[] values = new Object[columns];
        block9: for (int i = 0; i < columns; ++i) {
            boolean isValueColumnsNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
            if (!isValueColumnsNotNull) continue;
            switch (types[i]) {
                case BOOLEAN: {
                    boolean[] boolValues = new boolean[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        boolValues[index] = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
                    }
                    values[i] = boolValues;
                    continue block9;
                }
                case INT32: {
                    int[] intValues = new int[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        intValues[index] = ReadWriteIOUtils.readInt(byteBuffer);
                    }
                    values[i] = intValues;
                    continue block9;
                }
                case DATE: {
                    LocalDate[] dateValues = new LocalDate[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        dateValues[index] = DateUtils.parseIntToLocalDate(ReadWriteIOUtils.readInt(byteBuffer));
                    }
                    values[i] = dateValues;
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    long[] longValues = new long[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        longValues[index] = ReadWriteIOUtils.readLong(byteBuffer);
                    }
                    values[i] = longValues;
                    continue block9;
                }
                case FLOAT: {
                    float[] floatValues = new float[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        floatValues[index] = ReadWriteIOUtils.readFloat(byteBuffer);
                    }
                    values[i] = floatValues;
                    continue block9;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        doubleValues[index] = ReadWriteIOUtils.readDouble(byteBuffer);
                    }
                    values[i] = doubleValues;
                    continue block9;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    Binary[] binaryValues = new Binary[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        boolean isNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
                        binaryValues[index] = isNotNull ? ReadWriteIOUtils.readBinary(byteBuffer) : Binary.EMPTY_VALUE;
                    }
                    values[i] = binaryValues;
                    continue block9;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", types[i]));
                }
            }
        }
        return values;
    }

    public boolean equals(Object o) {
        int columns;
        boolean flag;
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Tablet that = (Tablet)o;
        boolean bl = flag = that.rowSize == this.rowSize && Objects.equals(that.insertTargetName, this.insertTargetName) && Objects.equals(that.schemas, this.schemas) && Objects.equals(that.columnCategories, this.columnCategories) && Objects.equals(that.measurementIndex, this.measurementIndex);
        if (!flag) {
            return false;
        }
        int n = columns = this.schemas == null ? 0 : this.schemas.size();
        if (!this.isTimestampsEqual(this.timestamps, that.timestamps, this.rowSize) || !this.isBitMapsEqual(this.bitMaps, that.bitMaps, columns)) {
            return false;
        }
        Object[] thatValues = that.values;
        if (thatValues == this.values) {
            return true;
        }
        if (thatValues == null || this.values == null) {
            return false;
        }
        if (thatValues.length != this.values.length) {
            return false;
        }
        int n2 = this.values.length;
        block9: for (int i = 0; i < n2; ++i) {
            if (thatValues[i] == this.values[i]) continue;
            if (thatValues[i] == null || this.values[i] == null) {
                return false;
            }
            if (!thatValues[i].getClass().equals(this.values[i].getClass())) {
                return false;
            }
            switch (this.schemas.get(i).getType()) {
                case INT32: {
                    int[] thisIntValues = (int[])this.values[i];
                    int[] thatIntValues = (int[])thatValues[i];
                    if (thisIntValues.length < this.rowSize || thatIntValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisIntValues[j] == thatIntValues[j]) continue;
                        return false;
                    }
                    continue block9;
                }
                case DATE: {
                    LocalDate[] thisDateValues = (LocalDate[])this.values[i];
                    LocalDate[] thatDateValues = (LocalDate[])thatValues[i];
                    if (thisDateValues.length < this.rowSize || thatDateValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisDateValues[j].equals(thatDateValues[j])) continue;
                        return false;
                    }
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    long[] thisLongValues = (long[])this.values[i];
                    long[] thatLongValues = (long[])thatValues[i];
                    if (thisLongValues.length < this.rowSize || thatLongValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisLongValues[j] == thatLongValues[j]) continue;
                        return false;
                    }
                    continue block9;
                }
                case FLOAT: {
                    float[] thisFloatValues = (float[])this.values[i];
                    float[] thatFloatValues = (float[])thatValues[i];
                    if (thisFloatValues.length < this.rowSize || thatFloatValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisFloatValues[j] == thatFloatValues[j]) continue;
                        return false;
                    }
                    continue block9;
                }
                case DOUBLE: {
                    double[] thisDoubleValues = (double[])this.values[i];
                    double[] thatDoubleValues = (double[])thatValues[i];
                    if (thisDoubleValues.length < this.rowSize || thatDoubleValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisDoubleValues[j] == thatDoubleValues[j]) continue;
                        return false;
                    }
                    continue block9;
                }
                case BOOLEAN: {
                    boolean[] thisBooleanValues = (boolean[])this.values[i];
                    boolean[] thatBooleanValues = (boolean[])thatValues[i];
                    if (thisBooleanValues.length < this.rowSize || thatBooleanValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisBooleanValues[j] == thatBooleanValues[j]) continue;
                        return false;
                    }
                    continue block9;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    Binary[] thisBinaryValues = (Binary[])this.values[i];
                    Binary[] thatBinaryValues = (Binary[])thatValues[i];
                    if (thisBinaryValues.length < this.rowSize || thatBinaryValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisBinaryValues[j].equals((Object)thatBinaryValues[j])) continue;
                        return false;
                    }
                    continue block9;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, this.schemas.get(i).getType()));
                }
            }
        }
        return true;
    }

    private boolean isTimestampsEqual(long[] thisTimestamps, long[] thatTimestamps, int rowSize) {
        if (thisTimestamps == thatTimestamps) {
            return true;
        }
        if (thisTimestamps == null || thatTimestamps == null) {
            return false;
        }
        for (int i = 0; i < rowSize; ++i) {
            if (thisTimestamps[i] == thatTimestamps[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isBitMapsEqual(BitMap[] thisBitMaps, BitMap[] thatBitMaps, int columns) {
        if (thisBitMaps == thatBitMaps) {
            return true;
        }
        if (thisBitMaps == null) {
            for (int i = 0; i < columns; ++i) {
                if (thatBitMaps[i] == null || thatBitMaps[i].isAllMarked()) continue;
                return false;
            }
            return true;
        }
        if (thatBitMaps == null) {
            for (int i = 0; i < columns; ++i) {
                if (thisBitMaps[i] == null || thisBitMaps[i].isAllMarked()) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < columns; ++i) {
            if (this.isBitMapEqual(thisBitMaps[i], thatBitMaps[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isBitMapEqual(BitMap thisBitMap, BitMap thatBitMap) {
        if (thisBitMap == thatBitMap) {
            return true;
        }
        if (thisBitMap == null) {
            return thatBitMap.isAllUnmarked(this.rowSize);
        }
        if (thatBitMap == null) {
            return thisBitMap.isAllUnmarked(this.rowSize);
        }
        return thisBitMap.equalsInRange((Object)thatBitMap, this.rowSize);
    }

    public boolean isNull(int i, int j) {
        return this.bitMaps != null && this.bitMaps[j] != null && this.bitMaps[j].isMarked(i);
    }

    public Object getValue(int i, int j) {
        if (this.isNull(i, j)) {
            return null;
        }
        switch (this.schemas.get(j).getType()) {
            case TEXT: 
            case STRING: 
            case BLOB: {
                return ((Binary[])this.values[j])[i];
            }
            case INT32: {
                return ((int[])this.values[j])[i];
            }
            case FLOAT: {
                return Float.valueOf(((float[])this.values[j])[i]);
            }
            case DOUBLE: {
                return ((double[])this.values[j])[i];
            }
            case BOOLEAN: {
                return ((boolean[])this.values[j])[i];
            }
            case INT64: 
            case TIMESTAMP: {
                return ((long[])this.values[j])[i];
            }
            case DATE: {
                return ((LocalDate[])this.values[j])[i];
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + this.schemas.get(j).getType());
    }

    @TableModel
    public IDeviceID getDeviceID(int i) {
        String[] idArray = new String[this.idColumnIndexes.size() + 1];
        idArray[0] = this.getTableName();
        for (int j = 0; j < this.idColumnIndexes.size(); ++j) {
            Object value = this.getValue(i, this.idColumnIndexes.get(j));
            idArray[j + 1] = value != null ? value.toString() : null;
        }
        return new StringArrayDeviceID(idArray);
    }

    public void setColumnCategories(List<ColumnCategory> columnCategories) {
        this.columnCategories = columnCategories;
        this.idColumnIndexes.clear();
        for (int i = 0; i < columnCategories.size(); ++i) {
            ColumnCategory columnCategory = columnCategories.get(i);
            if (!columnCategory.equals((Object)ColumnCategory.TAG)) continue;
            this.idColumnIndexes.add(i);
        }
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public long getTimestamp(int i) {
        return this.timestamps[i];
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(long[] timestamps) {
        this.timestamps = timestamps;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public BitMap[] getBitMaps() {
        return this.bitMaps;
    }

    public void setBitMaps(BitMap[] bitMaps) {
        this.bitMaps = bitMaps;
    }

    @TreeModel
    public String getDeviceId() {
        return this.insertTargetName;
    }

    @TreeModel
    public void setDeviceId(String deviceId) {
        this.insertTargetName = deviceId;
    }

    @TableModel
    public String getTableName() {
        return this.insertTargetName == null ? null : this.insertTargetName.toLowerCase();
    }

    @TableModel
    public void setTableName(String tableName) {
        this.insertTargetName = tableName.toLowerCase();
    }

    public List<ColumnCategory> getColumnTypes() {
        return this.columnCategories;
    }

    public boolean isSorted() {
        for (int i = 1; i < this.rowSize; ++i) {
            if (this.timestamps[i] >= this.timestamps[i - 1]) continue;
            return false;
        }
        return true;
    }
}

