/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;

class PendingRequest {
    private final TermIndex termIndex;
    private final RaftClientRequest request;
    private final TransactionContext entry;
    private final CompletableFuture<RaftClientReply> futureToComplete = new CompletableFuture();
    private final CompletableFuture<RaftClientReply> futureToReturn;

    PendingRequest(RaftClientRequest request, TransactionContext entry) {
        this.termIndex = entry == null ? null : TermIndex.valueOf((RaftProtos.LogEntryProto)entry.getLogEntryUnsafe());
        this.request = request;
        this.entry = entry;
        this.futureToReturn = request.is(RaftProtos.RaftClientRequestProto.TypeCase.FORWARD) ? this.futureToComplete.thenApply(reply -> this.convert(request, (RaftClientReply)reply)) : this.futureToComplete;
    }

    PendingRequest(SetConfigurationRequest request) {
        this((RaftClientRequest)request, null);
    }

    RaftClientReply convert(RaftClientRequest q, RaftClientReply p) {
        return RaftClientReply.newBuilder().setRequest(q).setCommitInfos(p.getCommitInfos()).setLogIndex(p.getLogIndex()).setMessage(p.getMessage()).setException(p.getException()).setSuccess(p.isSuccess()).build();
    }

    TermIndex getTermIndex() {
        return Objects.requireNonNull(this.termIndex, "termIndex == null");
    }

    RaftClientRequest getRequest() {
        return this.request;
    }

    public CompletableFuture<RaftClientReply> getFuture() {
        return this.futureToReturn;
    }

    TransactionContext getEntry() {
        return this.entry;
    }

    synchronized void setException(Throwable e) {
        Preconditions.assertTrue((e != null ? 1 : 0) != 0);
        this.futureToComplete.completeExceptionally(e);
    }

    synchronized void setReply(RaftClientReply r) {
        Preconditions.assertTrue((r != null ? 1 : 0) != 0);
        this.futureToComplete.complete(r);
    }

    TransactionContext setNotLeaderException(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        this.setReply(RaftClientReply.newBuilder().setRequest(this.getRequest()).setException((RaftException)nle).setCommitInfos(commitInfos).build());
        return this.getEntry();
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + "-" + this.termIndex + ":request=" + this.request;
    }
}

