/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.HyperLogLog;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.HyperLogLogBigArray;
import org.apache.tsfile.utils.RamUsageEstimator;

public class HyperLogLogStateFactory {
    public static SingleHyperLogLogState createSingleState() {
        return new SingleHyperLogLogState();
    }

    public static GroupedHyperLogLogState createGroupedState() {
        return new GroupedHyperLogLogState();
    }

    public static class SingleHyperLogLogState {
        private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SingleHyperLogLogState.class);
        private HyperLogLog hll;

        public HyperLogLog getHyperLogLog() {
            return this.hll;
        }

        public void setHyperLogLog(HyperLogLog value) {
            this.hll = value;
        }

        public long getEstimatedSize() {
            return INSTANCE_SIZE + this.hll.getEstimatedSize();
        }

        public void merge(HyperLogLog other) {
            if (this.hll == null) {
                this.setHyperLogLog(other);
            } else {
                this.hll.merge(other);
            }
        }
    }

    public static class GroupedHyperLogLogState {
        private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(GroupedHyperLogLogState.class);
        private HyperLogLogBigArray hlls = new HyperLogLogBigArray();

        public HyperLogLogBigArray getHyperLogLogs() {
            return this.hlls;
        }

        public void setHyperLogLogs(HyperLogLogBigArray value) {
            Objects.requireNonNull(value, "value is null");
            this.hlls = value;
        }

        public long getEstimatedSize() {
            return INSTANCE_SIZE + this.hlls.sizeOf();
        }

        public void merge(int groupId, HyperLogLog hll) {
            HyperLogLog existingHll = this.hlls.get((long)groupId, hll);
            if (!existingHll.equals(hll)) {
                existingHll.merge(hll);
            }
        }

        public boolean isEmpty() {
            return this.hlls.isEmpty();
        }
    }
}

