/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ITableDeviceSchemaValidation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableDeviceSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateOrUpdateDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FetchDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.SqlParser;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDeviceSchemaValidator {
    private final SqlParser relationSqlParser = new SqlParser();
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDeviceSchemaValidator.class);
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Coordinator coordinator = Coordinator.getInstance();
    private final TableDeviceSchemaFetcher fetcher = TableDeviceSchemaFetcher.getInstance();

    private TableDeviceSchemaValidator() {
    }

    public static TableDeviceSchemaValidator getInstance() {
        return TableDeviceSchemaValidatorHolder.INSTANCE;
    }

    public void validateDeviceSchema(ITableDeviceSchemaValidation schemaValidation, MPPQueryContext context) {
        List<Object[]> deviceIdList = schemaValidation.getDeviceIdList();
        List<String> attributeKeyList = schemaValidation.getAttributeColumnNameList();
        List<Object[]> attributeValueList = schemaValidation.getAttributeValueList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Validating device schema {}.{} and other {} devices", new Object[]{schemaValidation.getTableName(), Arrays.toString(deviceIdList.get(0)), deviceIdList.size() - 1});
        }
        ValidateResult validateResult = this.validateDeviceSchemaInCache(schemaValidation, deviceIdList, attributeKeyList, attributeValueList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} devices are missing", (Object)validateResult.missingDeviceIndexList.size());
        }
        if (!validateResult.missingDeviceIndexList.isEmpty()) {
            validateResult = this.fetchAndValidateDeviceSchema(schemaValidation, validateResult, context, deviceIdList, attributeKeyList, attributeValueList);
        }
        if (!validateResult.missingDeviceIndexList.isEmpty() || !validateResult.attributeUpdateDeviceIndexList.isEmpty()) {
            this.autoCreateOrUpdateDeviceSchema(schemaValidation, validateResult, context, deviceIdList, attributeKeyList, attributeValueList);
        }
    }

    private ValidateResult validateDeviceSchemaInCache(ITableDeviceSchemaValidation schemaValidation, List<Object[]> deviceIdList, List<String> attributeKeyList, List<Object[]> attributeValueList) {
        ValidateResult result = new ValidateResult();
        int size = deviceIdList.size();
        block0: for (int i = 0; i < size; ++i) {
            Map<String, Binary> attributeMap = TableDeviceSchemaCache.getInstance().getDeviceAttribute(schemaValidation.getDatabase(), TableDeviceSchemaFetcher.convertTagValuesToDeviceID(schemaValidation.getTableName(), (String[])deviceIdList.get(i)));
            if (attributeMap == null) {
                result.missingDeviceIndexList.add(i);
                continue;
            }
            int attributeSize = attributeKeyList.size();
            for (int j = 0; j < attributeSize; ++j) {
                if (Objects.equals(attributeMap.get(attributeKeyList.get(j)), attributeValueList.get(i)[j])) continue;
                result.attributeUpdateDeviceIndexList.add(i);
                continue block0;
            }
        }
        return result;
    }

    private ValidateResult fetchAndValidateDeviceSchema(ITableDeviceSchemaValidation schemaValidation, ValidateResult previousValidateResult, MPPQueryContext context, List<Object[]> deviceIdList, List<String> attributeKeyList, List<Object[]> attributeValueList) {
        Map<IDeviceID, Map<String, Binary>> fetchedDeviceSchema = this.fetcher.fetchMissingDeviceSchemaForDataInsertion(new FetchDevice(schemaValidation.getDatabase(), schemaValidation.getTableName(), previousValidateResult.missingDeviceIndexList.stream().map(deviceIdList::get).collect(Collectors.toList())), context);
        ValidateResult result = new ValidateResult();
        for (int index : previousValidateResult.missingDeviceIndexList) {
            Map<String, Binary> attributeMap = fetchedDeviceSchema.get(TableDeviceSchemaFetcher.convertTagValuesToDeviceID(schemaValidation.getTableName(), (String[])deviceIdList.get(index)));
            if (attributeMap == null) {
                result.missingDeviceIndexList.add(index);
                continue;
            }
            this.constructAttributeUpdateDeviceIndexList(attributeKeyList, attributeValueList, result, index, attributeMap);
        }
        result.attributeUpdateDeviceIndexList.addAll(previousValidateResult.attributeUpdateDeviceIndexList);
        return result;
    }

    private void constructAttributeUpdateDeviceIndexList(List<String> attributeKeyList, List<Object[]> attributeValueList, ValidateResult result, int index, Map<String, Binary> attributeMap) {
        Object[] deviceAttributeValueList = attributeValueList.get(index);
        int size = attributeKeyList.size();
        for (int j = 0; j < size; ++j) {
            String key;
            Binary value;
            if (deviceAttributeValueList[j] == null || deviceAttributeValueList[j].equals(value = attributeMap.get(key = attributeKeyList.get(j)))) continue;
            result.attributeUpdateDeviceIndexList.add(index);
            break;
        }
    }

    private void autoCreateOrUpdateDeviceSchema(ITableDeviceSchemaValidation schemaValidation, ValidateResult previousValidateResult, MPPQueryContext context, List<Object[]> inputDeviceIdList, List<String> attributeKeyList, List<Object[]> intPutAttributeValueList) {
        int size = previousValidateResult.missingDeviceIndexList.size() + previousValidateResult.attributeUpdateDeviceIndexList.size();
        ArrayList<Object[]> deviceIdList = new ArrayList<Object[]>(size);
        ArrayList<Object[]> attributeValueList = new ArrayList<Object[]>(size);
        previousValidateResult.missingDeviceIndexList.forEach(index -> {
            deviceIdList.add((Object[])inputDeviceIdList.get((int)index));
            attributeValueList.add((Object[])intPutAttributeValueList.get((int)index));
        });
        previousValidateResult.attributeUpdateDeviceIndexList.forEach(index -> {
            deviceIdList.add((Object[])inputDeviceIdList.get((int)index));
            attributeValueList.add((Object[])intPutAttributeValueList.get((int)index));
        });
        ExecutionResult executionResult = this.coordinator.executeForTableModel(new CreateOrUpdateDevice(schemaValidation.getDatabase(), schemaValidation.getTableName(), deviceIdList, attributeKeyList, attributeValueList), this.relationSqlParser, SessionManager.getInstance().getCurrSession(), SessionManager.getInstance().requestQueryId(), SessionManager.getInstance().getSessionInfo(SessionManager.getInstance().getCurrSession()), "Create device or update device attribute for insert", LocalExecutionPlanner.getInstance().metadata, Long.MAX_VALUE, false);
        if (executionResult.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new RuntimeException(new IoTDBException(executionResult.status.getMessage(), executionResult.status.getCode()));
        }
    }

    private static class TableDeviceSchemaValidatorHolder {
        private static final TableDeviceSchemaValidator INSTANCE = new TableDeviceSchemaValidator();

        private TableDeviceSchemaValidatorHolder() {
        }
    }

    private static class ValidateResult {
        final List<Integer> missingDeviceIndexList = new ArrayList<Integer>();
        final List<Integer> attributeUpdateDeviceIndexList = new ArrayList<Integer>();

        private ValidateResult() {
        }
    }
}

