/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.runtime.SchemaExecutionException;
import org.apache.iotdb.commons.schema.table.column.TimeColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchemaUtil;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

@ThreadSafe
public class TsTable {
    public static final String TIME_COLUMN_NAME = "time";
    public static final String COMMENT_KEY = "__comment";
    private static final TimeColumnSchema TIME_COLUMN_SCHEMA = new TimeColumnSchema("time", TSDataType.TIMESTAMP);
    public static final String TTL_PROPERTY = "ttl";
    public static final Set<String> TABLE_ALLOWED_PROPERTIES = Collections.singleton("ttl");
    private final String tableName;
    private final Map<String, TsTableColumnSchema> columnSchemaMap = new LinkedHashMap<String, TsTableColumnSchema>();
    private final Map<String, Integer> idColumnIndexMap = new HashMap<String, Integer>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private Map<String, String> props = null;
    private transient long ttlValue = Long.MIN_VALUE;
    private transient int idNums = 0;
    private transient int measurementNum = 0;

    public TsTable(String tableName) {
        this.tableName = tableName;
        this.columnSchemaMap.put(TIME_COLUMN_NAME, TIME_COLUMN_SCHEMA);
    }

    public TsTable(String tableName, ImmutableList<TsTableColumnSchema> columnSchemas) {
        this.tableName = tableName;
        columnSchemas.forEach(columnSchema -> this.columnSchemaMap.put(columnSchema.getColumnName(), (TsTableColumnSchema)columnSchema));
    }

    public String getTableName() {
        return this.tableName;
    }

    public TsTableColumnSchema getColumnSchema(String columnName) {
        this.readWriteLock.readLock().lock();
        try {
            TsTableColumnSchema tsTableColumnSchema = this.columnSchemaMap.get(columnName);
            return tsTableColumnSchema;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public int getIdColumnOrdinal(String columnName) {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.idColumnIndexMap.getOrDefault(columnName.toLowerCase(), -1);
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TsTableColumnSchema> getIdColumnSchemaList() {
        this.readWriteLock.readLock().lock();
        try {
            ArrayList<TsTableColumnSchema> idColumnSchemaList = new ArrayList<TsTableColumnSchema>();
            for (TsTableColumnSchema columnSchema : this.columnSchemaMap.values()) {
                if (!TsTableColumnCategory.TAG.equals((Object)columnSchema.getColumnCategory())) continue;
                idColumnSchemaList.add(columnSchema);
            }
            ArrayList<TsTableColumnSchema> arrayList = idColumnSchemaList;
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void addColumnSchema(TsTableColumnSchema columnSchema) {
        this.readWriteLock.writeLock().lock();
        try {
            this.columnSchemaMap.put(columnSchema.getColumnName(), columnSchema);
            if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TAG)) {
                ++this.idNums;
                this.idColumnIndexMap.put(columnSchema.getColumnName(), this.idNums - 1);
            } else if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.FIELD)) {
                ++this.measurementNum;
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void renameColumnSchema(String oldName, String newName) {
        this.readWriteLock.writeLock().lock();
        try {
            if (this.columnSchemaMap.containsKey(oldName)) {
                this.columnSchemaMap.put(newName, this.columnSchemaMap.remove(oldName));
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void removeColumnSchema(String columnName) {
        this.readWriteLock.writeLock().lock();
        try {
            TsTableColumnSchema columnSchema = this.columnSchemaMap.get(columnName);
            if (columnSchema != null && columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TAG)) {
                throw new SchemaExecutionException("Cannot remove an id column: " + columnName);
            }
            if (columnSchema != null) {
                this.columnSchemaMap.remove(columnName);
                if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.FIELD)) {
                    --this.measurementNum;
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public int getColumnNum() {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.columnSchemaMap.size();
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public int getIdNums() {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.idNums;
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public int getMeasurementNum() {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.measurementNum;
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public List<TsTableColumnSchema> getColumnList() {
        this.readWriteLock.readLock().lock();
        try {
            ArrayList<TsTableColumnSchema> arrayList = new ArrayList<TsTableColumnSchema>(this.columnSchemaMap.values());
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public long getCachedTableTTL() {
        if (this.ttlValue < 0L) {
            this.ttlValue = this.getTableTTL();
        }
        return this.ttlValue;
    }

    public long getTableTTL() {
        Optional<String> ttl = this.getPropValue(TTL_PROPERTY);
        return ttl.isPresent() && !ttl.get().equalsIgnoreCase("INF") ? CommonDateTimeUtils.convertMilliTimeWithPrecision(Long.parseLong(ttl.get()), CommonDescriptor.getInstance().getConfig().getTimestampPrecision()) : Long.MAX_VALUE;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public Optional<String> getPropValue(String propKey) {
        this.readWriteLock.readLock().lock();
        try {
            Optional<String> optional = this.props != null && this.props.containsKey(propKey) ? Optional.of(this.props.get(propKey)) : Optional.empty();
            return optional;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void addProp(String key, String value) {
        this.readWriteLock.writeLock().lock();
        try {
            if (this.props == null) {
                this.props = new HashMap<String, String>();
            }
            this.props.put(key, value);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void removeProp(String key) {
        this.readWriteLock.writeLock().lock();
        try {
            if (this.props == null) {
                return;
            }
            this.props.remove(key);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public byte[] serialize() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.serialize(stream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stream.toByteArray();
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.tableName, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.columnSchemaMap.size(), (OutputStream)stream);
        for (TsTableColumnSchema columnSchema : this.columnSchemaMap.values()) {
            TsTableColumnSchemaUtil.serialize(columnSchema, stream);
        }
        ReadWriteIOUtils.write(this.props, (OutputStream)stream);
    }

    public static TsTable deserialize(InputStream inputStream) throws IOException {
        String name = ReadWriteIOUtils.readString((InputStream)inputStream);
        TsTable table = new TsTable(name);
        int columnNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < columnNum; ++i) {
            table.addColumnSchema(TsTableColumnSchemaUtil.deserialize(inputStream));
        }
        table.props = ReadWriteIOUtils.readMap((InputStream)inputStream);
        return table;
    }

    public static TsTable deserialize(ByteBuffer buffer) {
        String name = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        TsTable table = new TsTable(name);
        int columnNum = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        for (int i = 0; i < columnNum; ++i) {
            table.addColumnSchema(TsTableColumnSchemaUtil.deserialize(buffer));
        }
        table.props = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        return table;
    }

    public void setProps(Map<String, String> props) {
        this.readWriteLock.writeLock().lock();
        try {
            this.props = props;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.tableName);
    }

    public String toString() {
        return "TsTable{tableName='" + this.tableName + '\'' + ", columnSchemaMap=" + this.columnSchemaMap + ", props=" + this.props + '}';
    }
}

