/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.grpc.metrics.ZeroCopyMetrics;
import org.apache.ratis.grpc.util.ZeroCopyMessageMarshaller;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.RaftServerProtocolServiceGrpc;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.RaftServerProtocol;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.thirdparty.io.grpc.ServerServiceDefinition;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.BatchLogger;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReferenceCountedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcServerProtocolService
extends RaftServerProtocolServiceGrpc.RaftServerProtocolServiceImplBase {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcServerProtocolService.class);
    private final Supplier<RaftPeerId> idSupplier;
    private final RaftServer server;
    private final boolean zeroCopyEnabled;
    private final ZeroCopyMessageMarshaller<RaftProtos.AppendEntriesRequestProto> zeroCopyRequestMarshaller;

    GrpcServerProtocolService(Supplier<RaftPeerId> idSupplier, RaftServer server, boolean zeroCopyEnabled, ZeroCopyMetrics zeroCopyMetrics) {
        this.idSupplier = idSupplier;
        this.server = server;
        this.zeroCopyEnabled = zeroCopyEnabled;
        this.zeroCopyRequestMarshaller = new ZeroCopyMessageMarshaller<RaftProtos.AppendEntriesRequestProto>(RaftProtos.AppendEntriesRequestProto.getDefaultInstance(), zeroCopyMetrics::onZeroCopyMessage, zeroCopyMetrics::onNonZeroCopyMessage, zeroCopyMetrics::onReleasedMessage);
        zeroCopyMetrics.addUnreleased("server_protocol", this.zeroCopyRequestMarshaller::getUnclosedCount);
    }

    RaftPeerId getId() {
        return this.idSupplier.get();
    }

    ServerServiceDefinition bindServiceWithZeroCopy() {
        ServerServiceDefinition orig = super.bindService();
        if (!this.zeroCopyEnabled) {
            LOG.info("{}: Zero copy is disabled.", (Object)this.getId());
            return orig;
        }
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((String)orig.getServiceDescriptor().getName());
        GrpcUtil.addMethodWithCustomMarshaller(orig, builder, RaftServerProtocolServiceGrpc.getAppendEntriesMethod(), this.zeroCopyRequestMarshaller);
        orig.getMethods().stream().filter(x -> !x.getMethodDescriptor().getFullMethodName().equals(RaftServerProtocolServiceGrpc.getAppendEntriesMethod().getFullMethodName())).forEach(arg_0 -> ((ServerServiceDefinition.Builder)builder).addMethod(arg_0));
        return builder.build();
    }

    public void requestVote(RaftProtos.RequestVoteRequestProto request, StreamObserver<RaftProtos.RequestVoteReplyProto> responseObserver) {
        try {
            RaftProtos.RequestVoteReplyProto reply = this.server.requestVote(request);
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            GrpcUtil.warn(LOG, () -> this.getId() + ": Failed requestVote " + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()), e);
            responseObserver.onError((Throwable)GrpcUtil.wrapException(e));
        }
    }

    public void startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request, StreamObserver<RaftProtos.StartLeaderElectionReplyProto> responseObserver) {
        try {
            RaftProtos.StartLeaderElectionReplyProto reply = this.server.startLeaderElection(request);
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable e) {
            GrpcUtil.warn(LOG, () -> this.getId() + ": Failed startLeaderElection " + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()), e);
            responseObserver.onError((Throwable)GrpcUtil.wrapException(e));
        }
    }

    public void readIndex(RaftProtos.ReadIndexRequestProto request, StreamObserver<RaftProtos.ReadIndexReplyProto> responseObserver) {
        Consumer<Throwable> warning = e -> GrpcUtil.warn(LOG, () -> this.getId() + ": Failed readIndex " + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()), e);
        GrpcUtil.asyncCall(responseObserver, () -> this.server.readIndexAsync(request), Function.identity(), warning);
    }

    public StreamObserver<RaftProtos.AppendEntriesRequestProto> appendEntries(StreamObserver<RaftProtos.AppendEntriesReplyProto> responseObserver) {
        return new ServerRequestStreamObserver<RaftProtos.AppendEntriesRequestProto, RaftProtos.AppendEntriesReplyProto>(RaftServerProtocol.Op.APPEND_ENTRIES, responseObserver){

            @Override
            CompletableFuture<RaftProtos.AppendEntriesReplyProto> process(ReferenceCountedObject<RaftProtos.AppendEntriesRequestProto> requestRef) throws IOException {
                return GrpcServerProtocolService.this.server.appendEntriesAsync(requestRef);
            }

            @Override
            void release(RaftProtos.AppendEntriesRequestProto req) {
                GrpcServerProtocolService.this.zeroCopyRequestMarshaller.release(req);
            }

            @Override
            long getCallId(RaftProtos.AppendEntriesRequestProto request) {
                return request.getServerRequest().getCallId();
            }

            @Override
            boolean isHeartbeat(RaftProtos.AppendEntriesRequestProto request) {
                return request.getEntriesCount() == 0;
            }

            @Override
            String requestToString(RaftProtos.AppendEntriesRequestProto request) {
                return ServerStringUtils.toAppendEntriesRequestString((RaftProtos.AppendEntriesRequestProto)request, null);
            }

            @Override
            String replyToString(RaftProtos.AppendEntriesReplyProto reply) {
                return ServerStringUtils.toAppendEntriesReplyString((RaftProtos.AppendEntriesReplyProto)reply);
            }

            @Override
            boolean replyInOrder(RaftProtos.AppendEntriesRequestProto request) {
                return request.getEntriesCount() != 0;
            }
        };
    }

    public StreamObserver<RaftProtos.InstallSnapshotRequestProto> installSnapshot(StreamObserver<RaftProtos.InstallSnapshotReplyProto> responseObserver) {
        return new ServerRequestStreamObserver<RaftProtos.InstallSnapshotRequestProto, RaftProtos.InstallSnapshotReplyProto>(RaftServerProtocol.Op.INSTALL_SNAPSHOT, responseObserver){

            @Override
            CompletableFuture<RaftProtos.InstallSnapshotReplyProto> process(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
                return CompletableFuture.completedFuture(GrpcServerProtocolService.this.server.installSnapshot(request));
            }

            @Override
            long getCallId(RaftProtos.InstallSnapshotRequestProto request) {
                return request.getServerRequest().getCallId();
            }

            @Override
            String requestToString(RaftProtos.InstallSnapshotRequestProto request) {
                return ServerStringUtils.toInstallSnapshotRequestString((RaftProtos.InstallSnapshotRequestProto)request);
            }

            @Override
            String replyToString(RaftProtos.InstallSnapshotReplyProto reply) {
                return ServerStringUtils.toInstallSnapshotReplyString((RaftProtos.InstallSnapshotReplyProto)reply);
            }

            @Override
            boolean replyInOrder(RaftProtos.InstallSnapshotRequestProto installSnapshotRequestProto) {
                return true;
            }
        };
    }

    abstract class ServerRequestStreamObserver<REQUEST, REPLY>
    implements StreamObserver<REQUEST> {
        private final RaftServerProtocol.Op op;
        private final Supplier<String> nameSupplier;
        private final StreamObserver<REPLY> responseObserver;
        private final AtomicReference<PendingServerRequest<REQUEST>> previousOnNext = new AtomicReference();
        private final AtomicReference<CompletableFuture<REPLY>> requestFuture = new AtomicReference<CompletableFuture<Object>>(CompletableFuture.completedFuture(null));
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        ServerRequestStreamObserver(RaftServerProtocol.Op op, StreamObserver<REPLY> responseObserver) {
            this.op = op;
            this.nameSupplier = MemoizedSupplier.valueOf(() -> GrpcServerProtocolService.this.getId() + "_" + op);
            this.responseObserver = responseObserver;
        }

        String getName() {
            return this.nameSupplier.get();
        }

        private String getPreviousRequestString() {
            return Optional.ofNullable(this.previousOnNext.get()).map(PendingServerRequest::getRequest).map(this::requestToString).orElse(null);
        }

        CompletableFuture<REPLY> process(REQUEST request) throws IOException {
            throw new UnsupportedOperationException("This method is not supported.");
        }

        CompletableFuture<REPLY> process(ReferenceCountedObject<REQUEST> requestRef) throws IOException {
            try {
                CompletableFuture<REPLY> completableFuture = this.process(requestRef.retain());
                return completableFuture;
            }
            finally {
                requestRef.release();
            }
        }

        void release(REQUEST req) {
        }

        abstract long getCallId(REQUEST var1);

        boolean isHeartbeat(REQUEST request) {
            return false;
        }

        abstract String requestToString(REQUEST var1);

        abstract String replyToString(REPLY var1);

        abstract boolean replyInOrder(REQUEST var1);

        private synchronized void handleError(Throwable e, long callId, boolean isHeartbeat) {
            GrpcUtil.warn(LOG, () -> GrpcServerProtocolService.this.getId() + ": Failed " + this.op + " request cid=" + callId + ", isHeartbeat? " + isHeartbeat, e);
            if (this.isClosed.compareAndSet(false, true)) {
                this.responseObserver.onError((Throwable)GrpcUtil.wrapException(e, callId, isHeartbeat));
            }
        }

        private synchronized REPLY handleReply(REPLY reply) {
            if (!this.isClosed.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: reply {}", (Object)GrpcServerProtocolService.this.getId(), (Object)this.replyToString(reply));
                }
                this.responseObserver.onNext(reply);
            }
            return reply;
        }

        void composeRequest(CompletableFuture<REPLY> current) {
            this.requestFuture.updateAndGet(previous -> previous.thenCompose(reply -> current));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(REQUEST request) {
            ReferenceCountedObject requestRef = ReferenceCountedObject.wrap(request, () -> {}, released -> {
                if (released.booleanValue()) {
                    this.release(request);
                }
            });
            if (!this.replyInOrder(request)) {
                try {
                    this.composeRequest((CompletableFuture<REPLY>)this.process(requestRef).thenApply(this::handleReply));
                }
                catch (Exception e2) {
                    this.handleError(e2, this.getCallId(request), this.isHeartbeat(request));
                    this.release(request);
                }
                return;
            }
            PendingServerRequest current = new PendingServerRequest(requestRef);
            long callId = this.getCallId(current.getRequest());
            boolean isHeartbeat = this.isHeartbeat(current.getRequest());
            Optional previous = Optional.ofNullable(this.previousOnNext.getAndSet(current));
            CompletableFuture<Object> previousFuture = previous.map(PendingServerRequest::getFuture).orElse(CompletableFuture.completedFuture(null));
            try {
                CompletionStage f = ((CompletableFuture)this.process(requestRef).exceptionally(e -> {
                    this.handleError((Throwable)e, callId, isHeartbeat);
                    current.getFuture().completeExceptionally((Throwable)e);
                    return null;
                })).thenCombine(previousFuture, (reply, v) -> {
                    this.handleReply(reply);
                    current.getFuture().complete(null);
                    return null;
                });
                this.composeRequest((CompletableFuture<REPLY>)f);
            }
            catch (Exception e3) {
                this.handleError(e3, callId, isHeartbeat);
                current.getFuture().completeExceptionally(e3);
            }
            finally {
                previous.ifPresent(PendingServerRequest::release);
                if (this.isClosed.get()) {
                    this.releaseLast();
                }
            }
        }

        public void onCompleted() {
            if (this.isClosed.compareAndSet(false, true)) {
                BatchLogger.print((BatchLogger.Key)BatchLogKey.COMPLETED_REQUEST, (Object)this.getName(), suffix -> LOG.info("{}: Completed {}, lastRequest: {} {}", new Object[]{GrpcServerProtocolService.this.getId(), this.op, this.getPreviousRequestString(), suffix}));
                this.requestFuture.get().thenAccept(reply -> {
                    BatchLogger.print((BatchLogger.Key)BatchLogKey.COMPLETED_REPLY, (Object)this.getName(), suffix -> LOG.info("{}: Completed {}, lastReply: {} {}", new Object[]{GrpcServerProtocolService.this.getId(), this.op, reply, suffix}));
                    this.responseObserver.onCompleted();
                });
                this.releaseLast();
            }
        }

        public void onError(Throwable t) {
            GrpcUtil.warn(LOG, () -> GrpcServerProtocolService.this.getId() + ": " + this.op + " onError, lastRequest: " + this.getPreviousRequestString(), t);
            if (this.isClosed.compareAndSet(false, true)) {
                Status status = Status.fromThrowable((Throwable)t);
                if (status != null && status.getCode() != Status.Code.CANCELLED) {
                    this.responseObserver.onCompleted();
                }
                this.releaseLast();
            }
        }

        private void releaseLast() {
            Optional.ofNullable(this.previousOnNext.get()).ifPresent(PendingServerRequest::release);
        }
    }

    static class PendingServerRequest<REQUEST> {
        private final AtomicReference<ReferenceCountedObject<REQUEST>> requestRef;
        private final CompletableFuture<Void> future = new CompletableFuture();

        PendingServerRequest(ReferenceCountedObject<REQUEST> requestRef) {
            requestRef.retain();
            this.requestRef = new AtomicReference<ReferenceCountedObject<REQUEST>>(requestRef);
        }

        REQUEST getRequest() {
            return Optional.ofNullable(this.requestRef.get()).map(ReferenceCountedObject::get).orElse(null);
        }

        CompletableFuture<Void> getFuture() {
            return this.future;
        }

        void release() {
            Optional.ofNullable(this.requestRef.getAndSet(null)).ifPresent(ReferenceCountedObject::release);
        }
    }

    private static enum BatchLogKey implements BatchLogger.Key
    {
        COMPLETED_REQUEST,
        COMPLETED_REPLY;

    }
}

