/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public final class RenameColumn
extends Statement {
    private final QualifiedName table;
    private final Identifier source;
    private final Identifier target;
    private final boolean tableIfExists;
    private final boolean columnIfNotExists;

    public RenameColumn(NodeLocation location, QualifiedName table, Identifier source, Identifier target, boolean tableIfExists, boolean columnIfNotExists) {
        super(Objects.requireNonNull(location, "location is null"));
        this.table = Objects.requireNonNull(table, "table is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.tableIfExists = tableIfExists;
        this.columnIfNotExists = columnIfNotExists;
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public Identifier getSource() {
        return this.source;
    }

    public Identifier getTarget() {
        return this.target;
    }

    public boolean tableIfExists() {
        return this.tableIfExists;
    }

    public boolean columnIfExists() {
        return this.columnIfNotExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRenameColumn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenameColumn that = (RenameColumn)o;
        return this.tableIfExists == that.tableIfExists && this.columnIfNotExists == that.columnIfNotExists && Objects.equals(this.table, that.table) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.source, this.target);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("source", (Object)this.source).add("target", (Object)this.target).add("tableIfExists", this.tableIfExists).add("columnIfExists", this.columnIfNotExists).toString();
    }
}

