/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.load;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.LoadAnalyzeException;
import org.apache.iotdb.db.exception.load.LoadAnalyzeTypeMismatchException;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.exception.load.LoadRuntimeOutOfMemoryException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.load.LoadTsFileAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.load.LoadTsFileTreeSchemaCache;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.SchemaValidator;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDatabaseStatement;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.constant.SqlConstant;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeSchemaAutoCreatorAndVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeSchemaAutoCreatorAndVerifier.class);
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();
    private final LoadTsFileAnalyzer loadTsFileAnalyzer;
    private final LoadTsFileTreeSchemaCache schemaCache;

    TreeSchemaAutoCreatorAndVerifier(LoadTsFileAnalyzer loadTsFileAnalyzer) throws LoadRuntimeOutOfMemoryException {
        this.loadTsFileAnalyzer = loadTsFileAnalyzer;
        this.schemaCache = new LoadTsFileTreeSchemaCache();
    }

    public void setCurrentModificationsAndTimeIndex(TsFileResource resource, TsFileSequenceReader reader) throws IOException {
        this.schemaCache.setCurrentModificationsAndTimeIndex(resource, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoCreateAndVerify(TsFileSequenceReader reader, Map<IDeviceID, List<TimeseriesMetadata>> device2TimeseriesMetadataList) throws IOException, AuthException, LoadAnalyzeTypeMismatchException {
        for (Map.Entry<IDeviceID, List<TimeseriesMetadata>> entry : device2TimeseriesMetadataList.entrySet()) {
            IDeviceID device = entry.getKey();
            try {
                if (this.schemaCache.isDeviceDeletedByMods(device)) {
                    continue;
                }
            }
            catch (IllegalPathException e) {
                LOGGER.warn("Failed to check if device {} is deleted by mods. Will see it as not deleted.", (Object)device, (Object)e);
            }
            for (TimeseriesMetadata timeseriesMetadata : entry.getValue()) {
                TSDataType dataType;
                block17: {
                    try {
                        if (this.schemaCache.isTimeseriesDeletedByMods(device, timeseriesMetadata)) {
                            continue;
                        }
                    }
                    catch (IllegalPathException e) {
                        if (timeseriesMetadata.getMeasurementId().isEmpty()) break block17;
                        LOGGER.warn("Failed to check if device {}, timeseries {} is deleted by mods. Will see it as not deleted.", new Object[]{device, timeseriesMetadata.getMeasurementId(), e});
                    }
                }
                if (TSDataType.VECTOR.equals((Object)(dataType = timeseriesMetadata.getTsDataType()))) {
                    this.schemaCache.clearDeviceIsAlignedCacheIfNecessary();
                    this.schemaCache.addIsAlignedCache(device, true, false);
                } else {
                    block18: {
                        long startTime = System.nanoTime();
                        try {
                            TSStatus status;
                            String userName = this.loadTsFileAnalyzer.context.getSession().getUserName();
                            if (AuthorityChecker.SUPER_USER.equals(userName)) break block18;
                            try {
                                List<MeasurementPath> paths = Collections.singletonList(new MeasurementPath(device, timeseriesMetadata.getMeasurementId()));
                                status = AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathListPermission(userName, paths, PrivilegeType.WRITE_DATA), paths, PrivilegeType.WRITE_DATA);
                            }
                            catch (IllegalPathException e) {
                                throw new RuntimeException(e);
                            }
                            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                                throw new AuthException(TSStatusCode.representOf((int)status.getCode()), status.getMessage());
                            }
                        }
                        finally {
                            PerformanceOverviewMetrics.getInstance().recordAuthCost(System.nanoTime() - startTime);
                        }
                    }
                    Pair compressionEncodingPair = reader.readTimeseriesCompressionTypeAndEncoding(timeseriesMetadata);
                    this.schemaCache.addTimeSeries(device, new MeasurementSchema(timeseriesMetadata.getMeasurementId(), dataType, (TSEncoding)compressionEncodingPair.getRight(), (CompressionType)compressionEncodingPair.getLeft()));
                    this.schemaCache.addIsAlignedCache(device, false, true);
                    if (!this.schemaCache.getDeviceIsAligned(device)) {
                        this.schemaCache.clearDeviceIsAlignedCacheIfNecessary();
                    }
                }
                if (!this.schemaCache.shouldFlushTimeSeries()) continue;
                this.flush();
            }
        }
    }

    public void flushAndClearDeviceIsAlignedCacheIfNecessary() throws SemanticException {
        this.schemaCache.clearDeviceIsAlignedCacheIfNecessary();
    }

    public void flush() throws AuthException, LoadAnalyzeTypeMismatchException {
        this.doAutoCreateAndVerify();
        this.schemaCache.clearTimeSeries();
    }

    private void doAutoCreateAndVerify() throws SemanticException, AuthException, LoadAnalyzeTypeMismatchException {
        if (this.schemaCache.getDevice2TimeSeries().isEmpty()) {
            return;
        }
        try {
            if (this.loadTsFileAnalyzer.isVerifySchema()) {
                this.makeSureNoDuplicatedMeasurementsInDevices();
            }
            if (this.loadTsFileAnalyzer.isAutoCreateDatabase()) {
                this.autoCreateDatabase();
            }
            ISchemaTree schemaTree = this.autoCreateSchema();
            if (this.loadTsFileAnalyzer.isVerifySchema()) {
                this.verifySchema(schemaTree);
            }
        }
        catch (AuthException e) {
            throw e;
        }
        catch (LoadAnalyzeTypeMismatchException e) {
            if (this.loadTsFileAnalyzer.isConvertOnTypeMismatch()) {
                throw e;
            }
            this.handleException((Exception)((Object)e), this.loadTsFileAnalyzer.getStatementString());
        }
        catch (Exception e) {
            this.handleException(e, this.loadTsFileAnalyzer.getStatementString());
        }
    }

    private void handleException(Exception e, String statementString) throws SemanticException {
        LOGGER.warn("Auto create or verify schema error.", (Throwable)e);
        throw new SemanticException(String.format("Auto create or verify schema error when executing statement %s.  Detail: %s.", statementString, e.getMessage()));
    }

    private void makeSureNoDuplicatedMeasurementsInDevices() throws LoadAnalyzeException {
        for (Map.Entry<IDeviceID, Set<MeasurementSchema>> entry : this.schemaCache.getDevice2TimeSeries().entrySet()) {
            IDeviceID device = entry.getKey();
            HashMap<String, MeasurementSchema> measurement2Schema = new HashMap<String, MeasurementSchema>();
            for (MeasurementSchema timeseriesSchema : entry.getValue()) {
                String measurement = timeseriesSchema.getMeasurementName();
                if (measurement2Schema.containsKey(measurement)) {
                    throw new LoadAnalyzeException(String.format("Duplicated measurements %s in device %s.", measurement, device));
                }
                measurement2Schema.put(measurement, timeseriesSchema);
            }
        }
    }

    private void autoCreateDatabase() throws LoadAnalyzeException, LoadFileException, IllegalPathException, AuthException {
        int databasePrefixNodesLength = this.loadTsFileAnalyzer.getDatabaseLevel() + 1;
        HashSet<PartialPath> databasesNeededToBeSet = new HashSet<PartialPath>();
        for (IDeviceID device : this.schemaCache.getDevice2TimeSeries().keySet()) {
            PartialPath devicePath = new PartialPath(device);
            String[] devicePrefixNodes = devicePath.getNodes();
            if (devicePrefixNodes.length < databasePrefixNodesLength) {
                throw new LoadAnalyzeException(String.format("Database level %d is longer than device %s.", databasePrefixNodesLength, device));
            }
            String[] databasePrefixNodes = new String[databasePrefixNodesLength];
            System.arraycopy(devicePrefixNodes, 0, databasePrefixNodes, 0, databasePrefixNodesLength);
            databasesNeededToBeSet.add(new PartialPath(databasePrefixNodes));
        }
        if (this.schemaCache.getAlreadySetDatabases().isEmpty()) {
            try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                TGetDatabaseReq req = new TGetDatabaseReq(Arrays.asList(new ShowDatabaseStatement(new PartialPath(SqlConstant.getSingleRootArray())).getPathPattern().getNodes()), SchemaConstant.ALL_MATCH_SCOPE.serialize());
                TShowDatabaseResp resp = configNodeClient.showDatabase(req);
                for (String databaseName : resp.getDatabaseInfoMap().keySet()) {
                    this.schemaCache.addAlreadySetDatabase(new PartialPath(databaseName));
                }
            }
            catch (IOException | ClientManagerException | TException e) {
                throw new LoadFileException((Exception)e);
            }
        }
        databasesNeededToBeSet.removeAll(this.schemaCache.getAlreadySetDatabases());
        for (PartialPath databasePath : databasesNeededToBeSet) {
            DatabaseSchemaStatement statement = new DatabaseSchemaStatement(DatabaseSchemaStatement.DatabaseSchemaStatementType.CREATE);
            statement.setDatabasePath(databasePath);
            statement.setEnablePrintExceptionLog(false);
            this.executeSetDatabaseStatement(statement);
            this.schemaCache.addAlreadySetDatabase(databasePath);
        }
    }

    private void executeSetDatabaseStatement(Statement statement) throws LoadFileException, AuthException {
        TSStatus status = AuthorityChecker.checkAuthority(statement, this.loadTsFileAnalyzer.context.getSession().getUserName());
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new AuthException(TSStatusCode.representOf((int)status.getCode()), status.getMessage());
        }
        long queryId = SessionManager.getInstance().requestQueryId();
        ExecutionResult result = Coordinator.getInstance().executeForTreeModel(statement, queryId, null, "", this.loadTsFileAnalyzer.partitionFetcher, this.loadTsFileAnalyzer.schemaFetcher, IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold(), false);
        if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode() && result.status.code != TSStatusCode.DATABASE_CONFLICT.getStatusCode()) {
            LOGGER.warn("Create database error, statement: {}, result status is: {}", (Object)statement, (Object)result.status);
            throw new LoadFileException(String.format("Create database error, statement: %s, result status is: %s", statement, result.status));
        }
    }

    private ISchemaTree autoCreateSchema() throws IllegalPathException {
        ArrayList<PartialPath> deviceList = new ArrayList<PartialPath>();
        ArrayList<String[]> measurementList = new ArrayList<String[]>();
        ArrayList<TSDataType[]> dataTypeList = new ArrayList<TSDataType[]>();
        ArrayList<TSEncoding[]> encodingsList = new ArrayList<TSEncoding[]>();
        ArrayList<CompressionType[]> compressionTypesList = new ArrayList<CompressionType[]>();
        ArrayList<Boolean> isAlignedList = new ArrayList<Boolean>();
        for (Map.Entry<IDeviceID, Set<MeasurementSchema>> entry : this.schemaCache.getDevice2TimeSeries().entrySet()) {
            int measurementSize = entry.getValue().size();
            String[] measurements = new String[measurementSize];
            TSDataType[] tsDataTypes = new TSDataType[measurementSize];
            TSEncoding[] encodings = new TSEncoding[measurementSize];
            CompressionType[] compressionTypes = new CompressionType[measurementSize];
            int index = 0;
            for (MeasurementSchema measurementSchema : entry.getValue()) {
                measurements[index] = measurementSchema.getMeasurementName();
                tsDataTypes[index] = measurementSchema.getType();
                encodings[index] = measurementSchema.getEncodingType();
                compressionTypes[index++] = measurementSchema.getCompressor();
            }
            deviceList.add(new PartialPath(entry.getKey()));
            measurementList.add(measurements);
            dataTypeList.add(tsDataTypes);
            encodingsList.add(encodings);
            compressionTypesList.add(compressionTypes);
            isAlignedList.add(this.schemaCache.getDeviceIsAligned(entry.getKey()));
        }
        return SchemaValidator.validate(this.loadTsFileAnalyzer.schemaFetcher, deviceList, measurementList, dataTypeList, encodingsList, compressionTypesList, isAlignedList, this.loadTsFileAnalyzer.context);
    }

    private void verifySchema(ISchemaTree schemaTree) throws LoadAnalyzeException, IllegalPathException {
        for (Map.Entry<IDeviceID, Set<MeasurementSchema>> entry : this.schemaCache.getDevice2TimeSeries().entrySet()) {
            boolean isAlignedInIoTDB;
            ArrayList tsfileTimeseriesSchemas;
            IDeviceID device = entry.getKey();
            DeviceSchemaInfo iotdbDeviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(new PartialPath(device), (tsfileTimeseriesSchemas = new ArrayList(entry.getValue())).stream().map(IMeasurementSchema::getMeasurementName).collect(Collectors.toList()));
            if (iotdbDeviceSchemaInfo == null) {
                throw new LoadAnalyzeException(String.format("Device %s does not exist in IoTDB and can not be created. Please check weather auto-create-schema is enabled.", device));
            }
            boolean isAlignedInTsFile = this.schemaCache.getDeviceIsAligned(device);
            if (isAlignedInTsFile != (isAlignedInIoTDB = iotdbDeviceSchemaInfo.isAligned())) {
                throw new LoadAnalyzeException(String.format("Device %s in TsFile is %s, but in IoTDB is %s.", device, isAlignedInTsFile ? "aligned" : "not aligned", isAlignedInIoTDB ? "aligned" : "not aligned"));
            }
            List<IMeasurementSchema> iotdbTimeseriesSchemas = iotdbDeviceSchemaInfo.getMeasurementSchemaList();
            int n = iotdbTimeseriesSchemas.size();
            for (int i = 0; i < n; ++i) {
                IMeasurementSchema tsFileSchema = (IMeasurementSchema)tsfileTimeseriesSchemas.get(i);
                IMeasurementSchema iotdbSchema = iotdbTimeseriesSchemas.get(i);
                if (iotdbSchema == null) {
                    throw new LoadAnalyzeException(String.format("Measurement %s does not exist in IoTDB and can not be created. Please check weather auto-create-schema is enabled.", device + "." + tsfileTimeseriesSchemas.get(i)));
                }
                if (!tsFileSchema.getType().equals((Object)iotdbSchema.getType())) {
                    throw new LoadAnalyzeTypeMismatchException(String.format("Measurement %s%s%s datatype not match, TsFile: %s, IoTDB: %s", device, ".", iotdbSchema.getMeasurementName(), tsFileSchema.getType(), iotdbSchema.getType()));
                }
                if (LOGGER.isDebugEnabled() && !tsFileSchema.getEncodingType().equals((Object)iotdbSchema.getEncodingType())) {
                    LOGGER.debug("Encoding type not match, measurement: {}{}{}, TsFile encoding: {}, IoTDB encoding: {}", new Object[]{device, ".", iotdbSchema.getMeasurementName(), tsFileSchema.getEncodingType().name(), iotdbSchema.getEncodingType().name()});
                }
                if (!LOGGER.isDebugEnabled() || tsFileSchema.getCompressor().equals((Object)iotdbSchema.getCompressor())) continue;
                LOGGER.debug("Compressor not match, measurement: {}{}{}, TsFile compressor: {}, IoTDB compressor: {}", new Object[]{device, ".", iotdbSchema.getMeasurementName(), tsFileSchema.getCompressor().name(), iotdbSchema.getCompressor().name()});
            }
        }
    }

    public void close() {
        this.schemaCache.close();
    }
}

