/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.consensus;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.RecoverProgressIndex;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;
import org.apache.iotdb.consensus.pipe.consensuspipe.ReplicateProgressManager;
import org.apache.iotdb.consensus.pipe.metric.PipeConsensusSyncLagManager;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class ReplicateProgressDataNodeManager
implements ReplicateProgressManager {
    private static final int DATA_NODE_ID = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
    private static final Map<String, AtomicLong> groupId2ReplicateIndex = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<ConsensusGroupId, ProgressIndex> groupId2MaxProgressIndex = new ConcurrentHashMap<ConsensusGroupId, ProgressIndex>();
    private final Map<ConsensusPipeName, Long> consensusPipe2pinnedCommitIndexForMigration = new ConcurrentHashMap<ConsensusPipeName, Long>();

    public ReplicateProgressDataNodeManager() {
        this.recoverMaxProgressIndexFromDataRegion();
    }

    public static long assignReplicateIndexForIoTV2(String groupId) {
        return groupId2ReplicateIndex.compute(groupId, (k, v) -> v == null ? new AtomicLong(0L) : v).incrementAndGet();
    }

    public static ProgressIndex extractLocalSimpleProgressIndex(ProgressIndex progressIndex) {
        if (progressIndex instanceof RecoverProgressIndex) {
            Map dataNodeId2LocalIndex = ((RecoverProgressIndex)progressIndex).getDataNodeId2LocalIndex();
            return dataNodeId2LocalIndex.containsKey(DATA_NODE_ID) ? (ProgressIndex)dataNodeId2LocalIndex.get(DATA_NODE_ID) : MinimumProgressIndex.INSTANCE;
        }
        if (progressIndex instanceof HybridProgressIndex) {
            Map type2Index = ((HybridProgressIndex)progressIndex).getType2Index();
            if (!type2Index.containsKey(ProgressIndexType.RECOVER_PROGRESS_INDEX.getType())) {
                return MinimumProgressIndex.INSTANCE;
            }
            Map dataNodeId2LocalIndex = ((RecoverProgressIndex)type2Index.get(ProgressIndexType.RECOVER_PROGRESS_INDEX.getType())).getDataNodeId2LocalIndex();
            return dataNodeId2LocalIndex.containsKey(DATA_NODE_ID) ? (ProgressIndex)dataNodeId2LocalIndex.get(DATA_NODE_ID) : MinimumProgressIndex.INSTANCE;
        }
        return MinimumProgressIndex.INSTANCE;
    }

    private void recoverMaxProgressIndexFromDataRegion() {
        StorageEngine.getInstance().getAllDataRegionIds().forEach(dataRegionId -> {
            TsFileManager tsFileManager = StorageEngine.getInstance().getDataRegion((DataRegionId)dataRegionId).getTsFileManager();
            ArrayList allProgressIndex = new ArrayList();
            allProgressIndex.addAll(tsFileManager.getTsFileList(true).stream().map(TsFileResource::getMaxProgressIndex).collect(Collectors.toList()));
            allProgressIndex.addAll(tsFileManager.getTsFileList(false).stream().map(TsFileResource::getMaxProgressIndex).collect(Collectors.toList()));
            MinimumProgressIndex maxProgressIndex = MinimumProgressIndex.INSTANCE;
            for (ProgressIndex progressIndex : allProgressIndex) {
                maxProgressIndex = maxProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex(ReplicateProgressDataNodeManager.extractLocalSimpleProgressIndex(progressIndex));
            }
            MinimumProgressIndex finalMaxProgressIndex = maxProgressIndex;
            this.groupId2MaxProgressIndex.compute((ConsensusGroupId)dataRegionId, (arg_0, arg_1) -> ReplicateProgressDataNodeManager.lambda$recoverMaxProgressIndexFromDataRegion$1((ProgressIndex)finalMaxProgressIndex, arg_0, arg_1));
        });
    }

    public ProgressIndex getProgressIndex(ConsensusPipeName consensusPipeName) {
        return PipeDataNodeAgent.task().getPipeTaskProgressIndex(consensusPipeName.toString(), consensusPipeName.getConsensusGroupId().getId());
    }

    public ProgressIndex assignProgressIndex(ConsensusGroupId consensusGroupId) {
        return this.groupId2MaxProgressIndex.compute(consensusGroupId, (key, value) -> (value == null ? MinimumProgressIndex.INSTANCE : value).updateToMinimumEqualOrIsAfterProgressIndex(PipeDataNodeAgent.runtime().assignProgressIndexForPipeConsensus()));
    }

    public ProgressIndex getMaxAssignedProgressIndex(ConsensusGroupId consensusGroupId) {
        return this.groupId2MaxProgressIndex.getOrDefault(consensusGroupId, (ProgressIndex)MinimumProgressIndex.INSTANCE);
    }

    public long getSyncLagForSpecificConsensusPipe(ConsensusGroupId consensusGroupId, ConsensusPipeName consensusPipeName) {
        return PipeConsensusSyncLagManager.getInstance((String)consensusGroupId.toString()).getSyncLagForRegionMigration(consensusPipeName, this.consensusPipe2pinnedCommitIndexForMigration.getOrDefault(consensusPipeName, 0L).longValue());
    }

    public void pinCommitIndexForMigration(ConsensusGroupId consensusGroupId, ConsensusPipeName consensusPipeName) {
        this.consensusPipe2pinnedCommitIndexForMigration.put(consensusPipeName, PipeConsensusSyncLagManager.getInstance((String)consensusGroupId.toString()).getCurrentCommitIndex(consensusPipeName));
    }

    private static /* synthetic */ ProgressIndex lambda$recoverMaxProgressIndexFromDataRegion$1(ProgressIndex finalMaxProgressIndex, ConsensusGroupId key, ProgressIndex value) {
        return (value == null ? MinimumProgressIndex.INSTANCE : value).updateToMinimumEqualOrIsAfterProgressIndex(finalMaxProgressIndex);
    }
}

