/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.relational.tvf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.udf.builtin.relational.tvf.WindowTVFUtils;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.DescribedSchema;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.argument.TableArgument;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.TableParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.ColumnBuilder;

public class HOPTableFunction
implements TableFunction {
    private static final String DATA_PARAMETER_NAME = "DATA";
    private static final String TIMECOL_PARAMETER_NAME = "TIMECOL";
    private static final String SIZE_PARAMETER_NAME = "SIZE";
    private static final String SLIDE_PARAMETER_NAME = "SLIDE";
    private static final String ORIGIN_PARAMETER_NAME = "ORIGIN";

    public List<ParameterSpecification> getArgumentsSpecifications() {
        return Arrays.asList(TableParameterSpecification.builder().name(DATA_PARAMETER_NAME).rowSemantics().passThroughColumns().build(), ScalarParameterSpecification.builder().name(TIMECOL_PARAMETER_NAME).type(Type.STRING).defaultValue((Object)"time").build(), ScalarParameterSpecification.builder().name(SIZE_PARAMETER_NAME).type(Type.INT64).build(), ScalarParameterSpecification.builder().name(SLIDE_PARAMETER_NAME).type(Type.INT64).build(), ScalarParameterSpecification.builder().name(ORIGIN_PARAMETER_NAME).type(Type.TIMESTAMP).defaultValue((Object)0L).build());
    }

    public TableFunctionAnalysis analyze(Map<String, Argument> arguments) {
        TableArgument tableArgument = (TableArgument)arguments.get(DATA_PARAMETER_NAME);
        String expectedFieldName = (String)((ScalarArgument)arguments.get(TIMECOL_PARAMETER_NAME)).getValue();
        int requiredIndex = WindowTVFUtils.findColumnIndex(tableArgument, expectedFieldName, Collections.singleton(Type.TIMESTAMP));
        DescribedSchema properColumnSchema = new DescribedSchema.Builder().addField("window_start", Type.TIMESTAMP).addField("window_end", Type.TIMESTAMP).build();
        return TableFunctionAnalysis.builder().properColumnSchema(properColumnSchema).requireRecordSnapshot(false).requiredColumns(DATA_PARAMETER_NAME, Collections.singletonList(requiredIndex)).build();
    }

    public TableFunctionProcessorProvider getProcessorProvider(final Map<String, Argument> arguments) {
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor() {
                return new HOPDataProcessor((Long)((ScalarArgument)arguments.get(HOPTableFunction.ORIGIN_PARAMETER_NAME)).getValue(), (Long)((ScalarArgument)arguments.get(HOPTableFunction.SLIDE_PARAMETER_NAME)).getValue(), (Long)((ScalarArgument)arguments.get(HOPTableFunction.SIZE_PARAMETER_NAME)).getValue());
            }
        };
    }

    private static class HOPDataProcessor
    implements TableFunctionDataProcessor {
        private final long slide;
        private final long size;
        private final long start;
        private long curIndex = 0L;

        public HOPDataProcessor(long startTime, long slide, long size) {
            this.slide = slide;
            this.size = size;
            this.start = startTime;
        }

        public void process(Record input, List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            long timeValue = input.getLong(0);
            for (long window_start = (timeValue - this.start - this.size + this.slide) / this.slide * this.slide; window_start <= timeValue && window_start + this.size > timeValue; window_start += this.slide) {
                properColumnBuilders.get(0).writeLong(window_start);
                properColumnBuilders.get(1).writeLong(window_start + this.size);
                passThroughIndexBuilder.writeLong(this.curIndex);
            }
            ++this.curIndex;
        }
    }
}

