/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.testonly;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.testonly.NeverFinishProcedure;
import org.apache.iotdb.confignode.procedure.impl.testonly.ProcedureTestUtils;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestOnly
public class AddNeverFinishSubProcedureProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, Integer> {
    public static final Logger LOGGER = LoggerFactory.getLogger(AddNeverFinishSubProcedureProcedure.class);
    public static final String FAIL_DATABASE_NAME = "root.fail";

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, Integer state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        if (state == 0) {
            this.addChildProcedure(new NeverFinishProcedure());
            this.setNextState(1);
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
        if (state == 1) {
            LOGGER.error("AddNeverFinishSubProcedureProcedure run again, which should never happen");
            ProcedureTestUtils.createDatabase(env.getConfigManager(), FAIL_DATABASE_NAME);
        }
        return StateMachineProcedure.Flow.NO_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv configNodeProcedureEnv, Integer integer) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected Integer getState(int stateId) {
        return stateId;
    }

    @Override
    protected int getStateId(Integer integer) {
        return integer;
    }

    @Override
    protected Integer getInitialState() {
        return 0;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.ADD_NEVER_FINISH_SUB_PROCEDURE_PROCEDURE.getTypeCode());
        super.serialize(stream);
    }
}

