/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.progress.CommitterKey;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.PipeSnapshotEvent;
import org.apache.iotdb.commons.pipe.event.PipeWritePlanEvent;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrichedEvent
implements Event {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichedEvent.class);
    protected final AtomicInteger referenceCount;
    protected final AtomicBoolean isReleased;
    protected final String pipeName;
    protected final long creationTime;
    protected final PipeTaskMeta pipeTaskMeta;
    protected CommitterKey committerKey;
    public static final long NO_COMMIT_ID = -1L;
    protected long commitId = -1L;
    protected long replicateIndexForIoTV2 = -1L;
    protected int rebootTimes = 0;
    protected final TreePattern treePattern;
    protected final TablePattern tablePattern;
    protected final long startTime;
    protected final long endTime;
    protected boolean isPatternParsed;
    protected boolean isTimeParsed;
    protected volatile boolean shouldReportOnCommit = true;
    protected List<Supplier<Void>> onCommittedHooks = new ArrayList<Supplier<Void>>();
    protected String userName;
    protected boolean skipIfNoPrivileges;

    protected EnrichedEvent(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, String userName, boolean skipIfNoPrivileges, long startTime, long endTime) {
        this.referenceCount = new AtomicInteger(0);
        this.isReleased = new AtomicBoolean(false);
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.pipeTaskMeta = pipeTaskMeta;
        this.treePattern = treePattern;
        this.tablePattern = tablePattern;
        this.userName = userName;
        this.skipIfNoPrivileges = skipIfNoPrivileges;
        this.startTime = startTime;
        this.endTime = endTime;
        this.isPatternParsed = !(treePattern != null && !treePattern.isRoot() || tablePattern != null && tablePattern.hasUserSpecifiedDatabasePatternOrTablePattern());
        this.isTimeParsed = Long.MIN_VALUE == startTime && Long.MAX_VALUE == endTime;
        this.addOnCommittedHook(() -> {
            if (this.shouldReportOnCommit) {
                this.reportProgress();
            }
            return null;
        });
    }

    protected void trackResource() {
    }

    public synchronized boolean increaseReferenceCount(String holderMessage) {
        boolean isSuccessful = true;
        if (this.isReleased.get()) {
            LOGGER.warn("re-increase reference count to event that has already been released: {}, stack trace: {}", (Object)this.coreReportMessage(), (Object)Thread.currentThread().getStackTrace());
            isSuccessful = false;
            return isSuccessful;
        }
        if (this.referenceCount.get() == 0) {
            isSuccessful = this.internallyIncreaseResourceReferenceCount(holderMessage);
        }
        if (isSuccessful) {
            if (this.referenceCount.incrementAndGet() == 1 && PipeConfig.getInstance().getPipeEventReferenceTrackingEnabled()) {
                this.trackResource();
            }
        } else {
            LOGGER.warn("increase reference count failed, EnrichedEvent: {}, stack trace: {}", (Object)this.coreReportMessage(), (Object)Thread.currentThread().getStackTrace());
        }
        return isSuccessful;
    }

    public abstract boolean internallyIncreaseResourceReferenceCount(String var1);

    public synchronized boolean decreaseReferenceCount(String holderMessage, boolean shouldReport) {
        int newReferenceCount;
        boolean isSuccessful = true;
        if (this.isReleased.get()) {
            LOGGER.warn("decrease reference count to event that has already been released: {}, stack trace: {}", (Object)this.coreReportMessage(), (Object)Thread.currentThread().getStackTrace());
            isSuccessful = false;
            return isSuccessful;
        }
        if (this.referenceCount.get() == 1) {
            if (!this.internallyDecreaseResourceReferenceCount(holderMessage)) {
                LOGGER.warn("resource reference count is decreased to 0, but failed to release the resource, EnrichedEvent: {}, stack trace: {}", (Object)this.coreReportMessage(), (Object)Thread.currentThread().getStackTrace());
            }
            if (!shouldReport) {
                this.shouldReportOnCommit = false;
            }
            PipeEventCommitManager.getInstance().commit(this, this.committerKey);
        }
        if ((newReferenceCount = this.referenceCount.decrementAndGet()) <= 0) {
            this.isReleased.set(true);
            boolean bl = isSuccessful = newReferenceCount == 0;
            if (newReferenceCount < 0) {
                LOGGER.warn("reference count is decreased to {}, event: {}, stack trace: {}", new Object[]{newReferenceCount, this.coreReportMessage(), Thread.currentThread().getStackTrace()});
                this.referenceCount.set(0);
            }
        }
        if (!isSuccessful) {
            LOGGER.warn("decrease reference count failed, EnrichedEvent: {}, stack trace: {}", (Object)this.coreReportMessage(), (Object)Thread.currentThread().getStackTrace());
        }
        return isSuccessful;
    }

    public synchronized boolean clearReferenceCount(String holderMessage) {
        if (this.isReleased.get()) {
            return false;
        }
        if (this.referenceCount.get() >= 1) {
            this.shouldReportOnCommit = false;
            if (!this.internallyDecreaseResourceReferenceCount(holderMessage)) {
                LOGGER.warn("resource reference count is decreased to 0, but failed to release the resource, EnrichedEvent: {}, stack trace: {}", (Object)this.coreReportMessage(), (Object)Thread.currentThread().getStackTrace());
            }
        }
        this.referenceCount.set(0);
        this.isReleased.set(true);
        return true;
    }

    public abstract boolean internallyDecreaseResourceReferenceCount(String var1);

    protected void reportProgress() {
        if (this.pipeTaskMeta != null) {
            ProgressIndex progressIndex = this.getProgressIndex();
            this.pipeTaskMeta.updateProgressIndex(progressIndex == null ? MinimumProgressIndex.INSTANCE : progressIndex);
        }
    }

    public void skipReportOnCommit() {
        this.shouldReportOnCommit = false;
    }

    public void bindProgressIndex(ProgressIndex progressIndex) {
        throw new UnsupportedOperationException("This event does not support binding progressIndex.");
    }

    public abstract ProgressIndex getProgressIndex();

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public final String getPipeName() {
        return this.pipeName;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final int getRegionId() {
        return this.committerKey == null ? -1 : this.committerKey.getRegionId();
    }

    public final boolean isDataRegionEvent() {
        return !(this instanceof PipeWritePlanEvent) && !(this instanceof PipeSnapshotEvent);
    }

    public final String getTreePatternString() {
        return this.treePattern != null ? this.treePattern.getPattern() : null;
    }

    public final TreePattern getTreePattern() {
        return this.treePattern;
    }

    public final TablePattern getTablePattern() {
        return this.tablePattern;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isSkipIfNoPrivileges() {
        return this.skipIfNoPrivileges;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public void skipParsingPattern() {
        this.isPatternParsed = true;
    }

    public void skipParsingTime() {
        this.isTimeParsed = true;
    }

    public boolean shouldParseTimeOrPattern() {
        return this.shouldParseTime() || this.shouldParsePattern();
    }

    public boolean shouldParsePattern() {
        return !this.isPatternParsed;
    }

    public boolean shouldParseTime() {
        return !this.isTimeParsed;
    }

    public abstract EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String var1, long var2, PipeTaskMeta var4, TreePattern var5, TablePattern var6, String var7, boolean var8, long var9, long var11);

    public PipeTaskMeta getPipeTaskMeta() {
        return this.pipeTaskMeta;
    }

    public abstract boolean isGeneratedByPipe();

    public boolean needToCommit() {
        return true;
    }

    public void throwIfNoPrivilege() throws Exception {
    }

    public abstract boolean mayEventTimeOverlappedWithTimeRange();

    public abstract boolean mayEventPathsOverlappedWithPattern();

    public void setCommitterKeyAndCommitId(CommitterKey committerKey, long commitId) {
        this.committerKey = committerKey;
        this.commitId = commitId;
    }

    public void setRebootTimes(int rebootTimes) {
        this.rebootTimes = rebootTimes;
    }

    public int getRebootTimes() {
        return this.rebootTimes;
    }

    public CommitterKey getCommitterKey() {
        return this.committerKey;
    }

    public long getCommitId() {
        return this.commitId;
    }

    public long getReplicateIndexForIoTV2() {
        return this.replicateIndexForIoTV2;
    }

    public void setReplicateIndexForIoTV2(long replicateIndexForIoTV2) {
        this.replicateIndexForIoTV2 = replicateIndexForIoTV2;
    }

    public void onCommitted() {
        this.onCommittedHooks.forEach(Supplier::get);
    }

    public void addOnCommittedHook(Supplier<Void> hook) {
        this.onCommittedHooks.add(hook);
    }

    public boolean isReleased() {
        return this.isReleased.get();
    }

    public boolean equalsInPipeConsensus(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrichedEvent otherEvent = (EnrichedEvent)o;
        return Objects.equals(this.committerKey, otherEvent.committerKey) && this.commitId == otherEvent.commitId && this.rebootTimes == otherEvent.rebootTimes && this.replicateIndexForIoTV2 == otherEvent.replicateIndexForIoTV2;
    }

    public String toString() {
        return "EnrichedEvent{referenceCount=" + this.referenceCount.get() + ", isReleased=" + this.isReleased.get() + ", pipeName='" + this.pipeName + "', pipeTaskMeta=" + this.pipeTaskMeta + ", committerKey='" + this.committerKey + "', commitId=" + this.commitId + "', replicateIndexForIoTV2=" + this.replicateIndexForIoTV2 + ", treePattern='" + this.treePattern + "', tablePattern='" + this.tablePattern + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", isPatternParsed=" + this.isPatternParsed + ", isTimeParsed=" + this.isTimeParsed + ", shouldReportOnCommit=" + this.shouldReportOnCommit + ", userName=" + this.userName + ", skipIfNoPrivileges=" + this.skipIfNoPrivileges + '}';
    }

    public String coreReportMessage() {
        return "EnrichedEvent{referenceCount=" + this.referenceCount.get() + ", isReleased=" + this.isReleased.get() + ", pipeName='" + this.pipeName + "', committerKey='" + this.committerKey + "', commitId=" + this.commitId + "', replicateIndexForIoTV2=" + this.replicateIndexForIoTV2 + ", treePattern='" + this.treePattern + "', tablePattern='" + this.tablePattern + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", isPatternParsed=" + this.isPatternParsed + ", isTimeParsed=" + this.isTimeParsed + ", shouldReportOnCommit=" + this.shouldReportOnCommit + ", userName=" + this.userName + ", skipIfNoPrivileges=" + this.skipIfNoPrivileges + '}';
    }
}

