/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.security;

import java.util.Objects;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.exception.auth.AccessDeniedException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.security.ITableAuthChecker;
import org.apache.iotdb.db.queryengine.plan.relational.security.TableModelPrivilege;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RelationalAuthorStatement;
import org.apache.iotdb.db.queryengine.plan.relational.type.AuthorRType;
import org.apache.iotdb.db.schemaengine.table.InformationSchemaUtils;

public class AccessControlImpl
implements AccessControl {
    private final ITableAuthChecker authChecker;

    public AccessControlImpl(ITableAuthChecker authChecker) {
        this.authChecker = authChecker;
    }

    @Override
    public void checkCanCreateDatabase(String userName, String databaseName) {
        InformationSchemaUtils.checkDBNameInWrite(databaseName);
        this.authChecker.checkDatabasePrivilege(userName, databaseName, TableModelPrivilege.CREATE);
    }

    @Override
    public void checkCanDropDatabase(String userName, String databaseName) {
        InformationSchemaUtils.checkDBNameInWrite(databaseName);
        this.authChecker.checkDatabasePrivilege(userName, databaseName, TableModelPrivilege.DROP);
    }

    @Override
    public void checkCanAlterDatabase(String userName, String databaseName) {
        InformationSchemaUtils.checkDBNameInWrite(databaseName);
        this.authChecker.checkDatabasePrivilege(userName, databaseName, TableModelPrivilege.ALTER);
    }

    @Override
    public void checkCanShowOrUseDatabase(String userName, String databaseName) {
        if (databaseName.equals("information_schema")) {
            return;
        }
        this.authChecker.checkDatabaseVisibility(userName, databaseName);
    }

    @Override
    public void checkCanCreateTable(String userName, QualifiedObjectName tableName) {
        InformationSchemaUtils.checkDBNameInWrite(tableName.getDatabaseName());
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.CREATE);
    }

    @Override
    public void checkCanDropTable(String userName, QualifiedObjectName tableName) {
        InformationSchemaUtils.checkDBNameInWrite(tableName.getDatabaseName());
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.DROP);
    }

    @Override
    public void checkCanAlterTable(String userName, QualifiedObjectName tableName) {
        InformationSchemaUtils.checkDBNameInWrite(tableName.getDatabaseName());
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.ALTER);
    }

    @Override
    public void checkCanInsertIntoTable(String userName, QualifiedObjectName tableName) {
        InformationSchemaUtils.checkDBNameInWrite(tableName.getDatabaseName());
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.INSERT);
    }

    @Override
    public void checkCanSelectFromTable(String userName, QualifiedObjectName tableName) {
        if (tableName.getDatabaseName().equals("information_schema")) {
            this.checkUserIsAdmin(userName);
            return;
        }
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.SELECT);
    }

    @Override
    public void checkCanSelectFromDatabase4Pipe(String userName, String databaseName) {
        if (Objects.isNull(userName)) {
            throw new AccessDeniedException("User not exists");
        }
        this.authChecker.checkDatabasePrivilege(userName, databaseName, TableModelPrivilege.SELECT);
    }

    @Override
    public boolean checkCanSelectFromTable4Pipe(String userName, QualifiedObjectName tableName) {
        return Objects.nonNull(userName) && this.authChecker.checkTablePrivilege4Pipe(userName, tableName);
    }

    @Override
    public void checkCanDeleteFromTable(String userName, QualifiedObjectName tableName) {
        InformationSchemaUtils.checkDBNameInWrite(tableName.getDatabaseName());
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.DELETE);
    }

    @Override
    public void checkCanShowOrDescTable(String userName, QualifiedObjectName tableName) {
        if (tableName.getDatabaseName().equals("information_schema")) {
            return;
        }
        this.authChecker.checkTableVisibility(userName, tableName);
    }

    @Override
    public void checkUserCanRunRelationalAuthorStatement(String userName, RelationalAuthorStatement statement) {
        AuthorRType type = statement.getAuthorType();
        switch (type) {
            case CREATE_USER: {
                if (AuthorityChecker.SUPER_USER.equals(statement.getUserName())) {
                    throw new AccessDeniedException("Cannot create user has same name with admin user");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                this.authChecker.checkGlobalPrivilege(userName, TableModelPrivilege.MANAGE_USER);
                return;
            }
            case DROP_USER: {
                if (AuthorityChecker.SUPER_USER.equals(statement.getUserName()) || statement.getUserName().equals(userName)) {
                    throw new AccessDeniedException("Cannot drop admin user or yourself");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                this.authChecker.checkGlobalPrivilege(userName, TableModelPrivilege.MANAGE_USER);
                return;
            }
            case UPDATE_USER: 
            case LIST_USER_PRIV: {
                if (AuthorityChecker.SUPER_USER.equals(userName) || statement.getUserName().equals(userName)) {
                    return;
                }
                this.authChecker.checkGlobalPrivilege(userName, TableModelPrivilege.MANAGE_USER);
                return;
            }
            case LIST_USER: {
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                this.authChecker.checkGlobalPrivilege(userName, TableModelPrivilege.MANAGE_USER);
                return;
            }
            case CREATE_ROLE: {
                if (AuthorityChecker.SUPER_USER.equals(statement.getRoleName())) {
                    throw new AccessDeniedException("Cannot create role has same name with admin user");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                this.authChecker.checkGlobalPrivilege(userName, TableModelPrivilege.MANAGE_ROLE);
                return;
            }
            case DROP_ROLE: {
                if (AuthorityChecker.SUPER_USER.equals(statement.getUserName())) {
                    throw new AccessDeniedException("Cannot drop role with admin name");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                this.authChecker.checkGlobalPrivilege(userName, TableModelPrivilege.MANAGE_ROLE);
                return;
            }
            case GRANT_USER_ROLE: {
                if (AuthorityChecker.SUPER_USER.equals(statement.getUserName())) {
                    throw new AccessDeniedException("Cannot grant role to admin");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                this.authChecker.checkGlobalPrivilege(userName, TableModelPrivilege.MANAGE_ROLE);
                return;
            }
            case REVOKE_USER_ROLE: {
                if (AuthorityChecker.SUPER_USER.equals(statement.getUserName())) {
                    throw new AccessDeniedException("Cannot revoke role from admin");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                this.authChecker.checkGlobalPrivilege(userName, TableModelPrivilege.MANAGE_ROLE);
                return;
            }
            case LIST_ROLE: {
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                if (statement.getUserName() != null && statement.getUserName().equals(userName)) {
                    return;
                }
                this.authChecker.checkGlobalPrivilege(userName, TableModelPrivilege.MANAGE_ROLE);
                return;
            }
            case LIST_ROLE_PRIV: {
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                if (AuthorityChecker.checkRole(userName, statement.getRoleName())) {
                    return;
                }
                this.authChecker.checkGlobalPrivilege(userName, TableModelPrivilege.MANAGE_ROLE);
                return;
            }
            case GRANT_ROLE_ANY: 
            case GRANT_USER_ANY: 
            case REVOKE_ROLE_ANY: 
            case REVOKE_USER_ANY: {
                if (AuthorityChecker.SUPER_USER.equals(statement.getUserName())) {
                    throw new AccessDeniedException("Cannot grant/revoke privileges of admin user");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                for (PrivilegeType privilegeType : statement.getPrivilegeTypes()) {
                    this.authChecker.checkAnyScopePrivilegeGrantOption(userName, TableModelPrivilege.getTableModelType(privilegeType));
                }
                return;
            }
            case GRANT_ROLE_ALL: 
            case REVOKE_ROLE_ALL: 
            case GRANT_USER_ALL: 
            case REVOKE_USER_ALL: {
                if (AuthorityChecker.SUPER_USER.equals(statement.getUserName())) {
                    throw new AccessDeniedException("Cannot grant/revoke all privileges of admin user");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                for (TableModelPrivilege privilege : TableModelPrivilege.values()) {
                    PrivilegeType privilegeType = privilege.getPrivilegeType();
                    if (privilegeType.isRelationalPrivilege()) {
                        this.authChecker.checkAnyScopePrivilegeGrantOption(userName, privilege);
                    }
                    if (!privilegeType.forRelationalSys()) continue;
                    this.authChecker.checkGlobalPrivilegeGrantOption(userName, privilege);
                }
                return;
            }
            case GRANT_USER_DB: 
            case GRANT_ROLE_DB: 
            case REVOKE_USER_DB: 
            case REVOKE_ROLE_DB: {
                if (AuthorityChecker.SUPER_USER.equals(statement.getUserName())) {
                    throw new AccessDeniedException("Cannot grant/revoke privileges of admin user");
                }
                if ("information_schema".equals(statement.getDatabase())) {
                    throw new SemanticException("Cannot grant or revoke any privileges to information_schema");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                for (PrivilegeType privilegeType : statement.getPrivilegeTypes()) {
                    this.authChecker.checkDatabasePrivilegeGrantOption(userName, statement.getDatabase(), TableModelPrivilege.getTableModelType(privilegeType));
                }
                return;
            }
            case GRANT_USER_TB: 
            case GRANT_ROLE_TB: 
            case REVOKE_USER_TB: 
            case REVOKE_ROLE_TB: {
                if (AuthorityChecker.SUPER_USER.equals(statement.getUserName())) {
                    throw new AccessDeniedException("Cannot grant/revoke privileges of admin user");
                }
                if ("information_schema".equals(statement.getDatabase())) {
                    throw new SemanticException("Cannot grant or revoke any privileges to information_schema");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                for (PrivilegeType privilegeType : statement.getPrivilegeTypes()) {
                    this.authChecker.checkTablePrivilegeGrantOption(userName, new QualifiedObjectName(statement.getDatabase(), statement.getTableName()), TableModelPrivilege.getTableModelType(privilegeType));
                }
                return;
            }
            case GRANT_USER_SYS: 
            case GRANT_ROLE_SYS: 
            case REVOKE_USER_SYS: 
            case REVOKE_ROLE_SYS: {
                if (AuthorityChecker.SUPER_USER.equals(statement.getUserName())) {
                    throw new AccessDeniedException("Cannot grant/revoke privileges of admin user");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return;
                }
                for (PrivilegeType privilegeType : statement.getPrivilegeTypes()) {
                    this.authChecker.checkGlobalPrivilegeGrantOption(userName, TableModelPrivilege.getTableModelType(privilegeType));
                }
                break;
            }
        }
    }

    @Override
    public void checkUserIsAdmin(String userName) {
        if (!AuthorityChecker.SUPER_USER.equals(userName)) {
            throw new AccessDeniedException("No permissions for this operation, only root user is allowed");
        }
    }
}

