/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.IrTypeAnalyzer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.IterativeOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.RuleStatsRecorder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.CanonicalizeExpressions;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.ImplementTableFunctionSource;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.InlineProjections;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.MergeFilters;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.MergeLimitOverProjectWithSort;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.MergeLimitWithSort;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.MergeLimits;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.MultipleDistinctAggregationToMarkDistinct;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneAggregationColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneAggregationSourceColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneApplyColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneApplyCorrelation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneApplySourceColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneAssignUniqueIdColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneCorrelatedJoinColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneCorrelatedJoinCorrelation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneDistinctAggregation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneEnforceSingleRowColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneExplainAnalyzeColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneFillColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneFilterColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneGapFillColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneJoinChildrenColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneJoinColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneLimitColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneMarkDistinctColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneOffsetColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneOutputSourceColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneProjectColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneSortColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneTableFunctionProcessorColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneTableFunctionProcessorSourceColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneTableScanColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneTopKColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PushLimitThroughOffset;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PushLimitThroughProject;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.RemoveDuplicateConditions;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.RemoveRedundantEnforceSingleRowNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.RemoveRedundantExists;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.RemoveRedundantIdentityProjections;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.RemoveTrivialFilters;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.RemoveUnreferencedScalarApplyNodes;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.RemoveUnreferencedScalarSubqueries;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.SimplifyExpressions;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.SingleDistinctAggregationToGroupBy;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.TransformCorrelatedDistinctAggregationWithProjection;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.TransformCorrelatedDistinctAggregationWithoutProjection;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.TransformCorrelatedGlobalAggregationWithProjection;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.TransformCorrelatedGlobalAggregationWithoutProjection;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.TransformCorrelatedGroupedAggregationWithProjection;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.TransformCorrelatedGroupedAggregationWithoutProjection;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.TransformCorrelatedJoinToJoin;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.TransformExistsApplyToCorrelatedJoin;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.TransformUncorrelatedSubqueryToJoin;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.CheckSubqueryNodesAreRewritten;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PushAggregationIntoTableScan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PushLimitOffsetIntoTableScan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PushPredicateIntoTableScan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.TransformAggregationToStreamable;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.TransformQuantifiedComparisonApplyToCorrelatedJoin;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.TransformSortToStreamSort;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.UnaliasSymbolReferences;

public class LogicalOptimizeFactory {
    private final List<PlanOptimizer> planOptimizers;

    public LogicalOptimizeFactory(PlannerContext plannerContext) {
        IrTypeAnalyzer typeAnalyzer = new IrTypeAnalyzer(plannerContext);
        Metadata metadata = plannerContext.getMetadata();
        RuleStatsRecorder ruleStats = new RuleStatsRecorder();
        ImmutableSet columnPruningRules = ImmutableSet.of((Object)new PruneAggregationColumns(), (Object)new PruneAggregationSourceColumns(), (Object)new PruneApplyColumns(), (Object)new PruneApplyCorrelation(), (Object)new PruneApplySourceColumns(), (Object)new PruneAssignUniqueIdColumns(), (Object[])new Rule[]{new PruneCorrelatedJoinColumns(), new PruneCorrelatedJoinCorrelation(), new PruneEnforceSingleRowColumns(), new PruneFilterColumns(), new PruneGapFillColumns(), new PruneFillColumns(), new PruneLimitColumns(), new PruneMarkDistinctColumns(), new PruneOffsetColumns(), new PruneOutputSourceColumns(), new PruneExplainAnalyzeColumns(), new PruneProjectColumns(), new PruneSortColumns(), new PruneTableFunctionProcessorSourceColumns(), new PruneTableFunctionProcessorColumns(), new PruneTableScanColumns(plannerContext.getMetadata()), new PruneTopKColumns(), new PruneJoinColumns(), new PruneJoinChildrenColumns()});
        IterativeOptimizer columnPruningOptimizer = new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)columnPruningRules);
        IterativeOptimizer inlineProjectionLimitFiltersOptimizer = new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(plannerContext), (Object)new RemoveRedundantIdentityProjections(), (Object)new MergeFilters(), (Object)new MergeLimits()));
        ImmutableSet simplifyOptimizerRules = ImmutableSet.builder().addAll(new SimplifyExpressions(plannerContext, typeAnalyzer).rules()).addAll(new RemoveDuplicateConditions(metadata).rules()).addAll(new CanonicalizeExpressions(plannerContext, typeAnalyzer).rules()).add((Object)new RemoveTrivialFilters()).build();
        IterativeOptimizer simplifyOptimizer = new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)simplifyOptimizerRules);
        ImmutableSet limitPushdownRules = ImmutableSet.of((Object)new PushLimitThroughOffset(), (Object)new PushLimitThroughProject());
        ImmutableList.Builder optimizerBuilder = ImmutableList.builder();
        optimizerBuilder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)columnPruningRules).addAll((Iterable)ImmutableSet.of((Object)new ImplementTableFunctionSource(), (Object)new MergeFilters(), (Object)new InlineProjections(plannerContext), (Object)new RemoveRedundantIdentityProjections(), (Object)new MergeLimits(), (Object)new RemoveTrivialFilters(), (Object[])new Rule[]{new RemoveRedundantEnforceSingleRowNode(), new RemoveRedundantExists(), new SingleDistinctAggregationToGroupBy(), new MultipleDistinctAggregationToMarkDistinct()})).build()), new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)columnPruningRules).addAll((Iterable)limitPushdownRules).addAll((Iterable)ImmutableSet.of((Object)new MergeFilters(), (Object)new RemoveTrivialFilters(), (Object)new MergeLimits(), (Object)new InlineProjections(plannerContext), (Object)new RemoveRedundantIdentityProjections())).build()), simplifyOptimizer, new UnaliasSymbolReferences(plannerContext.getMetadata()), columnPruningOptimizer, inlineProjectionLimitFiltersOptimizer, new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.of((Object)new TransformExistsApplyToCorrelatedJoin(plannerContext))), new TransformQuantifiedComparisonApplyToCorrelatedJoin(metadata), new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantEnforceSingleRowNode(), (Object)new RemoveUnreferencedScalarSubqueries(), (Object)new TransformUncorrelatedSubqueryToJoin(), (Object)new TransformUncorrelatedInPredicateSubqueryToSemiJoin(), (Object)new TransformCorrelatedJoinToJoin(plannerContext), (Object)new TransformCorrelatedGlobalAggregationWithProjection(plannerContext), (Object[])new Rule[]{new TransformCorrelatedGlobalAggregationWithoutProjection(plannerContext), new TransformCorrelatedDistinctAggregationWithProjection(plannerContext), new TransformCorrelatedDistinctAggregationWithoutProjection(plannerContext), new TransformCorrelatedGroupedAggregationWithProjection(plannerContext), new TransformCorrelatedGroupedAggregationWithoutProjection(plannerContext)})), new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveUnreferencedScalarApplyNodes(), (Object)new TransformCorrelatedJoinToJoin(plannerContext))), new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(plannerContext), (Object)new RemoveRedundantIdentityProjections())), new CheckSubqueryNodesAreRewritten(), new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.of((Object)new PruneDistinctAggregation())), simplifyOptimizer, new PushPredicateIntoTableScan(plannerContext, typeAnalyzer), columnPruningOptimizer, inlineProjectionLimitFiltersOptimizer, new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)limitPushdownRules), new PushLimitOffsetIntoTableScan(), new TransformAggregationToStreamable(), new PushAggregationIntoTableScan(), new TransformSortToStreamSort(), new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new MergeLimitOverProjectWithSort()))});
        this.planOptimizers = optimizerBuilder.build();
    }

    public List<PlanOptimizer> getPlanOptimizers() {
        return this.planOptimizers;
    }
}

