/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITableTimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AbstractAggTableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AbstractTableScanOperator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.RamUsageEstimator;

public abstract class AbstractDefaultAggTableScanOperator
extends AbstractAggTableScanOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AbstractDefaultAggTableScanOperator.class);

    public AbstractDefaultAggTableScanOperator(AbstractAggTableScanOperator.AbstractAggTableScanOperatorParameter parameter) {
        super(parameter);
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.retainedTsBlock != null) {
            return true;
        }
        return this.timeIterator.hasCachedTimeRange() || this.timeIterator.hasNextTimeRange();
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        if (this.tableAggregators.isEmpty() && this.timeIterator.getType() == ITableTimeRangeIterator.TimeIteratorType.SINGLE_TIME_ITERATOR && this.resultTsBlockBuilder.getValueColumnBuilders().length == 0) {
            this.resultTsBlockBuilder.reset();
            this.currentDeviceIndex = this.deviceCount;
            this.timeIterator.setFinished();
            Column[] valueColumns = new Column[]{};
            return new TsBlock(1, (Column)new RunLengthEncodedColumn((Column)AbstractTableScanOperator.TIME_COLUMN_TEMPLATE, 1), valueColumns);
        }
        long start = System.nanoTime();
        long maxRuntime = this.leftRuntimeOfOneNextCall = 1000L * this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        while (System.nanoTime() - start < maxRuntime && (this.timeIterator.hasCachedTimeRange() || this.timeIterator.hasNextTimeRange()) && !this.resultTsBlockBuilder.isFull()) {
            if (!this.calculateAggregationResultForCurrentTimeRange()) continue;
            this.timeIterator.resetCurTimeRange();
        }
        if (this.resultTsBlockBuilder.isEmpty()) {
            return null;
        }
        this.buildResultTsBlock();
        return this.checkTsBlockSizeAndGetResult();
    }

    @Override
    protected void updateResultTsBlock() {
        this.appendAggregationResult();
        this.resetTableAggregators();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.seriesScanUtil) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.sourceId) + (this.resultTsBlockBuilder == null ? 0L : this.resultTsBlockBuilder.getRetainedSizeInBytes()) + RamUsageEstimator.sizeOfCollection((Collection)this.deviceEntries);
    }
}

