/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table.column;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.record.Tablet;

public enum TsTableColumnCategory {
    TAG(0),
    ATTRIBUTE(1),
    TIME(2),
    FIELD(3);

    private final byte category;

    private TsTableColumnCategory(byte category) {
        this.category = category;
    }

    byte getValue() {
        return this.category;
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)this.category, (OutputStream)stream);
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((byte)this.category, (ByteBuffer)byteBuffer);
    }

    public static TsTableColumnCategory deserialize(InputStream stream) throws IOException {
        byte category = (byte)stream.read();
        return TsTableColumnCategory.deserialize(category);
    }

    public static TsTableColumnCategory deserialize(ByteBuffer stream) {
        byte category = stream.get();
        return TsTableColumnCategory.deserialize(category);
    }

    public static TsTableColumnCategory deserialize(byte category) {
        switch (category) {
            case 0: {
                return TAG;
            }
            case 1: {
                return ATTRIBUTE;
            }
            case 2: {
                return TIME;
            }
            case 3: {
                return FIELD;
            }
        }
        throw new IllegalArgumentException();
    }

    public Tablet.ColumnCategory toTsFileColumnType() {
        switch (this) {
            case TAG: {
                return Tablet.ColumnCategory.TAG;
            }
            case ATTRIBUTE: {
                return Tablet.ColumnCategory.ATTRIBUTE;
            }
            case FIELD: {
                return Tablet.ColumnCategory.FIELD;
            }
        }
        throw new IllegalArgumentException("Unsupported column type in TsFile: " + (Object)((Object)this));
    }

    public static TsTableColumnCategory fromTsFileColumnCategory(Tablet.ColumnCategory columnType) {
        switch (columnType) {
            case FIELD: {
                return FIELD;
            }
            case TAG: {
                return TAG;
            }
            case ATTRIBUTE: {
                return ATTRIBUTE;
            }
        }
        throw new IllegalArgumentException("Unknown column type: " + columnType);
    }

    public byte getCategory() {
        return this.category;
    }
}

