/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.resource.PersistentResource;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.PartitionViolationException;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner.PipeTimePartitionProgressIndexKeeper;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.InsertionCompactionCandidateStatus;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModFileManagement;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.modification.TreeDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.v1.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.v1.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.v1.ModificationFileV1;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileLock;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceBlockType;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ArrayDeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.PlainDeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.TimeIndexLevel;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.FilePathUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResource
implements PersistentResource {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TsFileResource.class) + RamUsageEstimator.shallowSizeOfInstance(TsFileRepairStatus.class) + RamUsageEstimator.shallowSizeOfInstance(TsFileID.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileResource.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private File file;
    public static final String RESOURCE_SUFFIX = ".resource";
    public static final String TEMP_SUFFIX = ".temp";
    public static final String BROKEN_SUFFIX = ".broken";
    public static final byte VERSION_NUMBER = 1;
    protected TsFileResource prev;
    protected TsFileResource next;
    private ITimeIndex timeIndex;
    private Future<ModificationFile> exclusiveModFileFuture;
    private CompletableFuture<String> sharedModFilePathFuture;
    private ModFileManagement modFileManagement;
    private volatile ModificationFile exclusiveModFile;
    private volatile ModificationFile sharedModFile;
    private long sharedModFileOffset;
    public static final boolean useSharedModFile = false;
    private volatile ModificationFile compactionModFile;
    protected AtomicReference<TsFileResourceStatus> atomicStatus = new AtomicReference<TsFileResourceStatus>(TsFileResourceStatus.UNCLOSED);
    private TsFileRepairStatus tsFileRepairStatus = TsFileRepairStatus.NORMAL;
    private TsFileLock tsFileLock = new TsFileLock();
    private boolean isSeq;
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private DataRegion.SettleTsFileCallBack settleTsFileCallBack;
    public long maxPlanIndex = Long.MIN_VALUE;
    public long minPlanIndex = Long.MAX_VALUE;
    private TsFileID tsFileID;
    private long deviceTimeIndexRamSize;
    private AtomicInteger tierLevel;
    private volatile long tsFileSize = -1L;
    private TsFileProcessor processor;
    private Map<IFullPath, List<IChunkMetadata>> pathToChunkMetadataListMap = new HashMap<IFullPath, List<IChunkMetadata>>();
    private Map<IFullPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap = new HashMap<IFullPath, List<ReadOnlyMemChunk>>();
    private Map<IFullPath, ITimeSeriesMetadata> pathToTimeSeriesMetadataMap = new ConcurrentHashMap<IFullPath, ITimeSeriesMetadata>();
    private TsFileResource originTsFileResource;
    private ProgressIndex maxProgressIndex;
    private boolean isGeneratedByPipeConsensus = false;
    private boolean isGeneratedByPipe = false;
    private InsertionCompactionCandidateStatus insertionCompactionCandidateStatus = InsertionCompactionCandidateStatus.NOT_CHECKED;

    @TestOnly
    public TsFileResource() {
        this.tsFileID = new TsFileID();
    }

    public TsFileResource(File file) {
        this.file = file;
        this.tsFileID = new TsFileID(file.getAbsolutePath());
        this.timeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        this.isSeq = FilePathUtils.isSequence((String)this.file.getAbsolutePath());
        this.tierLevel = new AtomicInteger(TierManager.getInstance().getFileTierLevel(file));
    }

    public TsFileResource(File file, TsFileResourceStatus status) {
        this(file);
        this.setAtomicStatus(status);
    }

    public TsFileResource(File file, TsFileProcessor processor) {
        this.file = file;
        this.tsFileID = new TsFileID(file.getAbsolutePath());
        this.timeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        this.processor = processor;
        this.isSeq = processor.isSequence();
        this.tierLevel = new AtomicInteger(0);
    }

    public TsFileResource(Map<IFullPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap, Map<IFullPath, List<IChunkMetadata>> pathToChunkMetadataListMap, TsFileResource originTsFileResource) throws IOException {
        this.file = originTsFileResource.file;
        this.timeIndex = originTsFileResource.timeIndex;
        this.pathToReadOnlyMemChunkMap = pathToReadOnlyMemChunkMap;
        this.pathToChunkMetadataListMap = pathToChunkMetadataListMap;
        this.originTsFileResource = originTsFileResource;
        this.tsFileID = originTsFileResource.tsFileID;
        this.isSeq = originTsFileResource.isSeq;
        this.tierLevel = originTsFileResource.tierLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void serialize(String targetFilePath) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(targetFilePath + TEMP_SUFFIX);
        BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
        try {
            this.serializeTo(outputStream);
        }
        finally {
            outputStream.flush();
            fileOutputStream.getFD().sync();
            outputStream.close();
        }
        File src = this.fsFactory.getFile(targetFilePath + TEMP_SUFFIX);
        File dest = this.fsFactory.getFile(targetFilePath);
        this.fsFactory.deleteIfExists(dest);
        this.fsFactory.moveFile(src, dest);
    }

    public synchronized void serialize() throws IOException {
        this.serialize(this.file + RESOURCE_SUFFIX);
    }

    private void serializeTo(BufferedOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
        this.timeIndex.serialize(outputStream);
        ReadWriteIOUtils.write((long)this.maxPlanIndex, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.minPlanIndex, (OutputStream)outputStream);
        if (this.sharedModFile != null && this.sharedModFile.exists()) {
            String modFilePath = this.sharedModFile.getFile().getAbsolutePath();
            ReadWriteIOUtils.write((String)modFilePath, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)this.sharedModFileOffset, (OutputStream)outputStream);
        } else {
            ReadWriteIOUtils.write((String)null, (OutputStream)outputStream);
        }
        if (this.maxProgressIndex != null) {
            TsFileResourceBlockType.PROGRESS_INDEX.serialize(outputStream);
            this.maxProgressIndex.serialize((OutputStream)outputStream);
        } else {
            TsFileResourceBlockType.EMPTY_BLOCK.serialize(outputStream);
        }
        TsFileResourceBlockType.PIPE_MARK.serialize(outputStream);
        ReadWriteIOUtils.write((Boolean)this.isGeneratedByPipeConsensus, (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)this.isGeneratedByPipe, (OutputStream)outputStream);
    }

    public void deserialize() throws IOException {
        try (BufferedInputStream inputStream = this.fsFactory.getBufferedInputStream(this.file + RESOURCE_SUFFIX);){
            String modFilePath;
            ReadWriteIOUtils.readByte((InputStream)inputStream);
            this.timeIndex = ITimeIndex.createTimeIndex(inputStream);
            this.maxPlanIndex = ReadWriteIOUtils.readLong((InputStream)inputStream);
            this.minPlanIndex = ReadWriteIOUtils.readLong((InputStream)inputStream);
            if (((InputStream)inputStream).available() > 0 && (modFilePath = ReadWriteIOUtils.readString((InputStream)inputStream)) != null && modFilePath.endsWith(".mods2")) {
                this.sharedModFileOffset = ReadWriteIOUtils.readLong((InputStream)inputStream);
                if (this.sharedModFilePathFuture != null) {
                    this.sharedModFilePathFuture.complete(modFilePath);
                } else {
                    this.sharedModFilePathFuture = CompletableFuture.completedFuture(modFilePath);
                }
            }
            while (((InputStream)inputStream).available() > 0) {
                TsFileResourceBlockType blockType = TsFileResourceBlockType.deserialize(ReadWriteIOUtils.readByte((InputStream)inputStream));
                switch (blockType) {
                    case PROGRESS_INDEX: {
                        this.maxProgressIndex = ProgressIndexType.deserializeFrom((InputStream)inputStream);
                        break;
                    }
                    case PIPE_MARK: {
                        this.isGeneratedByPipeConsensus = ReadWriteIOUtils.readBoolean((InputStream)inputStream);
                        this.isGeneratedByPipe = ReadWriteIOUtils.readBoolean((InputStream)inputStream);
                        break;
                    }
                }
            }
        }
    }

    public static int getFileTimeIndexSerializedSize() {
        return 48;
    }

    public void serializeFileTimeIndexToByteBuffer(ByteBuffer buffer) {
        buffer.putLong(this.tsFileID.timePartitionId);
        buffer.putLong(this.tsFileID.timestamp);
        buffer.putLong(this.tsFileID.fileVersion);
        buffer.putLong(this.tsFileID.compactionVersion);
        buffer.putLong(this.timeIndex.getMinStartTime());
        buffer.putLong(this.timeIndex.getMaxEndTime());
    }

    public void updateStartTime(IDeviceID device, long time) {
        this.timeIndex.updateStartTime(device, time);
    }

    public void updateEndTime(IDeviceID device, long time) {
        this.timeIndex.updateEndTime(device, time);
    }

    public boolean resourceFileExists() {
        return this.file != null && this.fsFactory.getFile(this.file + RESOURCE_SUFFIX).exists();
    }

    public boolean tsFileExists() {
        return this.file != null && this.file.exists();
    }

    public boolean exclusiveModFileExists() {
        return this.getExclusiveModFile().exists();
    }

    public boolean sharedModFileExists() {
        return this.getSharedModFile() != null && this.sharedModFile.exists();
    }

    public boolean anyModFileExists() {
        return this.exclusiveModFileExists() || this.sharedModFileExists();
    }

    public void link(TsFileResource target) throws IOException {
        Files.createLink(target.getTsFile().toPath(), this.getTsFile().toPath());
        Files.createLink(new File(target.getTsFilePath() + RESOURCE_SUFFIX).toPath(), new File(this.getTsFilePath() + RESOURCE_SUFFIX).toPath());
        this.linkModFile(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkModFile(TsFileResource target) throws IOException {
        ModificationFile targetModsFileObject;
        File targetModsFile = ModificationFile.getExclusiveMods(target.getTsFile());
        ModificationFile sourceModFile = this.getExclusiveModFile();
        sourceModFile.writeLock();
        try {
            if (sourceModFile.exists()) {
                Files.createLink(targetModsFile.toPath(), ModificationFile.getExclusiveMods(this.getTsFile()).toPath());
            }
            targetModsFileObject = new ModificationFile(targetModsFile, true);
            sourceModFile.setCascadeFile(Collections.singleton(targetModsFileObject));
        }
        finally {
            sourceModFile.writeUnlock();
        }
        target.setExclusiveModFile(targetModsFileObject);
        if (this.sharedModFileExists()) {
            this.modFileManagement.addReference(target, this.sharedModFile);
            target.setSharedModFile(this.getSharedModFile(), false);
        }
    }

    public boolean compactionModFileExists() {
        return this.getCompactionModFile().exists();
    }

    public List<IChunkMetadata> getChunkMetadataList(IFullPath seriesPath) {
        return new ArrayList<IChunkMetadata>((Collection)this.pathToChunkMetadataListMap.get(seriesPath));
    }

    public List<ReadOnlyMemChunk> getReadOnlyMemChunk(IFullPath seriesPath) {
        return this.pathToReadOnlyMemChunkMap.get(seriesPath);
    }

    public long getTotalModSizeInByte() {
        return this.getExclusiveModFile().getFileLength() + (this.getSharedModFile() != null ? this.sharedModFile.getFileLength() : 0L);
    }

    private void serializedSharedModFile() throws IOException {
        this.serialize();
    }

    public void setSharedModFile(ModificationFile modFile, boolean serializeNow) {
        if (modFile == null) {
            return;
        }
        this.sharedModFile = modFile;
        try {
            this.sharedModFileOffset = this.sharedModFile.getFileLength();
            if (serializeNow) {
                this.serializedSharedModFile();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to serialize shared mod file", (Throwable)e);
        }
    }

    private synchronized ModificationFile prepareModFileForWrite() throws IOException {
        if (this.getSharedModFile() != null) {
            return this.getSharedModFile();
        }
        return this.getExclusiveModFile();
    }

    public ModificationFile getModFileForWrite() throws IOException {
        if (this.getSharedModFile() != null) {
            return this.getSharedModFile();
        }
        if (this.exclusiveModFile != null) {
            return this.exclusiveModFile;
        }
        return this.prepareModFileForWrite();
    }

    public ModificationFile getSharedModFile() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationFile getExclusiveModFile() {
        if (this.exclusiveModFile != null) {
            return this.exclusiveModFile;
        }
        TsFileResource tsFileResource = this;
        synchronized (tsFileResource) {
            if (this.exclusiveModFile == null) {
                if (this.exclusiveModFileFuture != null) {
                    try {
                        this.exclusiveModFile = this.exclusiveModFileFuture.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.warn("Upgrading mod file interrupted", (Throwable)e);
                        this.exclusiveModFile = ModificationFile.getExclusiveMods(this);
                    }
                    catch (ExecutionException e) {
                        LOGGER.warn("Cannot upgrade mod file", (Throwable)e);
                        this.exclusiveModFile = ModificationFile.getExclusiveMods(this);
                    }
                } else {
                    this.exclusiveModFile = ModificationFile.getExclusiveMods(this);
                }
            }
        }
        return this.exclusiveModFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationFile getCompactionModFile() {
        if (this.compactionModFile == null) {
            TsFileResource tsFileResource = this;
            synchronized (tsFileResource) {
                if (this.compactionModFile == null) {
                    this.compactionModFile = ModificationFile.getCompactionMods(this);
                }
            }
        }
        return this.compactionModFile;
    }

    public void removeCompactionModFile() throws IOException {
        if (this.compactionModFileExists()) {
            this.getCompactionModFile().remove();
        }
        this.compactionModFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void resetModFile() throws IOException {
        if (this.exclusiveModFile != null) {
            TsFileResource tsFileResource = this;
            synchronized (tsFileResource) {
                this.exclusiveModFile.close();
                this.exclusiveModFile = null;
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
        this.tsFileID = new TsFileID(file.getAbsolutePath());
    }

    public File getTsFile() {
        return this.file;
    }

    public String getTsFilePath() {
        return this.file.getPath();
    }

    public void increaseTierLevel() {
        this.tierLevel.addAndGet(1);
    }

    public int getTierLevel() {
        return this.tierLevel.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTsFileSize() {
        if (this.isClosed()) {
            if (this.tsFileSize == -1L) {
                TsFileResource tsFileResource = this;
                synchronized (tsFileResource) {
                    if (this.tsFileSize == -1L) {
                        this.tsFileSize = this.file.length();
                    }
                }
            }
            return this.tsFileSize;
        }
        return this.file.length();
    }

    public Optional<Long> getStartTime(IDeviceID deviceId) {
        try {
            return deviceId == null ? Optional.of(this.getFileStartTime()) : this.timeIndex.getStartTime(deviceId);
        }
        catch (Exception e) {
            LOGGER.error("meet error when getStartTime of {} in file {}", new Object[]{deviceId, this.file.getAbsolutePath(), e});
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("TimeIndex = {}", (Object)this.timeIndex);
            }
            throw e;
        }
    }

    public Optional<Long> getEndTime(IDeviceID deviceId) {
        try {
            return deviceId == null ? Optional.of(this.getFileEndTime()) : this.timeIndex.getEndTime(deviceId);
        }
        catch (Exception e) {
            LOGGER.error("meet error when getEndTime of {} in file {}", new Object[]{deviceId, this.file.getAbsolutePath(), e});
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("TimeIndex = {}", (Object)this.timeIndex);
            }
            throw e;
        }
    }

    public long getOrderTimeForSeq(IDeviceID deviceId, boolean ascending) {
        if (this.timeIndex instanceof ArrayDeviceTimeIndex) {
            return ascending ? this.timeIndex.getStartTime(deviceId).orElse(Long.MIN_VALUE) : this.timeIndex.getEndTime(deviceId).orElse(Long.MAX_VALUE);
        }
        return ascending ? Long.MIN_VALUE : Long.MAX_VALUE;
    }

    public long getOrderTimeForUnseq(IDeviceID deviceId, boolean ascending) {
        if (this.timeIndex instanceof ArrayDeviceTimeIndex) {
            if (ascending) {
                return this.timeIndex.getStartTime(deviceId).orElse(Long.MIN_VALUE);
            }
            return this.timeIndex.getEndTime(deviceId).orElse(Long.MAX_VALUE);
        }
        return ascending ? this.getFileStartTime() : this.getFileEndTime();
    }

    public long getFileStartTime() {
        return this.timeIndex.getMinStartTime();
    }

    public long getFileEndTime() {
        return this.timeIndex.getMaxEndTime();
    }

    public Set<IDeviceID> getDevices() {
        return this.timeIndex.getDevices(this.file.getPath(), this);
    }

    public ArrayDeviceTimeIndex buildDeviceTimeIndex() throws IOException {
        this.readLock();
        try {
            ArrayDeviceTimeIndex arrayDeviceTimeIndex;
            block14: {
                if (!this.resourceFileExists()) {
                    throw new IOException("resource file not found");
                }
                BufferedInputStream inputStream = FSFactoryProducer.getFSFactory().getBufferedInputStream(this.file.getPath() + RESOURCE_SUFFIX);
                try {
                    ReadWriteIOUtils.readByte((InputStream)inputStream);
                    ITimeIndex timeIndexFromResourceFile = ITimeIndex.createTimeIndex(inputStream);
                    if (!(timeIndexFromResourceFile instanceof ArrayDeviceTimeIndex)) {
                        throw new IOException("cannot build DeviceTimeIndex from resource " + this.file.getPath());
                    }
                    arrayDeviceTimeIndex = (ArrayDeviceTimeIndex)timeIndexFromResourceFile;
                    if (inputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IOException("Can't read file " + this.file.getPath() + RESOURCE_SUFFIX + " from disk", e);
                    }
                }
                ((InputStream)inputStream).close();
            }
            return arrayDeviceTimeIndex;
        }
        finally {
            this.readUnlock();
        }
    }

    public ITimeIndex getTimeIndex() {
        return this.timeIndex;
    }

    public boolean definitelyNotContains(IDeviceID device) {
        return this.timeIndex.definitelyNotContains(device);
    }

    public Pair<Long, Long> getPossibleStartTimeAndEndTime(PartialPath devicePattern, Set<IDeviceID> deviceMatchInfo) {
        return this.timeIndex.getPossibleStartTimeAndEndTime(devicePattern, deviceMatchInfo);
    }

    public boolean isClosed() {
        return this.getStatus() != TsFileResourceStatus.UNCLOSED;
    }

    public void close() throws IOException {
        this.setStatus(TsFileResourceStatus.NORMAL);
        this.closeWithoutSettingStatus();
    }

    public void closeWithoutSettingStatus() throws IOException {
        if (this.exclusiveModFile != null) {
            this.exclusiveModFile.close();
            this.exclusiveModFile = null;
        }
        if (this.compactionModFile != null) {
            this.compactionModFile.close();
            this.compactionModFile = null;
        }
        this.processor = null;
        this.pathToChunkMetadataListMap = null;
        this.pathToReadOnlyMemChunkMap = null;
        this.pathToTimeSeriesMetadataMap = null;
        this.timeIndex.close();
    }

    public TsFileProcessor getProcessor() {
        return this.processor;
    }

    public boolean isGeneratedByPipeConsensus() {
        return this.isGeneratedByPipeConsensus;
    }

    public void setGeneratedByPipeConsensus(boolean generatedByPipeConsensus) {
        this.isGeneratedByPipeConsensus = generatedByPipeConsensus;
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public void setGeneratedByPipe(boolean generatedByPipe) {
        this.isGeneratedByPipe = generatedByPipe;
    }

    public void writeLock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.writeLock();
        } else {
            this.originTsFileResource.writeLock();
        }
    }

    public void writeUnlock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.writeUnlock();
        } else {
            this.originTsFileResource.writeUnlock();
        }
    }

    public void readLock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.readLock();
        } else {
            this.originTsFileResource.readLock();
        }
    }

    public void readUnlock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.readUnlock();
        } else {
            this.originTsFileResource.readUnlock();
        }
    }

    public boolean tryWriteLock() {
        return this.tsFileLock.tryWriteLock();
    }

    public boolean tryReadLock() {
        return this.tsFileLock.tryReadLock();
    }

    public void removeModFile() throws IOException {
        if (this.getExclusiveModFile().exists()) {
            this.getExclusiveModFile().remove();
        }
        if (this.getSharedModFile() != null && this.modFileManagement != null) {
            this.modFileManagement.releaseFor(this, this.sharedModFile);
        }
        this.removeCompactionModFile();
    }

    public boolean remove() {
        this.forceMarkDeleted();
        try {
            this.fsFactory.deleteIfExists(this.file);
            this.fsFactory.deleteIfExists(new File(this.file.getAbsolutePath() + ".meta"));
        }
        catch (IOException e) {
            LOGGER.error("TsFile {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        if (!this.removeResourceFile()) {
            return false;
        }
        try {
            this.removeModFile();
        }
        catch (IOException e) {
            LOGGER.error("ModificationFile {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean removeResourceFile() {
        try {
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX));
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX + TEMP_SUFFIX));
        }
        catch (IOException e) {
            LOGGER.error("TsFileResource {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public void moveTo(File targetDir) throws IOException {
        this.fsFactory.moveFile(this.file, this.fsFactory.getFile(targetDir, this.file.getName()));
        this.fsFactory.moveFile(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX), this.fsFactory.getFile(targetDir, this.file.getName() + RESOURCE_SUFFIX));
        if (this.exclusiveModFileExists()) {
            this.fsFactory.moveFile(this.getExclusiveModFile().getFile(), this.fsFactory.getFile(targetDir, ModificationFile.getExclusiveMods(this.file).getName()));
        }
    }

    public String toString() {
        return String.format("{file: %s, status: %s}", new Object[]{this.file.toString(), this.getStatus()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFileResource that = (TsFileResource)o;
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public boolean isDeleted() {
        return this.getStatus() == TsFileResourceStatus.DELETED;
    }

    public boolean isCompacting() {
        return this.getStatus() == TsFileResourceStatus.COMPACTING;
    }

    public boolean isCompactionCandidate() {
        return this.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE;
    }

    public boolean onRemote() {
        return !this.isDeleted() && !this.file.exists();
    }

    private boolean compareAndSetStatus(TsFileResourceStatus expectedValue, TsFileResourceStatus newValue) {
        return this.atomicStatus.compareAndSet(expectedValue, newValue);
    }

    private void setAtomicStatus(TsFileResourceStatus status) {
        this.atomicStatus.set(status);
    }

    @TestOnly
    public void setStatusForTest(TsFileResourceStatus status) {
        this.setAtomicStatus(status);
    }

    public boolean setStatus(TsFileResourceStatus status) {
        if (status == this.getStatus()) {
            return true;
        }
        return this.transformStatus(status);
    }

    public boolean transformStatus(TsFileResourceStatus status) {
        switch (status) {
            case NORMAL: {
                return this.compareAndSetStatus(TsFileResourceStatus.UNCLOSED, TsFileResourceStatus.NORMAL) || this.compareAndSetStatus(TsFileResourceStatus.COMPACTING, TsFileResourceStatus.NORMAL) || this.compareAndSetStatus(TsFileResourceStatus.COMPACTION_CANDIDATE, TsFileResourceStatus.NORMAL);
            }
            case UNCLOSED: {
                return false;
            }
            case DELETED: {
                return this.compareAndSetStatus(TsFileResourceStatus.NORMAL, TsFileResourceStatus.DELETED) || this.compareAndSetStatus(TsFileResourceStatus.COMPACTION_CANDIDATE, TsFileResourceStatus.DELETED);
            }
            case COMPACTING: {
                return this.compareAndSetStatus(TsFileResourceStatus.COMPACTION_CANDIDATE, TsFileResourceStatus.COMPACTING);
            }
            case COMPACTION_CANDIDATE: {
                return this.compareAndSetStatus(TsFileResourceStatus.NORMAL, TsFileResourceStatus.COMPACTION_CANDIDATE);
            }
        }
        return false;
    }

    public TsFileRepairStatus getTsFileRepairStatus() {
        return this.tsFileRepairStatus;
    }

    public void setTsFileRepairStatus(TsFileRepairStatus fileRepairStatus) {
        this.tsFileRepairStatus = fileRepairStatus;
    }

    public void forceMarkDeleted() {
        this.atomicStatus.set(TsFileResourceStatus.DELETED);
    }

    public TsFileResourceStatus getStatus() {
        return this.atomicStatus.get();
    }

    public boolean stillLives(long timeLowerBound) {
        return !this.isClosed() || this.timeIndex.stillLives(timeLowerBound);
    }

    public boolean isDeviceIdExist(IDeviceID deviceId) {
        return this.timeIndex.checkDeviceIdExist(deviceId);
    }

    public boolean isSatisfied(IDeviceID deviceId, Filter timeFilter, boolean isSeq, boolean debug) {
        if (deviceId != null && this.definitelyNotContains(deviceId)) {
            if (debug) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of no device!", (Object)deviceId, (Object)this.file);
            }
            return false;
        }
        if (timeFilter != null) {
            long endTime;
            long startTime = this.getStartTime(deviceId).get();
            long l = endTime = this.isClosed() || !isSeq ? this.getEndTime(deviceId).get() : Long.MAX_VALUE;
            if (startTime > endTime) {
                LOGGER.warn("startTime[{}] of TsFileResource[{}] is greater than its endTime[{}]", new Object[]{startTime, this, endTime});
                return false;
            }
            boolean res = timeFilter.satisfyStartEndTime(startTime, endTime);
            if (debug && !res) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of time filter!", deviceId != null ? deviceId : "", (Object)this.fsFactory);
            }
            return res;
        }
        return true;
    }

    private boolean isAlive(long time, long dataTTL) {
        return dataTTL == Long.MAX_VALUE || CommonDateTimeUtils.currentTime() - time <= dataTTL;
    }

    public boolean isDeviceAlive(IDeviceID device, long ttl) {
        if (this.definitelyNotContains(device)) {
            return false;
        }
        return !this.isClosed() || this.timeIndex.isDeviceAlive(device, ttl);
    }

    public void setProcessor(TsFileProcessor processor) {
        this.processor = processor;
    }

    public ITimeSeriesMetadata getTimeSeriesMetadata(IFullPath seriesPath) throws IOException {
        try {
            return this.pathToTimeSeriesMetadataMap.computeIfAbsent(seriesPath, k -> {
                if (this.pathToChunkMetadataListMap.containsKey(k)) {
                    try {
                        return ResourceByPathUtils.getResourceInstance(seriesPath).generateTimeSeriesMetadata(this.pathToReadOnlyMemChunkMap.get(seriesPath), this.pathToChunkMetadataListMap.get(seriesPath));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return null;
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public DataRegion.SettleTsFileCallBack getSettleTsFileCallBack() {
        return this.settleTsFileCallBack;
    }

    public void setSettleTsFileCallBack(DataRegion.SettleTsFileCallBack settleTsFileCallBack) {
        this.settleTsFileCallBack = settleTsFileCallBack;
    }

    public long getTimePartition() {
        return this.tsFileID.timePartitionId;
    }

    public long getTimePartitionWithCheck() throws PartitionViolationException {
        return this.timeIndex.getTimePartitionWithCheck(this.file.toString());
    }

    public boolean isSpanMultiTimePartitions() {
        return this.timeIndex.isSpanMultiTimePartitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExclusiveModFile(ModificationFile exclusiveModFile) {
        TsFileResource tsFileResource = this;
        synchronized (tsFileResource) {
            this.exclusiveModFile = exclusiveModFile;
        }
    }

    public long calculateRamSize() {
        if (this.timeIndex.getTimeIndexType() == 2) {
            return INSTANCE_SIZE + this.timeIndex.calculateRamSize();
        }
        if (this.deviceTimeIndexRamSize == 0L) {
            this.deviceTimeIndexRamSize = this.timeIndex.calculateRamSize();
        }
        return INSTANCE_SIZE + this.deviceTimeIndexRamSize;
    }

    public Optional<Long> getDeviceTimeIndexRamSize() {
        if (!this.isClosed()) {
            return Optional.empty();
        }
        return Optional.of(this.deviceTimeIndexRamSize);
    }

    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    public void updatePlanIndexes(long planIndex) {
        if (planIndex == Long.MIN_VALUE || planIndex == Long.MAX_VALUE) {
            return;
        }
        if (planIndex < this.minPlanIndex || planIndex > this.maxPlanIndex) {
            this.maxPlanIndex = Math.max(this.maxPlanIndex, planIndex);
            this.minPlanIndex = Math.min(this.minPlanIndex, planIndex);
            if (this.isClosed()) {
                try {
                    this.serialize();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot serialize TsFileResource {} when updating plan index {}-{}", new Object[]{this, this.maxPlanIndex, planIndex});
                }
            }
        }
    }

    public static int getInnerCompactionCount(String fileName) throws IOException {
        TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(fileName);
        return tsFileName.getInnerCompactionCnt();
    }

    public void updatePlanIndexes(TsFileResource another) {
        this.maxPlanIndex = Math.max(this.maxPlanIndex, another.maxPlanIndex);
        this.minPlanIndex = Math.min(this.minPlanIndex, another.minPlanIndex);
    }

    public boolean isPlanIndexOverlap(TsFileResource another) {
        return another.maxPlanIndex > this.minPlanIndex && another.minPlanIndex < this.maxPlanIndex;
    }

    public boolean isPlanRangeCovers(TsFileResource another) {
        return this.minPlanIndex < another.minPlanIndex && another.maxPlanIndex < this.maxPlanIndex;
    }

    public void setMaxPlanIndex(long maxPlanIndex) {
        this.maxPlanIndex = maxPlanIndex;
    }

    public void setMinPlanIndex(long minPlanIndex) {
        this.minPlanIndex = minPlanIndex;
    }

    public void setVersion(long version) {
        this.tsFileID = new TsFileID(this.tsFileID.regionId, this.tsFileID.timePartitionId, this.tsFileID.timestamp, version, this.tsFileID.compactionVersion);
    }

    public long getVersion() {
        return this.tsFileID.fileVersion;
    }

    public TsFileID getTsFileID() {
        return this.tsFileID;
    }

    public void setTimeIndex(ITimeIndex timeIndex) {
        this.timeIndex = timeIndex;
    }

    public static int compareFileName(TsFileResource o1, TsFileResource o2) {
        long ver2;
        String[] items1 = o1.getTsFile().getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getTsFile().getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            int cmpVersion = Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
            if (cmpVersion == 0) {
                int cmpInnerCompact = Long.compare(Long.parseLong(items1[2]), Long.parseLong(items2[2]));
                if (cmpInnerCompact == 0) {
                    return Long.compare(Long.parseLong(items1[3]), Long.parseLong(items2[3]));
                }
                return cmpInnerCompact;
            }
            return cmpVersion;
        }
        return cmp;
    }

    public static int checkAndCompareFileName(String fileName1, String fileName2) throws IOException {
        TsFileNameGenerator.TsFileName tsFileName1 = TsFileNameGenerator.getTsFileName(fileName1);
        TsFileNameGenerator.TsFileName tsFileName2 = TsFileNameGenerator.getTsFileName(fileName2);
        long timeDiff = tsFileName1.getTime() - tsFileName2.getTime();
        if (timeDiff != 0L) {
            return timeDiff < 0L ? -1 : 1;
        }
        long versionDiff = tsFileName1.getVersion() - tsFileName2.getVersion();
        if (versionDiff != 0L) {
            return versionDiff < 0L ? -1 : 1;
        }
        return 0;
    }

    public static int compareFileCreationOrderByDesc(TsFileResource o1, TsFileResource o2) {
        try {
            TsFileNameGenerator.TsFileName n1 = TsFileNameGenerator.getTsFileName(o1.getTsFile().getName());
            TsFileNameGenerator.TsFileName n2 = TsFileNameGenerator.getTsFileName(o2.getTsFile().getName());
            long versionDiff = n2.getVersion() - n1.getVersion();
            if (versionDiff != 0L) {
                return versionDiff < 0L ? -1 : 1;
            }
            return 0;
        }
        catch (IOException e) {
            LOGGER.error("File name may not meet the standard naming specifications.", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setSeq(boolean seq) {
        this.isSeq = seq;
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public int compareIndexDegradePriority(TsFileResource tsFileResource) {
        int cmp = this.timeIndex.compareDegradePriority(tsFileResource.timeIndex);
        return cmp == 0 ? this.file.getAbsolutePath().compareTo(tsFileResource.file.getAbsolutePath()) : cmp;
    }

    public byte getTimeIndexType() {
        return this.timeIndex.getTimeIndexType();
    }

    @TestOnly
    public void setTimeIndexType(byte type) {
        switch (type) {
            case 3: {
                this.timeIndex = new ArrayDeviceTimeIndex();
                break;
            }
            case 2: {
                this.timeIndex = new FileTimeIndex();
                break;
            }
            case 1: {
                this.timeIndex = new PlainDeviceTimeIndex();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public long degradeTimeIndex() {
        TimeIndexLevel timeIndexLevel = TimeIndexLevel.valueOf(this.getTimeIndexType());
        if (timeIndexLevel == TimeIndexLevel.FILE_TIME_INDEX) {
            return 0L;
        }
        long startTime = this.timeIndex.getMinStartTime();
        long endTime = this.timeIndex.getMaxEndTime();
        this.timeIndex = new FileTimeIndex(startTime, endTime);
        return this.deviceTimeIndexRamSize - this.timeIndex.calculateRamSize();
    }

    public void deleteRemovedDeviceAndUpdateEndTime(Map<IDeviceID, Long> lastTimeForEachDevice) {
        ITimeIndex newTimeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        for (Map.Entry<IDeviceID, Long> entry : lastTimeForEachDevice.entrySet()) {
            this.timeIndex.getStartTime(entry.getKey()).ifPresent(startTime -> {
                newTimeIndex.updateStartTime((IDeviceID)entry.getKey(), (long)startTime);
                newTimeIndex.updateEndTime((IDeviceID)entry.getKey(), (Long)entry.getValue());
            });
        }
        this.timeIndex = newTimeIndex;
    }

    public void updateEndTime(Map<IDeviceID, Long> lastTimeForEachDevice) {
        for (Map.Entry<IDeviceID, Long> entry : lastTimeForEachDevice.entrySet()) {
            this.timeIndex.updateEndTime(entry.getKey(), entry.getValue());
        }
    }

    public boolean isFileInList() {
        return this.prev != null || this.next != null;
    }

    public void updateProgressIndex(ProgressIndex progressIndex) {
        if (progressIndex == null) {
            return;
        }
        this.maxProgressIndex = this.maxProgressIndex == null ? progressIndex : this.maxProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex(progressIndex);
        PipeTimePartitionProgressIndexKeeper.getInstance().updateProgressIndex(this.getDataRegionId(), this.getTimePartition(), this.maxProgressIndex);
    }

    public void setProgressIndex(ProgressIndex progressIndex) {
        if (progressIndex == null) {
            return;
        }
        this.maxProgressIndex = progressIndex;
        PipeTimePartitionProgressIndexKeeper.getInstance().updateProgressIndex(this.getDataRegionId(), this.getTimePartition(), this.maxProgressIndex);
    }

    public ProgressIndex getProgressIndex() {
        return this.getMaxProgressIndex();
    }

    public ProgressIndex getMaxProgressIndexAfterClose() throws IllegalStateException {
        if (this.getStatus().equals((Object)TsFileResourceStatus.UNCLOSED)) {
            throw new IllegalStateException("Should not get progress index from a unclosing TsFileResource.");
        }
        return this.getMaxProgressIndex();
    }

    public ProgressIndex getMaxProgressIndex() {
        return this.maxProgressIndex == null ? MinimumProgressIndex.INSTANCE : this.maxProgressIndex;
    }

    public boolean isEmpty() {
        return this.getFileStartTime() == Long.MAX_VALUE && this.getFileEndTime() == Long.MIN_VALUE;
    }

    public String getDatabaseName() {
        return this.file.getParentFile().getParentFile().getParentFile().getName();
    }

    public String getDataRegionId() {
        return this.file.getParentFile().getParentFile().getName();
    }

    public boolean isInsertionCompactionTaskCandidate() {
        return !this.isSeq && this.insertionCompactionCandidateStatus != InsertionCompactionCandidateStatus.NOT_VALID;
    }

    public InsertionCompactionCandidateStatus getInsertionCompactionCandidateStatus() {
        return this.insertionCompactionCandidateStatus;
    }

    public void setInsertionCompactionTaskCandidate(InsertionCompactionCandidateStatus status) {
        this.insertionCompactionCandidateStatus = status;
    }

    public ModIterator getModEntryIterator() {
        return new ModIterator();
    }

    public Collection<ModEntry> getAllModEntries() {
        long estimatedModEntrySizeByte = 50L;
        long modFileTotalSize = this.getTotalModSizeInByte();
        if (modFileTotalSize == 0L) {
            return Collections.emptyList();
        }
        ArrayList<ModEntry> entries = new ArrayList<ModEntry>((int)(modFileTotalSize / estimatedModEntrySizeByte + 1L));
        ModIterator modEntryIterator = this.getModEntryIterator();
        modEntryIterator.forEachRemaining(entries::add);
        return entries;
    }

    public void upgradeModFile(ExecutorService upgradeModFileThreadPool) throws IOException {
        ModificationFileV1 oldModFile = ModificationFileV1.getNormalMods(this);
        if (!oldModFile.exists()) {
            return;
        }
        this.exclusiveModFileFuture = upgradeModFileThreadPool != null ? upgradeModFileThreadPool.submit(() -> this.doUpgradeModFile(oldModFile)) : CompletableFuture.completedFuture(this.doUpgradeModFile(oldModFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModificationFile doUpgradeModFile(ModificationFileV1 oldModFile) throws IOException {
        ModificationFile newMFile = ModificationFile.getExclusiveMods(this);
        newMFile.getFile().delete();
        try {
            for (Modification oldMod : oldModFile.getModifications()) {
                newMFile.write(new TreeDeletionEntry((Deletion)oldMod));
            }
        }
        finally {
            newMFile.close();
        }
        oldModFile.remove();
        return newMFile;
    }

    public TsFileResource getPrev() {
        return this.prev;
    }

    public TsFileResource getNext() {
        return this.next;
    }

    public void setSharedModFilePathFuture(CompletableFuture<String> sharedModFilePathFuture) {
        this.sharedModFilePathFuture = sharedModFilePathFuture;
    }

    public boolean isUseSharedModFile() {
        return false;
    }

    public void setModFileManagement(ModFileManagement modFileManagement) {
        this.modFileManagement = modFileManagement;
    }

    public ModFileManagement getModFileManagement() {
        return this.modFileManagement;
    }

    public void setCompactionModFile(ModificationFile compactionModFile) {
        this.compactionModFile = compactionModFile;
    }

    public class ModIterator
    implements Iterator<ModEntry> {
        private final Iterator<ModEntry> sharedModIterator;
        private final Iterator<ModEntry> exclusiveModIterator;

        public ModIterator() {
            Iterator<ModEntry> exclusiveIterator = null;
            try {
                ModificationFile newMFile = TsFileResource.this.getExclusiveModFile();
                exclusiveIterator = newMFile != null ? newMFile.getModIterator(0L) : null;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read mods from {} for {}", new Object[]{TsFileResource.this.exclusiveModFile, this, e});
            }
            this.exclusiveModIterator = exclusiveIterator;
            Iterator<ModEntry> sharedIterator = null;
            try {
                sharedIterator = TsFileResource.this.getSharedModFile() != null ? TsFileResource.this.sharedModFile.getModIterator(TsFileResource.this.sharedModFileOffset) : null;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read mods from {} for {}", new Object[]{TsFileResource.this.exclusiveModFile, this, e});
            }
            this.sharedModIterator = sharedIterator;
        }

        @Override
        public boolean hasNext() {
            return this.exclusiveModIterator != null && this.exclusiveModIterator.hasNext() || this.sharedModIterator != null && this.sharedModIterator.hasNext();
        }

        @Override
        public ModEntry next() {
            if (this.exclusiveModIterator != null && this.exclusiveModIterator.hasNext()) {
                return this.exclusiveModIterator.next();
            }
            if (this.sharedModIterator != null && this.sharedModIterator.hasNext()) {
                return this.sharedModIterator.next();
            }
            throw new NoSuchElementException();
        }
    }
}

