/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ColumnDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class AddColumn
extends Statement {
    private final QualifiedName tableName;
    private final ColumnDefinition column;
    private final boolean tableIfExists;
    private final boolean columnIfNotExists;

    public AddColumn(QualifiedName tableName, ColumnDefinition column, boolean tableIfExists, boolean columnIfNotExists) {
        super(null);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.column = Objects.requireNonNull(column, "column is null");
        this.tableIfExists = tableIfExists;
        this.columnIfNotExists = columnIfNotExists;
    }

    public AddColumn(NodeLocation location, QualifiedName tableName, ColumnDefinition column, boolean tableIfExists, boolean columnIfNotExists) {
        super(Objects.requireNonNull(location, "location is null"));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.column = Objects.requireNonNull(column, "column is null");
        this.tableIfExists = tableIfExists;
        this.columnIfNotExists = columnIfNotExists;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public ColumnDefinition getColumn() {
        return this.column;
    }

    public boolean tableIfExists() {
        return this.tableIfExists;
    }

    public boolean columnIfNotExists() {
        return this.columnIfNotExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAddColumn(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return Collections.singletonList(this.column);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.column, this.tableIfExists, this.columnIfNotExists);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddColumn that = (AddColumn)o;
        return this.tableIfExists == that.tableIfExists && this.columnIfNotExists == that.columnIfNotExists && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.column, that.column);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("column", (Object)this.column).add("tableIfExists", this.tableIfExists).add("columnIfNotExists", this.columnIfNotExists).toString();
    }
}

