/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.load;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.LoadAnalyzeException;
import org.apache.iotdb.db.exception.load.LoadAnalyzeTypeMismatchException;
import org.apache.iotdb.db.exception.load.LoadEmptyFileException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.load.LoadTsFileTableSchemaCache;
import org.apache.iotdb.db.queryengine.plan.analyze.load.TreeSchemaAutoCreatorAndVerifier;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.TableConfigTaskVisitor;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateDBTask;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.db.storageengine.load.converter.LoadTsFileDataTypeConverter;
import org.apache.iotdb.db.storageengine.load.metrics.LoadTsFileCostMetricsSet;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.TsFileSequenceReaderTimeseriesMetadataIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileAnalyzer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileAnalyzer.class);
    private static final LoadTsFileCostMetricsSet LOAD_TSFILE_COST_METRICS_SET = LoadTsFileCostMetricsSet.getInstance();
    final IPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
    final ISchemaFetcher schemaFetcher = ClusterSchemaFetcher.getInstance();
    private final Metadata metadata;
    private final AccessControl accessControl;
    final MPPQueryContext context;
    private final LoadTsFileStatement loadTsFileTreeStatement;
    private final LoadTsFile loadTsFileTableStatement;
    private final boolean isTableModelStatement;
    private final String statementString;
    private final boolean isGeneratedByPipe;
    private final List<File> tsFiles;
    private final List<Boolean> isMiniTsFile;
    private boolean isMiniTsFileConverted;
    private final List<Boolean> isTableModelTsFile;
    private int isTableModelTsFileReliableIndex;
    private final int databaseLevel;
    private String databaseForTableData;
    private final boolean isAsyncLoad;
    private final boolean isVerifySchema;
    private final boolean isAutoCreateDatabase;
    private final boolean isDeleteAfterLoad;
    private final boolean isConvertOnTypeMismatch;
    private final long tabletConversionThresholdBytes;
    private TreeSchemaAutoCreatorAndVerifier treeSchemaAutoCreatorAndVerifier;
    private LoadTsFileTableSchemaCache tableSchemaCache;

    public LoadTsFileAnalyzer(LoadTsFileStatement loadTsFileStatement, boolean isGeneratedByPipe, MPPQueryContext context) {
        this.metadata = LocalExecutionPlanner.getInstance().metadata;
        this.accessControl = Coordinator.getInstance().getAccessControl();
        this.isMiniTsFileConverted = false;
        this.isTableModelTsFileReliableIndex = -1;
        this.context = context;
        this.loadTsFileTreeStatement = loadTsFileStatement;
        this.loadTsFileTableStatement = null;
        this.isTableModelStatement = false;
        this.statementString = loadTsFileStatement.toString();
        this.isGeneratedByPipe = isGeneratedByPipe;
        this.tsFiles = loadTsFileStatement.getTsFiles();
        this.isMiniTsFile = new ArrayList<Boolean>(Collections.nCopies(this.tsFiles.size(), false));
        this.isTableModelTsFile = new ArrayList<Boolean>(Collections.nCopies(this.tsFiles.size(), false));
        this.databaseLevel = loadTsFileStatement.getDatabaseLevel();
        this.databaseForTableData = loadTsFileStatement.getDatabase();
        this.isAsyncLoad = loadTsFileStatement.isAsyncLoad();
        this.isVerifySchema = loadTsFileStatement.isVerifySchema();
        this.isAutoCreateDatabase = loadTsFileStatement.isAutoCreateDatabase();
        this.isDeleteAfterLoad = loadTsFileStatement.isDeleteAfterLoad();
        this.isConvertOnTypeMismatch = loadTsFileStatement.isConvertOnTypeMismatch();
        this.tabletConversionThresholdBytes = loadTsFileStatement.getTabletConversionThresholdBytes();
    }

    public LoadTsFileAnalyzer(LoadTsFile loadTsFileTableStatement, boolean isGeneratedByPipe, MPPQueryContext context) {
        this.metadata = LocalExecutionPlanner.getInstance().metadata;
        this.accessControl = Coordinator.getInstance().getAccessControl();
        this.isMiniTsFileConverted = false;
        this.isTableModelTsFileReliableIndex = -1;
        this.context = context;
        this.loadTsFileTreeStatement = null;
        this.loadTsFileTableStatement = loadTsFileTableStatement;
        this.isTableModelStatement = true;
        this.statementString = loadTsFileTableStatement.toString();
        this.isGeneratedByPipe = isGeneratedByPipe;
        this.tsFiles = loadTsFileTableStatement.getTsFiles();
        this.isMiniTsFile = new ArrayList<Boolean>(Collections.nCopies(this.tsFiles.size(), false));
        this.isTableModelTsFile = new ArrayList<Boolean>(Collections.nCopies(this.tsFiles.size(), false));
        this.databaseLevel = loadTsFileTableStatement.getDatabaseLevel();
        this.databaseForTableData = loadTsFileTableStatement.getDatabase();
        this.isAsyncLoad = loadTsFileTableStatement.isAsyncLoad();
        this.isVerifySchema = loadTsFileTableStatement.isVerifySchema();
        this.isAutoCreateDatabase = loadTsFileTableStatement.isAutoCreateDatabase();
        this.isDeleteAfterLoad = loadTsFileTableStatement.isDeleteAfterLoad();
        this.isConvertOnTypeMismatch = loadTsFileTableStatement.isConvertOnTypeMismatch();
        this.tabletConversionThresholdBytes = loadTsFileTableStatement.getTabletConversionThresholdBytes();
    }

    protected String getStatementString() {
        return this.statementString;
    }

    protected int getDatabaseLevel() {
        return this.databaseLevel;
    }

    protected boolean isVerifySchema() {
        return this.isVerifySchema;
    }

    protected boolean isAutoCreateDatabase() {
        return this.isAutoCreateDatabase;
    }

    protected boolean isConvertOnTypeMismatch() {
        return this.isConvertOnTypeMismatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAnalysis analyzeFileByFile(IAnalysis analysis) {
        if (!this.checkBeforeAnalyzeFileByFile(analysis)) {
            return analysis;
        }
        if (this.isAsyncLoad && this.doAsyncLoad(analysis)) {
            return analysis;
        }
        try {
            if (!this.doAnalyzeFileByFile(analysis)) {
                return analysis;
            }
            long startTime = System.nanoTime();
            try {
                if (this.treeSchemaAutoCreatorAndVerifier != null) {
                    this.treeSchemaAutoCreatorAndVerifier.flush();
                }
            }
            finally {
                LoadTsFileCostMetricsSet.getInstance().recordPhaseTimeCost("analysis", System.nanoTime() - startTime);
            }
        }
        catch (AuthException e) {
            this.setFailAnalysisForAuthException(analysis, e);
            return analysis;
        }
        catch (LoadAnalyzeException e) {
            this.executeTabletConversionOnException(analysis, e);
            return analysis;
        }
        catch (Exception e) {
            String exceptionMessage = String.format("Auto create or verify schema error when executing statement %s. Detail: %s.", this.getStatementString(), e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            LOGGER.warn(exceptionMessage, (Throwable)e);
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)exceptionMessage));
            return analysis;
        }
        LOGGER.info("Load - Analysis Stage: all tsfiles have been analyzed.");
        this.setTsFileModelInfoToStatement();
        if (this.reconstructStatementIfMiniFileConverted()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            return analysis;
        }
        this.setRealStatement(analysis);
        return analysis;
    }

    private boolean checkBeforeAnalyzeFileByFile(IAnalysis analysis) {
        if (TSFileDescriptor.getInstance().getConfig().getEncryptFlag()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)"TSFile encryption is enabled, and the Load TSFile function is disabled"));
            return false;
        }
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY, (String)"Current system mode is read only, does not support load file"));
            return false;
        }
        return true;
    }

    private boolean doAsyncLoad(IAnalysis analysis) {
        int size;
        String[] loadActiveListeningDirs = IoTDBDescriptor.getInstance().getConfig().getLoadActiveListeningDirs();
        String targetFilePath = null;
        int n = size = loadActiveListeningDirs == null ? 0 : loadActiveListeningDirs.length;
        for (int i = 0; i < size; ++i) {
            if (loadActiveListeningDirs[i] == null) continue;
            targetFilePath = loadActiveListeningDirs[i];
            break;
        }
        if (targetFilePath == null) {
            LOGGER.warn("Load active listening dir is not set. Will try sync load instead.");
            return false;
        }
        try {
            if (Objects.nonNull(this.databaseForTableData)) {
                this.loadTsFilesAsyncToTargetDir(new File(targetFilePath, this.databaseForTableData), this.tsFiles);
            } else {
                this.loadTsFilesAsyncToTargetDir(new File(targetFilePath), this.tsFiles);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to async load tsfiles {} to target dir {}. Will try sync load instead.", new Object[]{this.tsFiles, targetFilePath, e});
            return false;
        }
        analysis.setFinishQueryAfterAnalyze(true);
        this.setRealStatement(analysis);
        return true;
    }

    private void loadTsFilesAsyncToTargetDir(File targetDir, List<File> files) throws IOException {
        for (File file : files) {
            if (file == null) continue;
            this.loadTsFileAsyncToTargetDir(targetDir, file);
            this.loadTsFileAsyncToTargetDir(targetDir, new File(file.getAbsolutePath() + ".resource"));
            this.loadTsFileAsyncToTargetDir(targetDir, new File(file.getAbsolutePath() + ".mods"));
        }
    }

    private void loadTsFileAsyncToTargetDir(File targetDir, File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        RetryUtils.retryOnException(() -> {
            if (this.isDeleteAfterLoad) {
                FileUtils.moveFileWithMD5Check((File)file, (File)targetDir);
            } else {
                FileUtils.copyFileWithMD5Check((File)file, (File)targetDir);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doAnalyzeFileByFile(IAnalysis analysis) {
        int tsfileNum = this.tsFiles.size();
        for (int i = 0; i < tsfileNum; ++i) {
            File tsFile = this.tsFiles.get(i);
            if (tsFile.length() == 0L) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("TsFile {} is empty.", (Object)tsFile.getPath());
                }
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Load - Analysis Stage: {}/{} tsfiles have been analyzed, progress: {}%", new Object[]{i + 1, tsfileNum, String.format("%.3f", (double)(i + 1) * 100.0 / (double)tsfileNum)});
                continue;
            }
            long startTime = System.nanoTime();
            try {
                this.analyzeSingleTsFile(tsFile, i);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Load - Analysis Stage: {}/{} tsfiles have been analyzed, progress: {}%", new Object[]{i + 1, tsfileNum, String.format("%.3f", (double)(i + 1) * 100.0 / (double)tsfileNum)});
                continue;
            }
            catch (AuthException e) {
                this.setFailAnalysisForAuthException(analysis, e);
                boolean bl = false;
                return bl;
            }
            catch (LoadAnalyzeException e) {
                this.executeTabletConversionOnException(analysis, e);
                boolean bl = false;
                return bl;
            }
            catch (BufferUnderflowException e) {
                LOGGER.warn("The file {} is not a valid tsfile. Please check the input file.", (Object)tsFile.getPath(), (Object)e);
                throw new SemanticException(String.format("The file %s is not a valid tsfile. Please check the input file.", tsFile.getPath()));
            }
            catch (Exception e) {
                String exceptionMessage = String.format("Loading file %s failed. Detail: %s", tsFile.getPath(), e.getMessage() == null ? e.getClass().getName() : e.getMessage());
                LOGGER.warn(exceptionMessage, (Throwable)e);
                analysis.setFinishQueryAfterAnalyze(true);
                analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)exceptionMessage));
                boolean bl = false;
                return bl;
            }
            finally {
                LoadTsFileCostMetricsSet.getInstance().recordPhaseTimeCost("analysis", System.nanoTime() - startTime);
            }
        }
        return true;
    }

    private void analyzeSingleTsFile(File tsFile, int i) throws Exception {
        block13: {
            try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());){
                Map tableSchemaMap = reader.getTableSchemaMap();
                boolean isTableModelFile = Objects.nonNull(tableSchemaMap) && !tableSchemaMap.isEmpty();
                LOGGER.info("TsFile {} is a {}-model file.", (Object)tsFile.getPath(), (Object)(isTableModelFile ? "table" : "tree"));
                TsFileSequenceReaderTimeseriesMetadataIterator timeseriesMetadataIterator = new TsFileSequenceReaderTimeseriesMetadataIterator(reader, !isTableModelFile, IoTDBDescriptor.getInstance().getConfig().getLoadTsFileAnalyzeSchemaBatchReadTimeSeriesMetadataCount());
                if (!timeseriesMetadataIterator.hasNext()) {
                    throw new LoadEmptyFileException(tsFile.getAbsolutePath());
                }
                EncryptParameter param = reader.getEncryptParam();
                if (!Objects.equals(param.getType(), EncryptUtils.getEncryptParameter().getType()) || !Arrays.equals(param.getKey(), EncryptUtils.getEncryptParameter().getKey())) {
                    throw new SemanticException("The encryption way of the TsFile is not supported.");
                }
                this.isTableModelTsFile.set(i, isTableModelFile);
                this.isTableModelTsFileReliableIndex = i;
                if (0L <= this.tabletConversionThresholdBytes && tsFile.length() <= this.tabletConversionThresholdBytes && this.handleSingleMiniFile(i)) {
                    return;
                }
                if (isTableModelFile) {
                    this.doAnalyzeSingleTableFile(tsFile, reader, timeseriesMetadataIterator, tableSchemaMap);
                } else {
                    this.doAnalyzeSingleTreeFile(tsFile, reader, timeseriesMetadataIterator);
                }
            }
            catch (LoadEmptyFileException loadEmptyFileException) {
                LOGGER.warn("Empty file detected, will skip loading this file: {}", (Object)tsFile.getAbsolutePath());
                if (!this.isDeleteAfterLoad) break block13;
                org.apache.commons.io.FileUtils.deleteQuietly((File)tsFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleSingleMiniFile(int i) throws FileNotFoundException {
        long startTime = System.nanoTime();
        try {
            TSStatus status;
            LoadTsFileDataTypeConverter loadTsFileDataTypeConverter = new LoadTsFileDataTypeConverter(this.isGeneratedByPipe);
            TSStatus tSStatus = status = this.isTableModelTsFile.get(i) != false ? (TSStatus)loadTsFileDataTypeConverter.convertForTableModel(new LoadTsFile(null, this.tsFiles.get(i).getPath(), Collections.emptyMap()).setDatabase(this.databaseForTableData).setDeleteAfterLoad(this.isDeleteAfterLoad).setConvertOnTypeMismatch(this.isConvertOnTypeMismatch)).orElse(null) : (TSStatus)loadTsFileDataTypeConverter.convertForTreeModel(new LoadTsFileStatement(this.tsFiles.get(i).getPath()).setDeleteAfterLoad(this.isDeleteAfterLoad).setConvertOnTypeMismatch(this.isConvertOnTypeMismatch)).orElse(null);
            if (status == null || !loadTsFileDataTypeConverter.isSuccessful(status)) {
                LOGGER.warn("Load: Failed to convert mini tsfile {} to tablets from statement {}. Status: {}.", new Object[]{this.tsFiles.get(i).getPath(), this.isTableModelStatement ? this.loadTsFileTableStatement : this.loadTsFileTreeStatement, status});
                boolean bl = false;
                return bl;
            }
            this.isMiniTsFile.set(i, Boolean.TRUE);
            this.isMiniTsFileConverted = true;
            this.addTsFileResource(null);
            this.addWritePointCount(0L);
            boolean bl = true;
            return bl;
        }
        finally {
            LOAD_TSFILE_COST_METRICS_SET.recordPhaseTimeCost("analysis_cast_tablets", System.nanoTime() - startTime);
        }
    }

    private void doAnalyzeSingleTreeFile(File tsFile, TsFileSequenceReader reader, TsFileSequenceReaderTimeseriesMetadataIterator timeseriesMetadataIterator) throws IOException, LoadAnalyzeException, AuthException {
        boolean isAutoCreateSchemaOrVerifySchemaEnabled;
        TsFileResource tsFileResource = this.constructTsFileResource(reader, tsFile);
        long writePointCount = 0L;
        this.getOrCreateTreeSchemaVerifier().setCurrentModificationsAndTimeIndex(tsFileResource, reader);
        boolean bl = isAutoCreateSchemaOrVerifySchemaEnabled = IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled() || this.isVerifySchema();
        while (timeseriesMetadataIterator.hasNext()) {
            Map device2TimeseriesMetadata = timeseriesMetadataIterator.next();
            if (isAutoCreateSchemaOrVerifySchemaEnabled) {
                this.getOrCreateTreeSchemaVerifier().autoCreateAndVerify(reader, device2TimeseriesMetadata);
            }
            if (!tsFileResource.resourceFileExists()) {
                TsFileResourceUtils.updateTsFileResource(device2TimeseriesMetadata, tsFileResource);
            }
            writePointCount += LoadTsFileAnalyzer.getWritePointCount(device2TimeseriesMetadata);
        }
        if (isAutoCreateSchemaOrVerifySchemaEnabled) {
            this.getOrCreateTreeSchemaVerifier().flushAndClearDeviceIsAlignedCacheIfNecessary();
        }
        TimestampPrecisionUtils.checkTimestampPrecision(tsFileResource.getFileEndTime());
        tsFileResource.setStatus(TsFileResourceStatus.NORMAL);
        this.addTsFileResource(tsFileResource);
        this.addWritePointCount(writePointCount);
    }

    private void doAnalyzeSingleTableFile(File tsFile, TsFileSequenceReader reader, TsFileSequenceReaderTimeseriesMetadataIterator timeseriesMetadataIterator, Map<String, TableSchema> tableSchemaMap) throws IOException, LoadAnalyzeException {
        TsFileResource tsFileResource = this.constructTsFileResource(reader, tsFile);
        long writePointCount = 0L;
        if (Objects.isNull(this.databaseForTableData)) {
            Optional<String> dbName = this.context.getDatabaseName();
            if (dbName.isPresent()) {
                this.databaseForTableData = dbName.get();
                if (this.isTableModelStatement) {
                    this.loadTsFileTableStatement.setDatabase(dbName.get());
                } else {
                    this.loadTsFileTreeStatement.setDatabase(dbName.get());
                }
            } else {
                throw new SemanticException("database is not specified");
            }
        }
        this.autoCreateTableDatabaseIfAbsent(this.databaseForTableData);
        this.getOrCreateTableSchemaCache().setDatabase(this.databaseForTableData);
        this.getOrCreateTableSchemaCache().setCurrentModificationsAndTimeIndex(tsFileResource, reader);
        for (Map.Entry entry : tableSchemaMap.entrySet()) {
            org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema fileSchema = org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema.fromTsFileTableSchema((String)entry.getKey(), (TableSchema)entry.getValue());
            this.getOrCreateTableSchemaCache().createTable(fileSchema, this.context, this.metadata);
            this.accessControl.checkCanInsertIntoTable(this.context.getSession().getUserName(), new QualifiedObjectName(this.databaseForTableData, (String)entry.getKey()));
        }
        while (timeseriesMetadataIterator.hasNext()) {
            Map device2TimeseriesMetadata = timeseriesMetadataIterator.next();
            for (IDeviceID deviceId : device2TimeseriesMetadata.keySet()) {
                this.getOrCreateTableSchemaCache().autoCreateAndVerify(deviceId);
            }
            if (!tsFileResource.resourceFileExists()) {
                TsFileResourceUtils.updateTsFileResource(device2TimeseriesMetadata, tsFileResource);
            }
            writePointCount += LoadTsFileAnalyzer.getWritePointCount(device2TimeseriesMetadata);
        }
        this.getOrCreateTableSchemaCache().flush();
        this.getOrCreateTableSchemaCache().clearIdColumnMapper();
        TimestampPrecisionUtils.checkTimestampPrecision(tsFileResource.getFileEndTime());
        tsFileResource.setStatus(TsFileResourceStatus.NORMAL);
        this.addTsFileResource(tsFileResource);
        this.addWritePointCount(writePointCount);
    }

    private TsFileResource constructTsFileResource(TsFileSequenceReader reader, File tsFile) throws IOException {
        TsFileResource tsFileResource = new TsFileResource(tsFile);
        if (!tsFileResource.resourceFileExists()) {
            tsFileResource.updatePlanIndexes(reader.getMinPlanIndex());
            tsFileResource.updatePlanIndexes(reader.getMaxPlanIndex());
        } else {
            tsFileResource.deserialize();
            tsFileResource.setGeneratedByPipe(this.isGeneratedByPipe);
        }
        return tsFileResource;
    }

    private TreeSchemaAutoCreatorAndVerifier getOrCreateTreeSchemaVerifier() {
        if (this.treeSchemaAutoCreatorAndVerifier == null) {
            this.treeSchemaAutoCreatorAndVerifier = new TreeSchemaAutoCreatorAndVerifier(this);
        }
        return this.treeSchemaAutoCreatorAndVerifier;
    }

    private LoadTsFileTableSchemaCache getOrCreateTableSchemaCache() {
        if (this.tableSchemaCache == null) {
            this.tableSchemaCache = new LoadTsFileTableSchemaCache(this.metadata, this.context);
        }
        return this.tableSchemaCache;
    }

    private void autoCreateTableDatabaseIfAbsent(String database) throws LoadAnalyzeException {
        TableConfigTaskVisitor.validateDatabaseName(database);
        if (DataNodeTableCache.getInstance().isDatabaseExist(database)) {
            return;
        }
        this.accessControl.checkCanCreateDatabase(this.context.getSession().getUserName(), database);
        CreateDBTask task = new CreateDBTask(new TDatabaseSchema(database).setIsTableModel(true), true);
        try {
            ListenableFuture<ConfigTaskResult> future = task.execute(ClusterConfigTaskExecutor.getInstance());
            ConfigTaskResult result = (ConfigTaskResult)future.get();
            if (result.getStatusCode().getStatusCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new LoadAnalyzeException(String.format("Auto create database failed: %s, status code: %s", database, result.getStatusCode()));
            }
        }
        catch (Exception e) {
            throw new LoadAnalyzeException("Auto create database failed because: " + e.getMessage());
        }
    }

    private void addTsFileResource(TsFileResource tsFileResource) {
        if (this.isTableModelStatement) {
            this.loadTsFileTableStatement.addTsFileResource(tsFileResource);
        } else {
            this.loadTsFileTreeStatement.addTsFileResource(tsFileResource);
        }
    }

    private static long getWritePointCount(Map<IDeviceID, List<TimeseriesMetadata>> device2TimeseriesMetadata) {
        return device2TimeseriesMetadata.values().stream().flatMap(Collection::stream).mapToLong(t -> t.getStatistics().getCount()).sum();
    }

    private void addWritePointCount(long writePointCount) {
        if (this.isTableModelStatement) {
            this.loadTsFileTableStatement.addWritePointCount(writePointCount);
        } else {
            this.loadTsFileTreeStatement.addWritePointCount(writePointCount);
        }
    }

    private void setTsFileModelInfoToStatement() {
        if (this.isTableModelStatement) {
            this.loadTsFileTableStatement.setIsTableModel(this.isTableModelTsFile);
        } else {
            this.loadTsFileTreeStatement.setIsTableModel(this.isTableModelTsFile);
        }
    }

    private boolean reconstructStatementIfMiniFileConverted() {
        if (!this.isMiniTsFileConverted) {
            return false;
        }
        return this.isTableModelStatement ? this.loadTsFileTableStatement.reconstructStatementIfMiniFileConverted(this.isMiniTsFile) : this.loadTsFileTreeStatement.reconstructStatementIfMiniFileConverted(this.isMiniTsFile);
    }

    private void setRealStatement(IAnalysis analysis) {
        if (!this.isTableModelStatement) {
            analysis.setRealStatement(this.loadTsFileTreeStatement);
        }
    }

    private void setFailAnalysisForAuthException(IAnalysis analysis, AuthException e) {
        analysis.setFinishQueryAfterAnalyze(true);
        analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)e.getCode(), (String)e.getMessage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTabletConversionOnException(IAnalysis analysis, LoadAnalyzeException e) {
        if (this.shouldSkipConversion(e)) {
            analysis.setFailStatus(new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()).setMessage(e.getMessage()));
            analysis.setFinishQueryAfterAnalyze(true);
            this.setRealStatement(analysis);
            return;
        }
        if (this.isTableModelTsFileReliableIndex < this.tsFiles.size() - 1) {
            try {
                this.getFileModelInfoBeforeTabletConversion();
            }
            catch (Exception e1) {
                LOGGER.warn("Load: Failed to convert to tablets from statement {} because failed to read model info from file, message: {}.", this.isTableModelStatement ? this.loadTsFileTableStatement : this.loadTsFileTreeStatement, (Object)e1.getMessage());
                analysis.setFailStatus(new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()).setMessage(e.getMessage()));
                analysis.setFinishQueryAfterAnalyze(true);
                this.setRealStatement(analysis);
                return;
            }
        }
        LoadTsFileDataTypeConverter loadTsFileDataTypeConverter = new LoadTsFileDataTypeConverter(this.isGeneratedByPipe);
        for (int i = 0; i < this.tsFiles.size(); ++i) {
            long startTime = System.nanoTime();
            try {
                TSStatus status;
                TSStatus tSStatus = status = this.isTableModelTsFile.get(i) != false ? (TSStatus)loadTsFileDataTypeConverter.convertForTableModel(new LoadTsFile(null, this.tsFiles.get(i).getPath(), Collections.emptyMap()).setDatabase(this.databaseForTableData).setDeleteAfterLoad(this.isDeleteAfterLoad).setConvertOnTypeMismatch(this.isConvertOnTypeMismatch)).orElse(null) : (TSStatus)loadTsFileDataTypeConverter.convertForTreeModel(new LoadTsFileStatement(this.tsFiles.get(i).getPath()).setDeleteAfterLoad(this.isDeleteAfterLoad).setConvertOnTypeMismatch(this.isConvertOnTypeMismatch)).orElse(null);
                if (status == null) {
                    LOGGER.warn("Load: Failed to convert to tablets from statement {}. Status is null.", this.isTableModelStatement ? this.loadTsFileTableStatement : this.loadTsFileTreeStatement);
                    analysis.setFailStatus(new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()).setMessage(e.getMessage()));
                    break;
                }
                if (loadTsFileDataTypeConverter.isSuccessful(status)) continue;
                LOGGER.warn("Load: Failed to convert to tablets from statement {}. Status: {}", this.isTableModelStatement ? this.loadTsFileTableStatement : this.loadTsFileTreeStatement, (Object)status);
                analysis.setFailStatus(status);
                break;
            }
            catch (Exception e2) {
                LOGGER.warn("Load: Failed to convert to tablets from statement {} because exception: {}", this.isTableModelStatement ? this.loadTsFileTableStatement : this.loadTsFileTreeStatement, (Object)e2.getMessage());
                analysis.setFailStatus(new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()).setMessage(e.getMessage()));
                break;
            }
            finally {
                LOAD_TSFILE_COST_METRICS_SET.recordPhaseTimeCost("analysis_cast_tablets", System.nanoTime() - startTime);
            }
        }
        analysis.setFinishQueryAfterAnalyze(true);
        this.setRealStatement(analysis);
    }

    private boolean shouldSkipConversion(LoadAnalyzeException e) {
        return e instanceof LoadAnalyzeTypeMismatchException && !this.isConvertOnTypeMismatch;
    }

    private void getFileModelInfoBeforeTabletConversion() throws IOException {
        int i = this.isTableModelTsFileReliableIndex + 1;
        while (i < this.tsFiles.size()) {
            try (TsFileSequenceReader reader = new TsFileSequenceReader(this.tsFiles.get(i).getAbsolutePath(), true);){
                Map tableSchemaMap = reader.getTableSchemaMap();
                this.isTableModelTsFile.set(i, Objects.nonNull(tableSchemaMap) && !tableSchemaMap.isEmpty());
                this.isTableModelTsFileReliableIndex = i++;
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.treeSchemaAutoCreatorAndVerifier != null) {
            this.treeSchemaAutoCreatorAndVerifier.close();
        }
        if (this.tableSchemaCache != null) {
            this.tableSchemaCache.close();
        }
    }
}

