/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.utils;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.ColumnList;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class RowComparator {
    private final List<TSDataType> dataTypes;

    public RowComparator(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public boolean equalColumns(List<Column> columns, int offset1, int offset2) {
        for (int i = 0; i < this.dataTypes.size(); ++i) {
            TSDataType dataType;
            Column column = columns.get(i);
            if (this.equal(column, dataType = this.dataTypes.get(i), offset1, offset2)) continue;
            return false;
        }
        return true;
    }

    public boolean equal(Column column, int offset1, int offset2) {
        assert (this.dataTypes.size() == 1);
        return this.equal(column, this.dataTypes.get(0), offset1, offset2);
    }

    private boolean equal(Column column, TSDataType dataType, int offset1, int offset2) {
        switch (dataType) {
            case BOOLEAN: {
                boolean bool1 = column.getBoolean(offset1);
                boolean bool2 = column.getBoolean(offset2);
                if (bool1 == bool2) break;
                return false;
            }
            case INT32: {
                int int1 = column.getInt(offset1);
                int int2 = column.getInt(offset2);
                if (int1 == int2) break;
                return false;
            }
            case INT64: {
                long long1 = column.getLong(offset1);
                long long2 = column.getLong(offset2);
                if (long1 == long2) break;
                return false;
            }
            case FLOAT: {
                float float1 = column.getFloat(offset1);
                float float2 = column.getFloat(offset2);
                if (float1 == float2) break;
                return false;
            }
            case DOUBLE: {
                double double1 = column.getDouble(offset1);
                double double2 = column.getDouble(offset2);
                if (double1 == double2) break;
                return false;
            }
            case TEXT: {
                Binary bin1 = column.getBinary(offset1);
                Binary bin2 = column.getBinary(offset2);
                if (bin1.equals((Object)bin2)) break;
                return false;
            }
            default: {
                throw new UnSupportedDataTypeException(dataType.toString());
            }
        }
        return true;
    }

    public boolean equalColumnLists(List<ColumnList> columns, int offset1, int offset2) {
        for (int i = 0; i < this.dataTypes.size(); ++i) {
            TSDataType dataType;
            ColumnList column = columns.get(i);
            if (this.equal(column, dataType = this.dataTypes.get(i), offset1, offset2)) continue;
            return false;
        }
        return true;
    }

    public boolean equal(ColumnList column, int offset1, int offset2) {
        assert (this.dataTypes.size() == 1);
        return this.equal(column, this.dataTypes.get(0), offset1, offset2);
    }

    private boolean equal(ColumnList column, TSDataType dataType, int offset1, int offset2) {
        switch (dataType) {
            case BOOLEAN: {
                boolean bool1 = column.getBoolean(offset1);
                boolean bool2 = column.getBoolean(offset2);
                if (bool1 == bool2) break;
                return false;
            }
            case INT32: {
                int int1 = column.getInt(offset1);
                int int2 = column.getInt(offset2);
                if (int1 == int2) break;
                return false;
            }
            case INT64: {
                long long1 = column.getLong(offset1);
                long long2 = column.getLong(offset2);
                if (long1 == long2) break;
                return false;
            }
            case FLOAT: {
                float float1 = column.getFloat(offset1);
                float float2 = column.getFloat(offset2);
                if (float1 == float2) break;
                return false;
            }
            case DOUBLE: {
                double double1 = column.getDouble(offset1);
                double double2 = column.getDouble(offset2);
                if (double1 == double2) break;
                return false;
            }
            case TEXT: {
                Binary bin1 = column.getBinary(offset1);
                Binary bin2 = column.getBinary(offset2);
                if (bin1.equals((Object)bin2)) break;
                return false;
            }
            default: {
                throw new UnSupportedDataTypeException(dataType.toString());
            }
        }
        return true;
    }

    public boolean equal(List<Column> columns1, int offset1, List<Column> columns2, int offset2) {
        block8: for (int i = 0; i < this.dataTypes.size(); ++i) {
            TSDataType dataType = this.dataTypes.get(i);
            Column column1 = columns1.get(i);
            Column column2 = columns2.get(i);
            switch (dataType) {
                case BOOLEAN: {
                    boolean bool1 = column1.getBoolean(offset1);
                    boolean bool2 = column2.getBoolean(offset2);
                    if (bool1 == bool2) continue block8;
                    return false;
                }
                case INT32: {
                    int int1 = column1.getInt(offset1);
                    int int2 = column2.getInt(offset2);
                    if (int1 == int2) continue block8;
                    return false;
                }
                case INT64: {
                    long long1 = column1.getLong(offset1);
                    long long2 = column2.getLong(offset2);
                    if (long1 == long2) continue block8;
                    return false;
                }
                case FLOAT: {
                    float float1 = column1.getFloat(offset1);
                    float float2 = column2.getFloat(offset2);
                    if (float1 == float2) continue block8;
                    return false;
                }
                case DOUBLE: {
                    double double1 = column1.getDouble(offset1);
                    double double2 = column2.getDouble(offset2);
                    if (double1 == double2) continue block8;
                    return false;
                }
                case TEXT: {
                    Binary bin1 = column1.getBinary(offset1);
                    Binary bin2 = column2.getBinary(offset2);
                    if (bin1.equals((Object)bin2)) continue block8;
                    return false;
                }
                default: {
                    throw new UnSupportedDataTypeException(dataType.toString());
                }
            }
        }
        return true;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }
}

