/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.MultiAlignedTVListIterator;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;

public class MergeSortMultiAlignedTVListIterator
extends MultiAlignedTVListIterator {
    private final Set<Integer> probeIterators;
    private final int[] iteratorIndices;
    private final int[] rowIndices;
    private final BitMap bitMap;
    private final List<int[]> valueColumnDeleteCursor;
    private final PriorityQueue<Pair<Long, Integer>> minHeap = new PriorityQueue((a, b) -> ((Long)a.left).equals(b.left) ? ((Integer)b.right).compareTo((Integer)a.right) : ((Long)a.left).compareTo((Long)b.left));

    public MergeSortMultiAlignedTVListIterator(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, boolean ignoreAllNullRows) {
        super(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, floatPrecision, encodingList, ignoreAllNullRows);
        this.probeIterators = IntStream.range(0, this.alignedTvListIterators.size()).boxed().collect(Collectors.toSet());
        this.bitMap = new BitMap(this.tsDataTypeList.size());
        this.iteratorIndices = new int[this.tsDataTypeList.size()];
        this.rowIndices = new int[this.tsDataTypeList.size()];
        this.valueColumnDeleteCursor = new ArrayList<int[]>();
        for (int i = 0; i < this.tsDataTypeList.size(); ++i) {
            this.valueColumnDeleteCursor.add(new int[]{0});
        }
        this.ignoreAllNullRows = ignoreAllNullRows;
    }

    @Override
    protected void prepareNext() {
        this.hasNext = false;
        for (int i : this.probeIterators) {
            AlignedTVList.AlignedTVListIterator iterator = (AlignedTVList.AlignedTVListIterator)this.alignedTvListIterators.get(i);
            if (!iterator.hasNextTimeValuePair()) continue;
            this.minHeap.add((Pair<Long, Integer>)new Pair((Object)iterator.currentTime(), (Object)i));
        }
        this.probeIterators.clear();
        while (!this.minHeap.isEmpty() && !this.hasNext) {
            this.bitMap.reset();
            Pair<Long, Integer> top = this.minHeap.poll();
            this.currentTime = (Long)top.left;
            this.probeIterators.add((Integer)top.right);
            for (int columnIndex = 0; columnIndex < this.tsDataTypeList.size(); ++columnIndex) {
                this.iteratorIndices[columnIndex] = (Integer)top.right;
                this.rowIndices[columnIndex] = ((AlignedTVList.AlignedTVListIterator)this.alignedTvListIterators.get((Integer)top.right)).getSelectedIndex(columnIndex);
                if (!((AlignedTVList.AlignedTVListIterator)this.alignedTvListIterators.get((Integer)top.right)).isNullValue(this.rowIndices[columnIndex], columnIndex)) continue;
                this.bitMap.mark(columnIndex);
            }
            this.hasNext = true;
            while (!this.minHeap.isEmpty() && (Long)this.minHeap.peek().left == this.currentTime) {
                Pair<Long, Integer> element = this.minHeap.poll();
                this.probeIterators.add((Integer)element.right);
                for (int columnIndex = 0; columnIndex < this.tsDataTypeList.size(); ++columnIndex) {
                    if (((AlignedTVList.AlignedTVListIterator)this.alignedTvListIterators.get(this.iteratorIndices[columnIndex])).isNullValue(this.rowIndices[columnIndex], columnIndex)) {
                        this.iteratorIndices[columnIndex] = (Integer)element.right;
                        this.rowIndices[columnIndex] = ((AlignedTVList.AlignedTVListIterator)this.alignedTvListIterators.get((Integer)element.right)).getSelectedIndex(columnIndex);
                        if (!((AlignedTVList.AlignedTVListIterator)this.alignedTvListIterators.get((Integer)element.right)).isNullValue(this.rowIndices[columnIndex], columnIndex)) {
                            this.bitMap.unmark(columnIndex);
                        }
                    }
                    if (this.valueColumnsDeletionList == null || !ModificationUtils.isPointDeleted(this.currentTime, (List)this.valueColumnsDeletionList.get(columnIndex), this.valueColumnDeleteCursor.get(columnIndex))) continue;
                    this.iteratorIndices[columnIndex] = -1;
                    this.bitMap.mark(columnIndex);
                }
            }
            if (!this.ignoreAllNullRows || !this.bitMap.isAllMarked()) continue;
            Iterator<Integer> it = this.probeIterators.iterator();
            while (it.hasNext()) {
                int idx = it.next();
                AlignedTVList.AlignedTVListIterator iterator = (AlignedTVList.AlignedTVListIterator)this.alignedTvListIterators.get(idx);
                iterator.next();
                if (iterator.hasNextTimeValuePair()) {
                    this.minHeap.add((Pair<Long, Integer>)new Pair((Object)iterator.currentTime(), (Object)idx));
                    continue;
                }
                it.remove();
            }
            this.hasNext = false;
        }
        this.probeNext = true;
    }

    @Override
    protected void next() {
        for (int index : this.probeIterators) {
            ((AlignedTVList.AlignedTVListIterator)this.alignedTvListIterators.get(index)).next();
        }
        this.probeNext = false;
    }

    @Override
    protected int currentIteratorIndex(int columnIndex) {
        return this.iteratorIndices[columnIndex];
    }

    @Override
    protected int currentRowIndex(int columnIndex) {
        return this.rowIndices[columnIndex];
    }
}

