/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.active;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.LongConsumer;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTThreadFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedThreadPoolExecutor;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.InternalClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.pipe.PipeEnrichedStatement;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadFailedMessageHandler;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadPendingQueue;
import org.apache.iotdb.db.storageengine.load.metrics.ActiveLoadingFilesNumberMetricsSet;
import org.apache.iotdb.db.storageengine.load.metrics.ActiveLoadingFilesSizeMetricsSet;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveLoadTsFileLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveLoadTsFileLoader.class);
    private static final IoTDBConfig IOTDB_CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final int MAX_PENDING_SIZE = 1000;
    private final ActiveLoadPendingQueue pendingQueue = new ActiveLoadPendingQueue();
    private final AtomicReference<WrappedThreadPoolExecutor> activeLoadExecutor = new AtomicReference();
    private final AtomicReference<String> failDir = new AtomicReference();
    private final boolean isVerify = IOTDB_CONFIG.isLoadActiveListeningVerifyEnable();

    public int getCurrentAllowedPendingSize() {
        return 1000 - this.pendingQueue.size();
    }

    public void tryTriggerTsFileLoad(String absolutePath, boolean isGeneratedByPipe) {
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            return;
        }
        if (this.pendingQueue.enqueue(absolutePath, isGeneratedByPipe)) {
            this.initFailDirIfNecessary();
            this.adjustExecutorIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFailDirIfNecessary() {
        if (!Objects.equals(this.failDir.get(), IOTDB_CONFIG.getLoadActiveListeningFailDir())) {
            AtomicReference<String> atomicReference = this.failDir;
            synchronized (atomicReference) {
                if (!Objects.equals(this.failDir.get(), IOTDB_CONFIG.getLoadActiveListeningFailDir())) {
                    File failDirFile = new File(IOTDB_CONFIG.getLoadActiveListeningFailDir());
                    try {
                        RetryUtils.retryOnException(() -> {
                            org.apache.commons.io.FileUtils.forceMkdir((File)failDirFile);
                            return null;
                        });
                    }
                    catch (IOException e) {
                        LOGGER.warn("Error occurred during creating fail directory {} for active load.", (Object)failDirFile.getAbsoluteFile(), (Object)e);
                    }
                    this.failDir.set(IOTDB_CONFIG.getLoadActiveListeningFailDir());
                    ActiveLoadingFilesSizeMetricsSet.getInstance().updateFailedDir(this.failDir.get());
                    ActiveLoadingFilesNumberMetricsSet.getInstance().updateFailedDir(this.failDir.get());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustExecutorIfNecessary() {
        if (this.activeLoadExecutor.get() == null) {
            AtomicReference<WrappedThreadPoolExecutor> atomicReference = this.activeLoadExecutor;
            synchronized (atomicReference) {
                if (this.activeLoadExecutor.get() == null) {
                    this.activeLoadExecutor.set(new WrappedThreadPoolExecutor(IOTDB_CONFIG.getLoadActiveListeningMaxThreadNum(), IOTDB_CONFIG.getLoadActiveListeningMaxThreadNum(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue(), new IoTThreadFactory(ThreadName.ACTIVE_LOAD_TSFILE_LOADER.name()), ThreadName.ACTIVE_LOAD_TSFILE_LOADER.name()));
                }
            }
        }
        int targetCorePoolSize = Math.min(this.pendingQueue.size(), IOTDB_CONFIG.getLoadActiveListeningMaxThreadNum());
        if (this.activeLoadExecutor.get().getCorePoolSize() != targetCorePoolSize) {
            this.activeLoadExecutor.get().setCorePoolSize(targetCorePoolSize);
        }
        int threadsToBeAdded = Math.max(targetCorePoolSize - this.activeLoadExecutor.get().getActiveCount(), 0);
        for (int i = 0; i < threadsToBeAdded; ++i) {
            this.activeLoadExecutor.get().execute(this::tryLoadPendingTsFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void tryLoadPendingTsFiles() {
        session = new InternalClientSession(String.format("%s_%s", new Object[]{ActiveLoadTsFileLoader.class.getSimpleName(), Thread.currentThread().getName()}));
        session.setUsername(AuthorityChecker.SUPER_USER);
        session.setClientVersion(IoTDBConstant.ClientVersion.V_1_0);
        session.setZoneId(ZoneId.systemDefault());
        while (true) lbl-1000:
        // 6 sources

        {
            if (!(filePair = this.tryGetNextPendingFile()).isPresent()) {
                return;
            }
            try {
                result = this.loadTsFile(filePair.get(), session);
                if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                    ActiveLoadTsFileLoader.LOGGER.info("Successfully auto load tsfile {} (isGeneratedByPipe = {})", filePair.get().getLeft(), filePair.get().getRight());
                }
                this.handleLoadFailure(filePair.get(), result);
            }
            catch (FileNotFoundException e) {
                this.handleFileNotFoundException(filePair.get());
            }
            catch (Exception e) {
                this.handleOtherException(filePair.get(), e);
            }
            finally {
                this.pendingQueue.removeFromLoading((String)filePair.get().getLeft());
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            this.SESSION_MANAGER.closeSession(session, (LongConsumer)LambdaMetafactory.metafactory(null, null, null, (J)V, cleanupQueryExecution(java.lang.Long ), (J)V)((Coordinator)Coordinator.getInstance()));
        }
    }

    private Optional<Pair<String, Boolean>> tryGetNextPendingFile() {
        long maxRetryTimes = Math.max(1L, IOTDB_CONFIG.getLoadActiveListeningCheckIntervalSeconds() << 1);
        long currentRetryTimes = 0L;
        do {
            Pair<String, Boolean> filePair;
            if (Objects.nonNull(filePair = this.pendingQueue.dequeueFromPending())) {
                return Optional.of(filePair);
            }
            LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(1L));
        } while (currentRetryTimes++ < maxRetryTimes);
        return Optional.empty();
    }

    private TSStatus loadTsFile(Pair<String, Boolean> filePair, IClientSession session) throws FileNotFoundException {
        LoadTsFileStatement statement = new LoadTsFileStatement((String)filePair.getLeft());
        List<File> files = statement.getTsFiles();
        if (!files.isEmpty()) {
            File parentFile = files.get(0).getParentFile();
            statement.setDatabase(parentFile == null ? "null" : parentFile.getName());
        }
        statement.setDeleteAfterLoad(true);
        statement.setConvertOnTypeMismatch(true);
        statement.setVerifySchema(this.isVerify);
        statement.setAutoCreateDatabase(false);
        return this.executeStatement((Boolean)filePair.getRight() != false ? new PipeEnrichedStatement(statement) : statement, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSStatus executeStatement(Statement statement, IClientSession session) {
        this.SESSION_MANAGER.registerSession(session);
        try {
            TSStatus tSStatus = Coordinator.getInstance().executeForTreeModel((Statement)statement, (long)this.SESSION_MANAGER.requestQueryId(), (SessionInfo)this.SESSION_MANAGER.getSessionInfo((IClientSession)session), (String)"", (IPartitionFetcher)ClusterPartitionFetcher.getInstance(), (ISchemaFetcher)ClusterSchemaFetcher.getInstance(), (long)ActiveLoadTsFileLoader.IOTDB_CONFIG.getQueryTimeoutThreshold(), (boolean)false).status;
            return tSStatus;
        }
        finally {
            this.SESSION_MANAGER.removeCurrSession();
        }
    }

    private void handleLoadFailure(Pair<String, Boolean> filePair, TSStatus status) {
        if (!ActiveLoadFailedMessageHandler.isExceptionMessageShouldRetry(filePair, status.getMessage())) {
            LOGGER.warn("Failed to auto load tsfile {} (isGeneratedByPipe = {}), status: {}. File will be moved to fail directory.", new Object[]{filePair.getLeft(), filePair.getRight(), status});
            this.removeFileAndResourceAndModsToFailDir((String)filePair.getLeft());
        }
    }

    private void handleFileNotFoundException(Pair<String, Boolean> filePair) {
        LOGGER.warn("Failed to auto load tsfile {} (isGeneratedByPipe = {}) due to file not found, will skip this file.", filePair.getLeft(), filePair.getRight());
        this.removeFileAndResourceAndModsToFailDir((String)filePair.getLeft());
    }

    private void handleOtherException(Pair<String, Boolean> filePair, Exception e) {
        if (!ActiveLoadFailedMessageHandler.isExceptionMessageShouldRetry(filePair, e.getMessage())) {
            LOGGER.warn("Failed to auto load tsfile {} (isGeneratedByPipe = {}) because of an unexpected exception. File will be moved to fail directory.", new Object[]{filePair.getLeft(), filePair.getRight(), e});
            this.removeFileAndResourceAndModsToFailDir((String)filePair.getLeft());
        }
    }

    private void removeFileAndResourceAndModsToFailDir(String filePath) {
        this.removeToFailDir(filePath);
        this.removeToFailDir(filePath + ".resource");
        this.removeToFailDir(filePath + ".mods");
    }

    private void removeToFailDir(String filePath) {
        File sourceFile = new File(filePath);
        if (!sourceFile.exists()) {
            return;
        }
        File targetDir = new File(this.failDir.get());
        try {
            RetryUtils.retryOnException(() -> {
                FileUtils.moveFileWithMD5Check((File)sourceFile, (File)targetDir);
                return null;
            });
        }
        catch (IOException e) {
            LOGGER.warn("Error occurred during moving file {} to fail directory.", (Object)filePath, (Object)e);
        }
    }

    public boolean isFilePendingOrLoading(File file) {
        return this.pendingQueue.isFilePendingOrLoading(file.getAbsolutePath());
    }

    public long countAndReportFailedFileNumber() {
        final long[] fileCount = new long[]{0L};
        final long[] fileSize = new long[]{0L};
        try {
            this.initFailDirIfNecessary();
            Files.walkFileTree(new File(this.failDir.get()).toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    fileCount[0] = fileCount[0] + 1L;
                    try {
                        fileSize[0] = fileSize[0] + file.toFile().length();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Failed to count failed files in fail directory.", (Throwable)e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            ActiveLoadingFilesNumberMetricsSet.getInstance().updateTotalFailedFileCounter(fileCount[0]);
            ActiveLoadingFilesSizeMetricsSet.getInstance().updateTotalFailedFileCounter(fileSize[0]);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to count failed files in fail directory.", (Throwable)e);
        }
        return fileCount[0];
    }
}

