/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinCriteria;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;

public class Join
extends Relation {
    private final Type type;
    private final Relation left;
    private final Relation right;
    @Nullable
    private final JoinCriteria criteria;

    public Join(Type type, Relation left, Relation right) {
        super(null);
        this.criteria = null;
        Preconditions.checkArgument((type == Type.CROSS || type == Type.IMPLICIT ? 1 : 0) != 0, (Object)"No join criteria specified");
        this.type = type;
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    public Join(NodeLocation location, Type type, Relation left, Relation right) {
        super(Objects.requireNonNull(location, "location is null"));
        this.criteria = null;
        Preconditions.checkArgument((type == Type.CROSS || type == Type.IMPLICIT ? 1 : 0) != 0, (Object)"No join criteria specified");
        this.type = type;
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    public Join(Type type, Relation left, Relation right, JoinCriteria criteria) {
        super(null);
        this.criteria = Objects.requireNonNull(criteria, "criteria is null");
        Preconditions.checkArgument((type != Type.CROSS && type != Type.IMPLICIT ? 1 : 0) != 0, (String)"%s join cannot have join criteria", (Object)((Object)type));
        this.type = type;
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    public Join(NodeLocation location, Type type, Relation left, Relation right, JoinCriteria criteria) {
        super(Objects.requireNonNull(location, "location is null"));
        this.criteria = Objects.requireNonNull(criteria, "criteria is null");
        Preconditions.checkArgument((type != Type.CROSS && type != Type.IMPLICIT ? 1 : 0) != 0, (String)"%s join cannot have join criteria", (Object)((Object)type));
        this.type = type;
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    public Type getType() {
        return this.type;
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    public Optional<JoinCriteria> getCriteria() {
        return Optional.ofNullable(this.criteria);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.left);
        nodes.add((Object)this.right);
        if (this.criteria != null) {
            nodes.addAll(this.criteria.getNodes());
        }
        return nodes.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("left", (Object)this.left).add("right", (Object)this.right).add("criteria", (Object)this.criteria).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Join join = (Join)o;
        return this.type == join.type && Objects.equals(this.left, join.left) && Objects.equals(this.right, join.right) && Objects.equals(this.criteria, join.criteria);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.left, this.right, this.criteria});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Join.sameClass(this, other)) {
            return false;
        }
        return this.type.equals((Object)((Join)other).type);
    }

    public static enum Type {
        CROSS,
        INNER,
        LEFT,
        RIGHT,
        FULL,
        IMPLICIT;

    }
}

