/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.table.AbstractTablePlan;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class RenameTableColumnPlan
extends AbstractTablePlan {
    private String oldName;
    private String newName;

    public RenameTableColumnPlan() {
        super(ConfigPhysicalPlanType.RenameTableColumn);
    }

    public RenameTableColumnPlan(String database, String tableName, String oldName, String newName) {
        super(ConfigPhysicalPlanType.RenameTableColumn, database, tableName);
        this.oldName = oldName;
        this.newName = newName;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        super.serializeImpl(stream);
        ReadWriteIOUtils.write((String)this.oldName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.newName, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        super.deserializeImpl(buffer);
        this.oldName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.newName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
    }
}

