/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.tsfile.annotations.TsFileApi;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.StringContainer;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchemaType;

public class MeasurementSchema
implements IMeasurementSchema,
Comparable<MeasurementSchema>,
Serializable {
    private String measurementName;
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressionType;
    private TSEncodingBuilder encodingConverter;
    private Map<String, String> props = null;

    public MeasurementSchema() {
    }

    @TsFileApi
    public MeasurementSchema(String measurementName, TSDataType dataType) {
        this(measurementName, dataType, TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getValueEncoder(dataType)), TSFileDescriptor.getInstance().getConfig().getCompressor(), null);
    }

    public MeasurementSchema(String measurementName, TSDataType dataType, TSEncoding encoding) {
        this(measurementName, dataType, encoding, TSFileDescriptor.getInstance().getConfig().getCompressor(), null);
    }

    @TsFileApi
    public MeasurementSchema(String measurementName, TSDataType dataType, TSEncoding encoding, CompressionType compressionType) {
        this(measurementName, dataType, encoding, compressionType, null);
    }

    public MeasurementSchema(String measurementName, TSDataType dataType, TSEncoding encoding, CompressionType compressionType, Map<String, String> props) {
        this.dataType = dataType;
        this.measurementName = measurementName;
        this.encoding = encoding;
        this.props = props;
        this.compressionType = compressionType;
    }

    public MeasurementSchema(String measurementName, byte type, byte encoding, byte compressor, Map<String, String> props) {
        this.dataType = TSDataType.getTsDataType((byte)type);
        this.measurementName = measurementName;
        this.encoding = TSEncoding.deserialize(encoding);
        this.props = props;
        this.compressionType = CompressionType.deserialize(compressor);
    }

    public static MeasurementSchema deserializeFrom(InputStream inputStream) throws IOException {
        MeasurementSchema measurementSchema = new MeasurementSchema();
        measurementSchema.measurementName = ReadWriteIOUtils.readString(inputStream);
        measurementSchema.dataType = TSDataType.deserializeFrom((InputStream)inputStream);
        measurementSchema.encoding = TSEncoding.deserialize(ReadWriteIOUtils.readByte(inputStream));
        measurementSchema.compressionType = CompressionType.deserialize(ReadWriteIOUtils.readByte(inputStream));
        int size = ReadWriteIOUtils.readInt(inputStream);
        if (size > 0) {
            measurementSchema.props = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(inputStream);
                String value = ReadWriteIOUtils.readString(inputStream);
                measurementSchema.props.put(key, value);
            }
        }
        return measurementSchema;
    }

    public static MeasurementSchema deserializeFrom(ByteBuffer buffer) {
        MeasurementSchema measurementSchema = new MeasurementSchema();
        measurementSchema.measurementName = ReadWriteIOUtils.readString(buffer);
        measurementSchema.dataType = TSDataType.deserializeFrom((ByteBuffer)buffer);
        measurementSchema.encoding = TSEncoding.deserialize(ReadWriteIOUtils.readByte(buffer));
        measurementSchema.compressionType = CompressionType.deserialize(ReadWriteIOUtils.readByte(buffer));
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            measurementSchema.props = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                String value = ReadWriteIOUtils.readString(buffer);
                measurementSchema.props.put(key, value);
            }
        }
        return measurementSchema;
    }

    public static MeasurementSchema partialDeserializeFrom(ByteBuffer buffer) {
        MeasurementSchema measurementSchema = new MeasurementSchema();
        measurementSchema.measurementName = ReadWriteIOUtils.readString(buffer);
        measurementSchema.dataType = TSDataType.deserializeFrom((ByteBuffer)buffer);
        measurementSchema.encoding = TSEncoding.deserialize(ReadWriteIOUtils.readByte(buffer));
        measurementSchema.compressionType = CompressionType.deserialize(ReadWriteIOUtils.readByte(buffer));
        return measurementSchema;
    }

    @Override
    public MeasurementSchemaType getSchemaType() {
        return MeasurementSchemaType.MEASUREMENT_SCHEMA;
    }

    @Override
    public String getMeasurementName() {
        return this.measurementName;
    }

    public void setMeasurementName(String measurementName) {
        this.measurementName = measurementName;
    }

    @Override
    public Map<String, String> getProps() {
        return this.props;
    }

    @Override
    public TSEncoding getEncodingType() {
        return this.encoding;
    }

    @Override
    public TSDataType getType() {
        return this.dataType;
    }

    @Override
    public byte getTypeInByte() {
        return this.dataType.serialize();
    }

    @Override
    public TSEncoding getTimeTSEncoding() {
        return TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    @Override
    public Encoder getTimeEncoder() {
        TSEncoding timeEncoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
        TSDataType timeType = TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType();
        return TSEncodingBuilder.getEncodingBuilder(timeEncoding).getEncoder(timeType);
    }

    @Override
    public List<String> getSubMeasurementsList() {
        throw new UnsupportedOperationException("unsupported method for MeasurementSchema");
    }

    @Override
    public List<TSDataType> getSubMeasurementsTSDataTypeList() {
        throw new UnsupportedOperationException("unsupported method for MeasurementSchema");
    }

    @Override
    public List<TSEncoding> getSubMeasurementsTSEncodingList() {
        throw new UnsupportedOperationException("unsupported method for MeasurementSchema");
    }

    @Override
    public List<Encoder> getSubMeasurementsEncoderList() {
        throw new UnsupportedOperationException("unsupported method for MeasurementSchema");
    }

    @Override
    public Encoder getValueEncoder() {
        if (this.encodingConverter == null) {
            this.encodingConverter = TSEncodingBuilder.getEncodingBuilder(this.encoding);
            this.encodingConverter.initFromProps(this.props);
        }
        return this.encodingConverter.getEncoder(this.dataType);
    }

    @Override
    public CompressionType getCompressor() {
        return this.compressionType;
    }

    @Override
    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.measurementName, outputStream);
        byteLen += ReadWriteIOUtils.write(this.dataType.serialize(), outputStream);
        byteLen += ReadWriteIOUtils.write(this.encoding, outputStream);
        byteLen += ReadWriteIOUtils.write(this.compressionType.serialize(), outputStream);
        if (this.props == null) {
            byteLen += ReadWriteIOUtils.write(0, outputStream);
        } else {
            byteLen += ReadWriteIOUtils.write(this.props.size(), outputStream);
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                byteLen += ReadWriteIOUtils.write(entry.getKey(), outputStream);
                byteLen += ReadWriteIOUtils.write(entry.getValue(), outputStream);
            }
        }
        return byteLen;
    }

    @Override
    public int serializedSize() {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.sizeToWrite(this.measurementName);
        byteLen += 3;
        if (this.props == null) {
            byteLen += 4;
        } else {
            byteLen += 4;
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                byteLen += ReadWriteIOUtils.sizeToWrite(entry.getKey());
                byteLen += ReadWriteIOUtils.sizeToWrite(entry.getValue());
            }
        }
        return byteLen;
    }

    @Override
    public int serializeTo(ByteBuffer buffer) {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.measurementName, buffer);
        byteLen += ReadWriteIOUtils.write(this.dataType.serialize(), buffer);
        byteLen += ReadWriteIOUtils.write(this.encoding, buffer);
        byteLen += ReadWriteIOUtils.write(this.compressionType.serialize(), buffer);
        if (this.props == null) {
            byteLen += ReadWriteIOUtils.write(0, buffer);
        } else {
            byteLen += ReadWriteIOUtils.write(this.props.size(), buffer);
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                byteLen += ReadWriteIOUtils.write(entry.getKey(), buffer);
                byteLen += ReadWriteIOUtils.write(entry.getValue(), buffer);
            }
        }
        return byteLen;
    }

    @Override
    public int partialSerializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write((byte)0, outputStream);
        byteLen += ReadWriteIOUtils.write(this.measurementName, outputStream);
        byteLen += ReadWriteIOUtils.write(this.dataType.serialize(), outputStream);
        byteLen += ReadWriteIOUtils.write(this.encoding, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.compressionType.serialize(), outputStream);
    }

    @Override
    public boolean isLogicalView() {
        return false;
    }

    @Override
    public int partialSerializeTo(ByteBuffer buffer) {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write((byte)0, buffer);
        byteLen += ReadWriteIOUtils.write(this.measurementName, buffer);
        byteLen += ReadWriteIOUtils.write(this.dataType.serialize(), buffer);
        byteLen += ReadWriteIOUtils.write(this.encoding, buffer);
        return byteLen += ReadWriteIOUtils.write(this.compressionType.serialize(), buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementSchema that = (MeasurementSchema)o;
        return this.dataType == that.dataType && this.encoding == that.encoding && Objects.equals(this.measurementName, that.measurementName) && this.compressionType == that.compressionType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataType, this.encoding, this.measurementName, this.compressionType});
    }

    @Override
    public int compareTo(MeasurementSchema o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.measurementName.compareTo(o.measurementName);
    }

    public String toString() {
        StringContainer sc = new StringContainer("");
        sc.addTail("[", this.measurementName, ",", this.dataType.toString(), ",", this.encoding.toString(), ",", this.props == null ? "" : this.props.toString(), ",", this.compressionType.toString());
        sc.addTail("]");
        return sc.toString();
    }

    @Override
    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public int getSubMeasurementIndex(String measurementId) {
        return this.measurementName.equals(measurementId) ? 0 : -1;
    }

    @Override
    public int getSubMeasurementsCount() {
        return 1;
    }

    @Override
    public boolean containsSubMeasurement(String measurementId) {
        return this.measurementName.equals(measurementId);
    }

    public void setEncoding(TSEncoding encoding) {
        this.encoding = encoding;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }
}

