/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.chunk;

import java.io.IOException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkGroupWriter;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.record.datapoint.DataPoint;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonAlignedChunkGroupWriterImpl
implements IChunkGroupWriter {
    private static final Logger LOG = LoggerFactory.getLogger(NonAlignedChunkGroupWriterImpl.class);
    private final IDeviceID deviceId;
    private final Map<String, ChunkWriterImpl> chunkWriters = new LinkedHashMap<String, ChunkWriterImpl>();
    private EncryptParameter encryptParam;
    private Map<String, Long> lastTimeMap = new HashMap<String, Long>();

    public NonAlignedChunkGroupWriterImpl(IDeviceID deviceId) {
        this.deviceId = deviceId;
        this.encryptParam = EncryptUtils.getEncryptParameter();
    }

    public NonAlignedChunkGroupWriterImpl(IDeviceID deviceId, EncryptParameter encryptParam) {
        this.deviceId = deviceId;
        this.encryptParam = encryptParam;
    }

    @Override
    public void tryToAddSeriesWriter(IMeasurementSchema schema) {
        if (!this.chunkWriters.containsKey(schema.getMeasurementName())) {
            this.chunkWriters.put(schema.getMeasurementName(), new ChunkWriterImpl(schema, this.encryptParam));
        }
    }

    @Override
    public void tryToAddSeriesWriter(List<IMeasurementSchema> schemas) {
        for (IMeasurementSchema schema : schemas) {
            if (this.chunkWriters.containsKey(schema.getMeasurementName())) continue;
            this.chunkWriters.put(schema.getMeasurementName(), new ChunkWriterImpl(schema, this.encryptParam));
        }
    }

    @Override
    public int write(long time, List<DataPoint> data) throws IOException, WriteProcessException {
        int pointCount = 0;
        for (DataPoint point : data) {
            this.checkIsHistoryData(point.getMeasurementId(), time);
            if (pointCount == 0) {
                ++pointCount;
            }
            point.writeTo(time, this.chunkWriters.get(point.getMeasurementId()));
            this.lastTimeMap.put(point.getMeasurementId(), time);
        }
        return pointCount;
    }

    @Override
    public int write(Tablet tablet) throws IOException, WriteProcessException {
        return this.write(tablet, 0, tablet.getRowSize());
    }

    @Override
    public int write(Tablet tablet, int startRowIndex, int endRowIndex) throws WriteProcessException, IOException {
        int maxPointCount = 0;
        List<IMeasurementSchema> timeseries = tablet.getSchemas();
        for (int column = 0; column < tablet.getSchemas().size(); ++column) {
            if (tablet.getColumnTypes() != null && tablet.getColumnTypes().get(column) != Tablet.ColumnCategory.FIELD) continue;
            String measurementId = timeseries.get(column).getMeasurementName();
            TSDataType tsDataType = timeseries.get(column).getType();
            int pointCount = 0;
            for (int row = startRowIndex; row < endRowIndex; ++row) {
                if (tablet.getBitMaps() != null && tablet.getBitMaps()[column] != null && tablet.getBitMaps()[column].isMarked(row)) continue;
                long time = tablet.getTimestamps()[row];
                this.checkIsHistoryData(measurementId, time);
                ++pointCount;
                switch (tsDataType) {
                    case INT32: {
                        this.chunkWriters.get(measurementId).write(time, ((int[])tablet.getValues()[column])[row]);
                        break;
                    }
                    case DATE: {
                        this.chunkWriters.get(measurementId).write(time, DateUtils.parseDateExpressionToInt(((LocalDate[])tablet.getValues()[column])[row]));
                        break;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        this.chunkWriters.get(measurementId).write(time, ((long[])tablet.getValues()[column])[row]);
                        break;
                    }
                    case FLOAT: {
                        this.chunkWriters.get(measurementId).write(time, ((float[])tablet.getValues()[column])[row]);
                        break;
                    }
                    case DOUBLE: {
                        this.chunkWriters.get(measurementId).write(time, ((double[])tablet.getValues()[column])[row]);
                        break;
                    }
                    case BOOLEAN: {
                        this.chunkWriters.get(measurementId).write(time, ((boolean[])tablet.getValues()[column])[row]);
                        break;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        this.chunkWriters.get(measurementId).write(time, ((Binary[])tablet.getValues()[column])[row]);
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", tsDataType));
                    }
                }
                this.lastTimeMap.put(measurementId, time);
            }
            maxPointCount = Math.max(pointCount, maxPointCount);
        }
        return maxPointCount;
    }

    @Override
    public long flushToFileWriter(TsFileIOWriter fileWriter) throws IOException {
        LOG.debug("start flush device id:{}", (Object)this.deviceId);
        this.sealAllChunks();
        long currentChunkGroupSize = this.getCurrentChunkGroupSize();
        for (IChunkWriter iChunkWriter : this.chunkWriters.values()) {
            iChunkWriter.writeToFileWriter(fileWriter);
        }
        return currentChunkGroupSize;
    }

    @Override
    public long updateMaxGroupMemSize() {
        long bufferSize = 0L;
        for (IChunkWriter iChunkWriter : this.chunkWriters.values()) {
            bufferSize += iChunkWriter.estimateMaxSeriesMemSize();
        }
        return bufferSize;
    }

    @Override
    public long getCurrentChunkGroupSize() {
        long size = 0L;
        for (IChunkWriter iChunkWriter : this.chunkWriters.values()) {
            size += iChunkWriter.getSerializedChunkSize();
        }
        return size;
    }

    private void sealAllChunks() {
        for (IChunkWriter iChunkWriter : this.chunkWriters.values()) {
            iChunkWriter.sealCurrentPage();
        }
    }

    private void checkIsHistoryData(String measurementId, long time) throws WriteProcessException {
        Long lastTime = this.lastTimeMap.get(measurementId);
        if (lastTime != null && time <= lastTime) {
            throw new WriteProcessException("Not allowed to write out-of-order data in timeseries " + this.deviceId + "." + measurementId + ", time should later than " + this.lastTimeMap.get(measurementId));
        }
    }

    public Map<String, Long> getLastTimeMap() {
        return this.lastTimeMap;
    }

    public void setLastTimeMap(Map<String, Long> lastTimeMap) {
        this.lastTimeMap = lastTimeMap;
    }
}

