/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.util.Arrays;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.block.column.ColumnBuilderStatus;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.ColumnUtil;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class BinaryColumnBuilder
implements ColumnBuilder {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(BinaryColumnBuilder.class);
    private final ColumnBuilderStatus columnBuilderStatus;
    public static final BinaryColumn NULL_VALUE_BLOCK = new BinaryColumn(0, 1, new boolean[]{true}, new Binary[1]);
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private Binary[] values = new Binary[0];
    private long arraysRetainedSizeInBytes;

    public BinaryColumnBuilder(ColumnBuilderStatus columnBuilderStatus, int expectedEntries) {
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.columnBuilderStatus = columnBuilderStatus;
        this.updateArraysDataSize();
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public ColumnBuilder writeBinary(Binary value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        this.hasNonNullValue = true;
        ++this.positionCount;
        return this;
    }

    public ColumnBuilder writeObject(Object value) {
        if (value instanceof Binary) {
            this.writeBinary((Binary)value);
            return this;
        }
        throw new UnSupportedDataTypeException("BinaryColumn only support Binary data type");
    }

    public ColumnBuilder write(Column column, int index) {
        return this.writeBinary(column.getBinary(index));
    }

    public ColumnBuilder writeTsPrimitiveType(TsPrimitiveType value) {
        return this.writeBinary(value.getBinary());
    }

    public ColumnBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        return this;
    }

    public Column build() {
        if (!this.hasNonNullValue) {
            return new RunLengthEncodedColumn(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new BinaryColumn(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    public TSDataType getDataType() {
        return TSDataType.TEXT;
    }

    public long getRetainedSizeInBytes() {
        long size = INSTANCE_SIZE + this.arraysRetainedSizeInBytes;
        if (this.columnBuilderStatus != null) {
            size += ColumnBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    public ColumnBuilder newColumnBuilderLike(ColumnBuilderStatus columnBuilderStatus) {
        return new BinaryColumnBuilder(columnBuilderStatus, ColumnUtil.calculateBlockResetSize(this.positionCount));
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = ColumnUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateArraysDataSize();
    }

    private void updateArraysDataSize() {
        this.arraysRetainedSizeInBytes = RamUsageEstimator.sizeOf((boolean[])this.valueIsNull) + RamUsageEstimator.sizeOf((Accountable[])this.values);
    }
}

