/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block;

import java.util.List;
import java.util.Objects;
import org.apache.tsfile.block.TsBlockBuilderStatus;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.BooleanColumnBuilder;
import org.apache.tsfile.read.common.block.column.DoubleColumnBuilder;
import org.apache.tsfile.read.common.block.column.FloatColumnBuilder;
import org.apache.tsfile.read.common.block.column.IntColumnBuilder;
import org.apache.tsfile.read.common.block.column.LongColumnBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Preconditions;

public class TsBlockBuilder {
    private static final int DEFAULT_INITIAL_EXPECTED_ENTRIES = 8;
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    private TimeColumnBuilder timeColumnBuilder;
    private ColumnBuilder[] valueColumnBuilders;
    private List<TSDataType> types;
    private TsBlockBuilderStatus tsBlockBuilderStatus;
    private int declaredPositions;
    private int maxTsBlockLineNumber = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();

    private TsBlockBuilder() {
    }

    public TsBlockBuilder(List<TSDataType> types) {
        this(8, types);
    }

    public TsBlockBuilder(int initialExpectedEntries, List<TSDataType> types) {
        this(initialExpectedEntries, DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, types);
    }

    public static TsBlockBuilder createWithOnlyTimeColumn() {
        TsBlockBuilder res = new TsBlockBuilder();
        res.tsBlockBuilderStatus = new TsBlockBuilderStatus(8);
        res.timeColumnBuilder = new TimeColumnBuilder(res.tsBlockBuilderStatus.createColumnBuilderStatus(), 8);
        res.valueColumnBuilders = new ColumnBuilder[0];
        return res;
    }

    public static TsBlockBuilder withMaxTsBlockSize(int maxTsBlockBytes, List<TSDataType> types) {
        return new TsBlockBuilder(8, maxTsBlockBytes, types);
    }

    private TsBlockBuilder(int initialExpectedEntries, int maxTsBlockBytes, List<TSDataType> types) {
        this.types = Objects.requireNonNull(types, "types is null");
        this.tsBlockBuilderStatus = new TsBlockBuilderStatus(maxTsBlockBytes);
        this.timeColumnBuilder = new TimeColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
        this.valueColumnBuilders = new ColumnBuilder[types.size()];
        block8: for (int i = 0; i < this.valueColumnBuilders.length; ++i) {
            switch (types.get(i)) {
                case BOOLEAN: {
                    this.valueColumnBuilders[i] = new BooleanColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    this.valueColumnBuilders[i] = new IntColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.valueColumnBuilders[i] = new LongColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                case FLOAT: {
                    this.valueColumnBuilders[i] = new FloatColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                case DOUBLE: {
                    this.valueColumnBuilders[i] = new DoubleColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    this.valueColumnBuilders[i] = new BinaryColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Unknown data type: " + types.get(i));
                }
            }
        }
    }

    private TsBlockBuilder(int maxTsBlockBytes, List<TSDataType> types, TimeColumnBuilder templateTimeColumnBuilder, ColumnBuilder[] templateValueColumnBuilders) {
        this.types = Objects.requireNonNull(types, "types is null");
        this.tsBlockBuilderStatus = new TsBlockBuilderStatus(maxTsBlockBytes);
        this.valueColumnBuilders = new ColumnBuilder[types.size()];
        Preconditions.checkArgument(templateValueColumnBuilders.length == types.size(), "Size of templates and types should match");
        this.timeColumnBuilder = (TimeColumnBuilder)templateTimeColumnBuilder.newColumnBuilderLike(this.tsBlockBuilderStatus.createColumnBuilderStatus());
        for (int i = 0; i < this.valueColumnBuilders.length; ++i) {
            this.valueColumnBuilders[i] = templateValueColumnBuilders[i].newColumnBuilderLike(this.tsBlockBuilderStatus.createColumnBuilderStatus());
        }
    }

    public void buildValueColumnBuilders(List<TSDataType> types) {
        this.types = Objects.requireNonNull(types, "types is null");
        this.valueColumnBuilders = new ColumnBuilder[types.size()];
        int initialExpectedEntries = this.timeColumnBuilder.getPositionCount();
        block8: for (int i = 0; i < this.valueColumnBuilders.length; ++i) {
            switch (types.get(i)) {
                case BOOLEAN: {
                    this.valueColumnBuilders[i] = new BooleanColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    this.valueColumnBuilders[i] = new IntColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.valueColumnBuilders[i] = new LongColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                case FLOAT: {
                    this.valueColumnBuilders[i] = new FloatColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                case DOUBLE: {
                    this.valueColumnBuilders[i] = new DoubleColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    this.valueColumnBuilders[i] = new BinaryColumnBuilder(this.tsBlockBuilderStatus.createColumnBuilderStatus(), initialExpectedEntries);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Unknown data type: " + types.get(i));
                }
            }
        }
    }

    public void reset() {
        if (this.isEmpty()) {
            return;
        }
        this.tsBlockBuilderStatus = new TsBlockBuilderStatus(this.tsBlockBuilderStatus.getMaxTsBlockSizeInBytes());
        this.declaredPositions = 0;
        this.timeColumnBuilder = (TimeColumnBuilder)this.timeColumnBuilder.newColumnBuilderLike(this.tsBlockBuilderStatus.createColumnBuilderStatus());
        for (int i = 0; i < this.valueColumnBuilders.length; ++i) {
            this.valueColumnBuilders[i] = this.valueColumnBuilders[i].newColumnBuilderLike(this.tsBlockBuilderStatus.createColumnBuilderStatus());
        }
    }

    public TsBlockBuilder newTsBlockBuilderLike() {
        return new TsBlockBuilder(this.tsBlockBuilderStatus.getMaxTsBlockSizeInBytes(), this.types, this.timeColumnBuilder, this.valueColumnBuilders);
    }

    public TimeColumnBuilder getTimeColumnBuilder() {
        return this.timeColumnBuilder;
    }

    public ColumnBuilder getColumnBuilder(int channel) {
        return this.valueColumnBuilders[channel];
    }

    public ColumnBuilder[] getValueColumnBuilders() {
        return this.valueColumnBuilders;
    }

    public TSDataType getType(int channel) {
        return this.types.get(channel);
    }

    public void declarePosition() {
        ++this.declaredPositions;
    }

    public void declarePositions(int deltaPositions) {
        this.declaredPositions += deltaPositions;
    }

    public boolean isFull() {
        return this.declaredPositions >= this.maxTsBlockLineNumber || this.tsBlockBuilderStatus.isFull();
    }

    public boolean isEmpty() {
        return this.declaredPositions == 0;
    }

    public int getPositionCount() {
        return this.declaredPositions;
    }

    public int getMaxTsBlockLineNumber() {
        return this.maxTsBlockLineNumber;
    }

    public void setMaxTsBlockLineNumber(int maxTsBlockLineNumber) {
        if (maxTsBlockLineNumber > 0) {
            this.maxTsBlockLineNumber = maxTsBlockLineNumber;
        }
    }

    public long getSizeInBytes() {
        return this.tsBlockBuilderStatus.getSizeInBytes();
    }

    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = this.timeColumnBuilder.getRetainedSizeInBytes();
        for (ColumnBuilder columnBuilder : this.valueColumnBuilders) {
            retainedSizeInBytes += columnBuilder.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    public TsBlock build() {
        TimeColumn timeColumn = (TimeColumn)this.timeColumnBuilder.build();
        return this.build(timeColumn);
    }

    public TsBlock build(Column timeColumn) {
        if (timeColumn.getPositionCount() != this.declaredPositions) {
            throw new IllegalStateException(String.format("Declared positions (%s) does not match time column's number of entries (%s)", this.declaredPositions, timeColumn.getPositionCount()));
        }
        Column[] columns = new Column[this.valueColumnBuilders.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.valueColumnBuilders[i].build();
            if (columns[i].getPositionCount() == this.declaredPositions) continue;
            throw new IllegalStateException(String.format("Declared positions (%s) does not match column %s's number of entries (%s)", this.declaredPositions, i, columns[i].getPositionCount()));
        }
        return TsBlock.wrapBlocksWithoutCopy(this.declaredPositions, timeColumn, columns);
    }

    public void writeNullableText(int columnIndex, String value) {
        if (value == null) {
            this.getColumnBuilder(columnIndex).appendNull();
        } else {
            this.getColumnBuilder(columnIndex).writeBinary(new Binary(value, TSFileConfig.STRING_CHARSET));
        }
    }
}

