/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.compatibility.DeserializeConfig;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.encrypt.IDecryptor;
import org.apache.tsfile.exception.encrypt.EncryptException;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.utils.BloomFilter;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TsFileMetadata {
    private BloomFilter bloomFilter;
    private Map<String, MetadataIndexNode> tableMetadataIndexNodeMap;
    private Map<String, TableSchema> tableSchemaMap;
    private boolean hasTableSchemaMapCache;
    private Map<String, String> tsFileProperties;
    private long metaOffset;
    private int propertiesOffset;
    private byte[] dataEncryptKey;
    private String encryptType;

    public static TsFileMetadata deserializeAndCacheTableSchemaMap(ByteBuffer buffer, DeserializeConfig context) {
        return TsFileMetadata.deserializeFrom(buffer, context, true);
    }

    public static TsFileMetadata deserializeWithoutCacheTableSchemaMap(ByteBuffer buffer, DeserializeConfig context) {
        return TsFileMetadata.deserializeFrom(buffer, context, false);
    }

    public static TsFileMetadata deserializeFrom(ByteBuffer buffer, DeserializeConfig context, boolean needTableSchemaMap) {
        byte[] bytes;
        TsFileMetadata fileMetaData = new TsFileMetadata();
        int startPos = buffer.position();
        int tableIndexNodeNum = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        TreeMap<String, MetadataIndexNode> tableIndexNodeMap = new TreeMap<String, MetadataIndexNode>();
        for (int i = 0; i < tableIndexNodeNum; ++i) {
            String tableName = ReadWriteIOUtils.readVarIntString(buffer);
            MetadataIndexNode metadataIndexNode = context.deviceMetadataIndexNodeBufferDeserializer.deserialize(buffer, context);
            tableIndexNodeMap.put(tableName, metadataIndexNode);
        }
        fileMetaData.setTableMetadataIndexNodeMap(tableIndexNodeMap);
        int tableSchemaNum = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        HashMap<String, TableSchema> tableSchemaMap = new HashMap<String, TableSchema>();
        for (int i = 0; i < tableSchemaNum; ++i) {
            String tableName = ReadWriteIOUtils.readVarIntString(buffer);
            TableSchema tableSchema = context.tableSchemaBufferDeserializer.deserialize(buffer, context);
            if (!needTableSchemaMap) continue;
            tableSchema.setTableName(tableName);
            tableSchemaMap.put(tableName, tableSchema);
        }
        fileMetaData.setTableSchemaMap(tableSchemaMap);
        fileMetaData.hasTableSchemaMapCache = needTableSchemaMap;
        long metaOffset = ReadWriteIOUtils.readLong(buffer);
        fileMetaData.setMetaOffset(metaOffset);
        if (buffer.hasRemaining() && (bytes = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(buffer)).length != 0) {
            int filterSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
            int hashFunctionSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
            fileMetaData.bloomFilter = BloomFilter.buildBloomFilter(bytes, filterSize, hashFunctionSize);
        }
        fileMetaData.propertiesOffset = buffer.position() - startPos;
        if (buffer.hasRemaining()) {
            int propertiesSize = ReadWriteForEncodingUtils.readVarInt(buffer);
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            for (int i = 0; i < propertiesSize; ++i) {
                String key = ReadWriteIOUtils.readVarIntString(buffer);
                String value = ReadWriteIOUtils.readVarIntString(buffer);
                propertiesMap.put(key, value);
            }
            if (!propertiesMap.containsKey("encryptLevel") || propertiesMap.get("encryptLevel") == null) {
                propertiesMap.put("encryptLevel", "0");
                propertiesMap.put("encryptType", "org.apache.tsfile.encrypt.UNENCRYPTED");
                propertiesMap.put("encryptKey", "");
            } else if (((String)propertiesMap.get("encryptLevel")).equals("0")) {
                propertiesMap.put("encryptType", "org.apache.tsfile.encrypt.UNENCRYPTED");
                propertiesMap.put("encryptKey", "");
            } else if (((String)propertiesMap.get("encryptLevel")).equals("1")) {
                if (!propertiesMap.containsKey("encryptType")) {
                    throw new EncryptException("TsfileMetadata lack of encryptType while encryptLevel is 1");
                }
                if (!propertiesMap.containsKey("encryptKey")) {
                    throw new EncryptException("TsfileMetadata lack of encryptKey while encryptLevel is 1");
                }
                if (propertiesMap.get("encryptKey") == null || ((String)propertiesMap.get("encryptKey")).isEmpty()) {
                    throw new EncryptException("TsfileMetadata null encryptKey while encryptLevel is 1");
                }
                String str = (String)propertiesMap.get("encryptKey");
                fileMetaData.dataEncryptKey = EncryptUtils.getSecondKeyFromStr(str);
                fileMetaData.encryptType = (String)propertiesMap.get("encryptType");
            } else if (((String)propertiesMap.get("encryptLevel")).equals("2")) {
                if (!propertiesMap.containsKey("encryptType")) {
                    throw new EncryptException("TsfileMetadata lack of encryptType while encryptLevel is 2");
                }
                if (!propertiesMap.containsKey("encryptKey")) {
                    throw new EncryptException("TsfileMetadata lack of encryptKey while encryptLevel is 2");
                }
                if (propertiesMap.get("encryptKey") == null || ((String)propertiesMap.get("encryptKey")).isEmpty()) {
                    throw new EncryptException("TsfileMetadata null encryptKey while encryptLevel is 2");
                }
                IDecryptor decryptor = IDecryptor.getDecryptor((String)propertiesMap.get("encryptType"), TSFileDescriptor.getInstance().getConfig().getEncryptKey().getBytes());
                String str = (String)propertiesMap.get("encryptKey");
                fileMetaData.dataEncryptKey = decryptor.decrypt(EncryptUtils.getSecondKeyFromStr(str));
                fileMetaData.encryptType = (String)propertiesMap.get("encryptType");
            } else {
                throw new EncryptException("Unsupported encryptLevel: " + (String)propertiesMap.get("encryptLevel"));
            }
            fileMetaData.tsFileProperties = propertiesMap;
        }
        return fileMetaData;
    }

    public EncryptParameter getEncryptParam() {
        if (this.dataEncryptKey == null) {
            return new EncryptParameter("org.apache.tsfile.encrypt.UNENCRYPTED", null);
        }
        return new EncryptParameter(this.encryptType, this.dataEncryptKey);
    }

    public void addProperty(String key, String value) {
        if (this.tsFileProperties == null) {
            this.tsFileProperties = new HashMap<String, String>();
        }
        this.tsFileProperties.put(key, value);
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public void setBloomFilter(BloomFilter bloomFilter) {
        this.bloomFilter = bloomFilter;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        if (this.tableMetadataIndexNodeMap != null) {
            byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.tableMetadataIndexNodeMap.size(), outputStream);
            for (Map.Entry<String, MetadataIndexNode> entry : this.tableMetadataIndexNodeMap.entrySet()) {
                byteLen += ReadWriteIOUtils.writeVar(entry.getKey(), outputStream);
                byteLen += entry.getValue().serializeTo(outputStream);
            }
        } else {
            byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(0, outputStream);
        }
        if (this.tableSchemaMap != null) {
            byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.tableSchemaMap.size(), outputStream);
            for (Map.Entry<String, Object> entry : this.tableSchemaMap.entrySet()) {
                byteLen += ReadWriteIOUtils.writeVar(entry.getKey(), outputStream);
                byteLen += ((TableSchema)entry.getValue()).serialize(outputStream);
            }
        } else {
            byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(0, outputStream);
        }
        byteLen += ReadWriteIOUtils.write(this.metaOffset, outputStream);
        byteLen = this.bloomFilter != null ? (byteLen += this.serializeBloomFilter(outputStream, this.bloomFilter)) : (byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(0, outputStream));
        byteLen += ReadWriteForEncodingUtils.writeVarInt(this.tsFileProperties != null ? this.tsFileProperties.size() : 0, outputStream);
        if (this.tsFileProperties != null) {
            for (Map.Entry<String, Object> entry : this.tsFileProperties.entrySet()) {
                byteLen += ReadWriteIOUtils.writeVar(entry.getKey(), outputStream);
                byteLen += ReadWriteIOUtils.writeVar((String)entry.getValue(), outputStream);
            }
        }
        return byteLen;
    }

    public int serializeBloomFilter(OutputStream outputStream, BloomFilter filter) throws IOException {
        int byteLen = 0;
        byte[] bytes = filter.serialize();
        byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(bytes.length, outputStream);
        if (bytes.length > 0) {
            outputStream.write(bytes);
            byteLen += bytes.length;
            byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(filter.getSize(), outputStream);
            byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(filter.getHashFunctionSize(), outputStream);
        }
        return byteLen;
    }

    public long getMetaOffset() {
        return this.metaOffset;
    }

    public void setMetaOffset(long metaOffset) {
        this.metaOffset = metaOffset;
    }

    public void setTableMetadataIndexNodeMap(Map<String, MetadataIndexNode> tableMetadataIndexNodeMap) {
        this.tableMetadataIndexNodeMap = tableMetadataIndexNodeMap;
    }

    public void setTableSchemaMap(Map<String, TableSchema> tableSchemaMap) {
        this.tableSchemaMap = tableSchemaMap;
        this.hasTableSchemaMapCache = true;
    }

    public Map<String, MetadataIndexNode> getTableMetadataIndexNodeMap() {
        return this.tableMetadataIndexNodeMap;
    }

    public MetadataIndexNode getTableMetadataIndexNode(String tableName) {
        MetadataIndexNode metadataIndexNode = this.tableMetadataIndexNodeMap.get(tableName);
        if (metadataIndexNode == null) {
            metadataIndexNode = this.tableMetadataIndexNodeMap.get("");
        }
        return metadataIndexNode;
    }

    public boolean hasTableSchemaMapCache() {
        return this.hasTableSchemaMapCache;
    }

    public Map<String, TableSchema> getTableSchemaMap() {
        return this.tableSchemaMap;
    }

    public Map<String, String> getTsFileProperties() {
        return this.tsFileProperties;
    }
}

