/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.broker;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeSubtaskExecutorManager;
import org.apache.iotdb.db.pipe.event.UserDefinedEnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.terminate.PipeTerminateEvent;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.subscription.broker.SubscriptionBlockingPendingQueue;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueueStates;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeEventBatches;
import org.apache.iotdb.db.subscription.resource.SubscriptionDataNodeResourceManager;
import org.apache.iotdb.db.subscription.task.subtask.SubscriptionReceiverSubtask;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.rpc.subscription.payload.poll.ErrorPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.apache.tsfile.utils.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubscriptionPrefetchingQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPrefetchingQueue.class);
    private final String brokerId;
    private final String topicName;
    private final SubscriptionBlockingPendingQueue inputPendingQueue;
    private final AtomicLong commitIdGenerator;
    protected final PriorityBlockingQueue<SubscriptionEvent> prefetchingQueue;
    protected final Map<Pair<String, SubscriptionCommitContext>, SubscriptionEvent> inFlightEvents;
    protected final SubscriptionPipeEventBatches batches;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final SubscriptionPrefetchingQueueStates states;
    private volatile boolean isCompleted = false;
    private volatile boolean isClosed = false;
    private final RemappingFunction<SubscriptionEvent> committedCleaner = ev -> {
        if (ev.isCommitted()) {
            ev.cleanUp(false);
            return null;
        }
        return ev;
    };
    private final RemappingFunction<SubscriptionEvent> pollableNacker = ev -> {
        if (ev.eagerlyPollable()) {
            ev.nack();
            this.prefetchEvent((SubscriptionEvent)ev);
            return null;
        }
        if (ev.pollable()) {
            ev.nack();
            this.prefetchEvent((SubscriptionEvent)ev);
            LOGGER.warn("Subscription: SubscriptionPrefetchingQueue {} recycle event {} from in flight events, nack and enqueue it to prefetching queue", (Object)this, ev);
            return null;
        }
        return ev;
    };
    private final RemappingFunction<SubscriptionEvent> responsePrefetcher = ev -> {
        try {
            ev.prefetchRemainingResponses();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ev;
    };
    private final RemappingFunction<SubscriptionEvent> responseSerializer = ev -> {
        try {
            ev.trySerializeCurrentResponse();
            ev.trySerializeRemainingResponses();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ev;
    };

    public SubscriptionPrefetchingQueue(String brokerId, String topicName, SubscriptionBlockingPendingQueue inputPendingQueue, AtomicLong commitIdGenerator, int maxDelayInMs, long maxBatchSizeInBytes) {
        this.brokerId = brokerId;
        this.topicName = topicName;
        this.inputPendingQueue = inputPendingQueue;
        this.commitIdGenerator = commitIdGenerator;
        this.prefetchingQueue = new PriorityBlockingQueue();
        this.inFlightEvents = new ConcurrentHashMap<Pair<String, SubscriptionCommitContext>, SubscriptionEvent>();
        this.batches = new SubscriptionPipeEventBatches(this, maxDelayInMs, maxBatchSizeInBytes);
        this.states = new SubscriptionPrefetchingQueueStates(this);
    }

    public void cleanUp() {
        this.acquireWriteLock();
        try {
            this.cleanUpInternal();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected void cleanUpInternal() {
        this.batches.cleanUp();
        this.prefetchingQueue.forEach(event -> event.cleanUp(true));
        this.prefetchingQueue.clear();
        this.inFlightEvents.values().forEach(event -> event.cleanUp(true));
        this.inFlightEvents.clear();
    }

    protected void acquireReadLock() {
        this.lock.readLock().lock();
    }

    protected void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    protected void acquireWriteLock() {
        this.lock.writeLock().lock();
    }

    protected void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    protected void executeReceiverSubtask(SubscriptionReceiverSubtask subtask, long timeoutMs) throws Exception {
        PipeSubtaskExecutorManager.getInstance().getSubscriptionExecutor().executeReceiverSubtask(subtask, timeoutMs);
    }

    public SubscriptionEvent poll(String consumerId) {
        this.acquireReadLock();
        try {
            SubscriptionEvent subscriptionEvent = this.isClosed() ? null : this.pollInternal(consumerId);
            return subscriptionEvent;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public SubscriptionEvent pollInternal(String consumerId) {
        this.states.markPollRequest();
        if (this.prefetchingQueue.isEmpty()) {
            this.states.markMissingPrefetch();
            try {
                this.executeReceiverSubtask(() -> {
                    this.tryPrefetch();
                    return null;
                }, SubscriptionAgent.receiver().remainingMs());
            }
            catch (Exception e) {
                LOGGER.warn("Exception {} occurred when {} execute receiver subtask", new Object[]{this, e, e});
            }
        }
        if (this.prefetchingQueue.isEmpty()) {
            this.onEvent();
        }
        long size = this.prefetchingQueue.size();
        long count = 0L;
        try {
            SubscriptionEvent event;
            while (count++ < size && Objects.nonNull(event = this.prefetchingQueue.poll(SubscriptionConfig.getInstance().getSubscriptionPollMaxBlockingTimeMs(), TimeUnit.MILLISECONDS))) {
                if (event.isCommitted()) {
                    LOGGER.warn("Subscription: SubscriptionPrefetchingQueue {} poll committed event {} from prefetching queue (broken invariant), remove it", (Object)this, (Object)event);
                    continue;
                }
                if (!event.pollable()) {
                    LOGGER.warn("Subscription: SubscriptionPrefetchingQueue {} poll non-pollable event {} from prefetching queue (broken invariant), nack and remove it", (Object)this, (Object)event);
                    event.nack();
                    continue;
                }
                event.recordLastPolledTimestamp();
                this.inFlightEvents.put((Pair<String, SubscriptionCommitContext>)new Pair((Object)consumerId, (Object)event.getCommitContext()), event);
                event.recordLastPolledConsumerId(consumerId);
                return event;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Subscription: SubscriptionPrefetchingQueue {} interrupted while polling events.", (Object)this, (Object)e);
        }
        return null;
    }

    public boolean executePrefetch() {
        this.acquireReadLock();
        try {
            if (this.isClosed()) {
                boolean bl = false;
                return bl;
            }
            this.reportStateIfNeeded();
            if (this.states.shouldPrefetch()) {
                this.tryPrefetch();
                this.remapInFlightEventsSnapshot(this.committedCleaner, this.pollableNacker, this.responsePrefetcher, this.responseSerializer);
                boolean bl = true;
                return bl;
            }
            this.remapInFlightEventsSnapshot(this.committedCleaner, this.pollableNacker);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void reportStateIfNeeded() {
        SubscriptionDataNodeResourceManager.log().schedule(SubscriptionPrefetchingQueue.class, this.brokerId, this.topicName).ifPresent(l -> l.info("Subscription: SubscriptionPrefetchingQueue state {}", (Object)this));
    }

    @SafeVarargs
    private final void remapInFlightEventsSnapshot(RemappingFunction<SubscriptionEvent> ... functions) {
        for (Pair pair : ImmutableSet.copyOf(this.inFlightEvents.keySet())) {
            this.inFlightEvents.compute((Pair<String, SubscriptionCommitContext>)pair, (key, ev) -> SubscriptionPrefetchingQueue.COMBINER(functions).remap((SubscriptionEvent)ev));
        }
    }

    public void prefetchEvent(@NonNull SubscriptionEvent thisEvent) {
        SubscriptionEvent thatEvent = this.prefetchingQueue.peek();
        if (Objects.nonNull(thatEvent) && thisEvent.compareTo(thatEvent) < 0) {
            this.states.markDisorderCause();
        }
        this.prefetchingQueue.add(thisEvent);
    }

    private void tryPrefetch() {
        while (!this.inputPendingQueue.isEmpty()) {
            Event event = UserDefinedEnrichedEvent.maybeOf(this.inputPendingQueue.waitedPoll());
            if (Objects.isNull(event)) continue;
            if (!(event instanceof EnrichedEvent)) {
                LOGGER.warn("Subscription: SubscriptionPrefetchingQueue {} only support prefetch EnrichedEvent. Ignore {}.", (Object)this, (Object)event);
                continue;
            }
            if (event instanceof PipeTerminateEvent) {
                PipeTerminateEvent terminateEvent = (PipeTerminateEvent)event;
                terminateEvent.addOnCommittedHook(() -> {
                    this.markCompleted();
                    return null;
                });
                ((PipeTerminateEvent)event).decreaseReferenceCount(SubscriptionPrefetchingQueue.class.getName(), true);
                LOGGER.info("Subscription: SubscriptionPrefetchingQueue {} commit PipeTerminateEvent {}", (Object)this, (Object)terminateEvent);
                continue;
            }
            if (event instanceof TabletInsertionEvent) {
                if (!this.onEvent((TabletInsertionEvent)event)) continue;
                return;
            }
            if (event instanceof TsFileInsertionEvent) {
                if (!this.onEvent((TsFileInsertionEvent)event)) continue;
                return;
            }
            LOGGER.info("Subscription: SubscriptionPrefetchingQueue {} ignore EnrichedEvent {} when prefetching.", (Object)this, (Object)event);
            ((EnrichedEvent)event).decreaseReferenceCount(SubscriptionPrefetchingQueue.class.getName(), false);
            if (!this.onEvent()) continue;
            return;
        }
    }

    protected abstract boolean onEvent(TsFileInsertionEvent var1);

    protected boolean onEvent(TabletInsertionEvent event) {
        return this.batches.onEvent((EnrichedEvent)event, this::prefetchEvent);
    }

    protected boolean onEvent() {
        return this.batches.onEvent(this::prefetchEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ack(String consumerId, SubscriptionCommitContext commitContext) {
        this.acquireReadLock();
        try {
            boolean bl = !this.isClosed() && this.ackInternal(consumerId, commitContext);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean ackInternal(String consumerId, SubscriptionCommitContext commitContext) {
        AtomicBoolean acked = new AtomicBoolean(false);
        this.inFlightEvents.compute((Pair<String, SubscriptionCommitContext>)new Pair((Object)consumerId, (Object)commitContext), (key, ev) -> {
            if (Objects.isNull(ev)) {
                LOGGER.warn("Subscription: subscription commit context {} does not exist, it may have been committed or something unexpected happened, prefetching queue: {}", (Object)commitContext, (Object)this);
                return null;
            }
            if (ev.isCommitted()) {
                LOGGER.warn("Subscription: subscription event {} is committed, subscription commit context {}, prefetching queue: {}", new Object[]{ev, commitContext, this});
                ev.cleanUp(false);
                return null;
            }
            if (!ev.isCommittable()) {
                LOGGER.warn("Subscription: subscription event {} is not committable, subscription commit context {}, prefetching queue: {}", new Object[]{ev, commitContext, this});
                return ev;
            }
            String consumerGroupId = commitContext.getConsumerGroupId();
            if (!Objects.equals(consumerGroupId, this.brokerId)) {
                LOGGER.warn("inconsistent consumer group when acking event, current: {}, incoming: {}, consumer id: {}, event commit context: {}, prefetching queue: {}, commit it anyway...", new Object[]{this.brokerId, consumerGroupId, consumerId, commitContext, this});
            }
            ev.ack();
            ev.recordCommittedTimestamp();
            acked.set(true);
            ev.cleanUp(false);
            return null;
        });
        return acked.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nack(String consumerId, SubscriptionCommitContext commitContext) {
        this.acquireReadLock();
        try {
            boolean bl = !this.isClosed() && this.nackInternal(consumerId, commitContext);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean nackInternal(String consumerId, SubscriptionCommitContext commitContext) {
        AtomicBoolean nacked = new AtomicBoolean(false);
        this.inFlightEvents.compute((Pair<String, SubscriptionCommitContext>)new Pair((Object)consumerId, (Object)commitContext), (key, ev) -> {
            if (Objects.isNull(ev)) {
                LOGGER.warn("Subscription: subscription commit context [{}] does not exist, it may have been committed or something unexpected happened, prefetching queue: {}", (Object)commitContext, (Object)this);
                return null;
            }
            String consumerGroupId = commitContext.getConsumerGroupId();
            if (!Objects.equals(consumerGroupId, this.brokerId)) {
                LOGGER.warn("inconsistent consumer group when nacking event, current: {}, incoming: {}, consumer id: {}, event commit context: {}, prefetching queue: {}, commit it anyway...", new Object[]{this.brokerId, consumerGroupId, consumerId, commitContext, this});
            }
            ev.nack();
            nacked.set(true);
            return ev;
        });
        return nacked.get();
    }

    public SubscriptionCommitContext generateSubscriptionCommitContext() {
        return new SubscriptionCommitContext(IoTDBDescriptor.getInstance().getConfig().getDataNodeId(), PipeDataNodeAgent.runtime().getRebootTimes(), this.topicName, this.brokerId, this.commitIdGenerator.getAndIncrement());
    }

    protected SubscriptionEvent generateSubscriptionPollErrorResponse(String errorMessage) {
        return new SubscriptionEvent(SubscriptionPollResponseType.ERROR.getType(), (SubscriptionPollPayload)new ErrorPayload(errorMessage, false), new SubscriptionCommitContext(IoTDBDescriptor.getInstance().getConfig().getDataNodeId(), PipeDataNodeAgent.runtime().getRebootTimes(), this.topicName, this.brokerId, -1L));
    }

    public String getPrefetchingQueueId() {
        return SubscriptionPrefetchingQueue.generatePrefetchingQueueId(this.brokerId, this.topicName);
    }

    public static String generatePrefetchingQueueId(String consumerGroupId, String topicName) {
        return consumerGroupId + "_" + topicName;
    }

    public long getSubscriptionUncommittedEventCount() {
        return this.inFlightEvents.size();
    }

    public long getCurrentCommitId() {
        return this.commitIdGenerator.get();
    }

    public int getPipeEventCount() {
        return this.inputPendingQueue.size() + this.prefetchingQueue.stream().map(SubscriptionEvent::getPipeEventCount).reduce(Integer::sum).orElse(0) + this.inFlightEvents.values().stream().map(SubscriptionEvent::getPipeEventCount).reduce(Integer::sum).orElse(0);
    }

    public int getPrefetchedEventCount() {
        return this.prefetchingQueue.size();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void markClosed() {
        this.isClosed = true;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void markCompleted() {
        this.isCompleted = true;
    }

    public Map<String, String> coreReportMessage() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("brokerId", this.brokerId);
        result.put("topicName", this.topicName);
        result.put("size of inputPendingQueue", String.valueOf(this.inputPendingQueue.size()));
        result.put("size of prefetchingQueue", String.valueOf(this.prefetchingQueue.size()));
        result.put("size of inFlightEvents", String.valueOf(this.inFlightEvents.size()));
        result.put("commitIdGenerator", this.commitIdGenerator.toString());
        result.put("states", this.states.toString());
        result.put("isCompleted", String.valueOf(this.isCompleted));
        result.put("isClosed", String.valueOf(this.isClosed));
        return result;
    }

    public Map<String, String> allReportMessage() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("brokerId", this.brokerId);
        result.put("topicName", this.topicName);
        result.put("size of inputPendingQueue", String.valueOf(this.inputPendingQueue.size()));
        result.put("prefetchingQueue", this.prefetchingQueue.toString());
        result.put("inFlightEvents", this.inFlightEvents.toString());
        result.put("commitIdGenerator", this.commitIdGenerator.toString());
        result.put("states", this.states.toString());
        result.put("isCompleted", String.valueOf(this.isCompleted));
        result.put("isClosed", String.valueOf(this.isClosed));
        return result;
    }

    @SafeVarargs
    private static @NonNull RemappingFunction<SubscriptionEvent> COMBINER(RemappingFunction<SubscriptionEvent> ... functions) {
        return ev -> {
            if (Objects.isNull(ev)) {
                return null;
            }
            for (RemappingFunction function : functions) {
                if (!Objects.isNull(function.remap(ev))) continue;
                return null;
            }
            return ev;
        };
    }

    @FunctionalInterface
    private static interface RemappingFunction<V> {
        public V remap(V var1);
    }
}

