/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.util;

import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.input.IUDFInputDataSet;
import org.apache.iotdb.db.queryengine.transformation.datastructure.row.ElasticSerializableRowList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.TimeColumn;

public class LayerCacheUtils {
    private LayerCacheUtils() {
    }

    public static YieldableState yieldPoints(LayerReader source, ElasticSerializableTVList target) throws Exception {
        YieldableState yieldableState = source.yield();
        if (yieldableState != YieldableState.YIELDABLE) {
            return yieldableState;
        }
        Column[] columns = source.current();
        target.putColumn((Column)((TimeColumn)columns[1]), columns[0]);
        source.consumedAll();
        return YieldableState.YIELDABLE;
    }

    public static YieldableState yieldPoints(LayerReader source, ElasticSerializableTVList target, int count) throws Exception {
        while (count > 0) {
            YieldableState yieldableState = source.yield();
            if (yieldableState != YieldableState.YIELDABLE) {
                return yieldableState;
            }
            Column[] columns = source.current();
            target.putColumn((Column)((TimeColumn)columns[1]), columns[0]);
            source.consumedAll();
            int size = columns[0].getPositionCount();
            count -= size;
        }
        return YieldableState.YIELDABLE;
    }

    public static YieldableState yieldRows(IUDFInputDataSet source, ElasticSerializableRowList target, int count) throws Exception {
        while (count > 0) {
            YieldableState yieldableState = source.yield();
            if (yieldableState != YieldableState.YIELDABLE) {
                return yieldableState;
            }
            Column[] columns = source.currentBlock();
            target.put(columns);
            int size = columns[0].getPositionCount();
            count -= size;
        }
        return YieldableState.YIELDABLE;
    }
}

